;;;
;;;              Copyright 1991 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;;
;;; scrollbar.sc -- a first implementation of a scrollbar in SCIX.
;;;
;;; Scrollbar -- It is beginning to work, but the implementation is probably
;;;              optimized for slowness.
;;; Problems:
;;; 1) Speed? I checked and the Xaw scrollbar does not use a
;;;    separate window for the thumb and ConfigureWindow for
;;;    moving, but rather painted it with PolyFillRectangle.
;;;    I suggest we save that until this simpler version works.
;;; 2) How get the MotionNotify event as long as Btn2 is pressed?
;;;    It is difficult to keep the pointer inside the scrollbar
;;;    while moving. But Xaw/Scroll* does no grabs at all...
;;;    (This is now working, but by what seems to be another
;;;    way than Xaw does it.)
;;; 3) Automatic resize to adjust to parent. Easy?
;;; 4) Horizontal scrollbar.

;;; $Id: scrollbar.sc,v 2.2 91/09/15 00:58:28 johani Exp $

(module stoxscrollbar)

(include "../include/masks.sch")
(include "../include/objects.sch")
(include "../include/lw-objs.sch")
(include "../include/util.sch")

(define-external dfsm stoxdfsm)
(define-external widget stoxwidget)

(include "../macros/extsyntax.sc")
(include "../macros/oos.sc")

(define-class (scrollbar . args)
  (locals
   (parent (match-arg 'parent 'no-default args))
   (scr (parent 'screen))
   (width (match-arg 'width 15 args))
   (height (match-arg 'height (parent 'height) args))
   (curfont (font 'make 'screen scr 'fontname "cursor"))
   (wants-moves '())
   (thumb #f) (thumb-height (- height 2)) (thumb-y 1)
   (thumb-mask (make-configure-value-mask `(x 1) `(y 1)))
   (the-cursor (cursor 'make 'screen scr 'glyph 'source curfont 'mask curfont
		       'source-char 116 'mask-char 117)) ; sb_v_double_arrow
   (semantics
    `(((Ready . MotionNotify)
       Ready
       ,(let ((new-y 0) (percent 0) (old-thumb-y 1))
	  (lambda (e)
	    (set! new-y (e 'event-y))
	    (if ((e 'state) 'set? 'button2)
		(begin
		  (cond ((<= new-y 1)
			 (set! thumb-y 1)
			 (set! percent 0) )
			((>= new-y (- height thumb-height 1))
			 (set! thumb-y (- height thumb-height 1))
			 (set! percent 1) )
			(else
			 (set! thumb-y new-y)
			 (set! percent (/ new-y height)) ))
		  (if (not (= thumb-y old-thumb-y))
		      (begin
			(set! old-thumb-y thumb-y)
			(thumb-mask 'set! `(y ,thumb-y))
			(thumb 'configurewindow thumb-mask)
			(for-each (lambda (o) (o percent))
				  wants-moves) )) ))))) ))
   )
  (inherit
   (widget (cons* 'dfsm-data (list 'Ready #f semantics)
		  'height height 'width width 
		  'x (if (zero? (parent 'border-width))
			 0
			 -1)
		  'y (if (zero? (parent 'border-width))
			 0
			 -1)      ;; This is specific for a vertical scrollbar.
		  'border-width 1
		  'value-mask
		  (make-window-value-mask
		   `(background-pixel ,(scr 'whitepixel))
		   `(event-mask ,(make-bitmask 'event 'Button2Motion))
			       `(cursor ,the-cursor) )
		  args)) )
  (methods
   (stox-activate (lambda ()
		    (thumb 'mapwindow)
		    (me 'mapwindow) ))
   (stox-notify-move (lambda (o)
		       (set! wants-moves (cons o wants-moves)) ))

   ;; stox-percentage -- Not yet independent of horizontal/vertical mode.
   ;; Note: The height value should probably be removed from the mask
   ;;       after the ConfigureWindow.
   (stox-thumb-percent (lambda (p)
			 (set! thumb-height (inexact->exact (* p height)))
			 (thumb-mask 'set! `(height ,thumb-height))
			 (thumb 'configurewindow thumb-mask) ))
   ;; stox-set-thumb -- Position the thumb p percent down in the scrollbar.
   (stox-set-thumb (lambda (p)
		     (set! thumb-y (inexact->exact (* p height)))
		     (thumb-mask 'set! `(y ,thumb-y))
		     (thumb 'configurewindow thumb-mask) ))
   )
  (init
   (curfont 'closefont)
   (set! thumb (window 'make 'screen scr 'parent me 'x 1 'y 1
		       'width (- width 2) 'height thumb-height
		       'mask (make-window-value-mask
			      `(background-pixel ,(scr 'blackpixel)) )))
    (me 'grabbutton #f (make-mask 'pointerevent 'ButtonPress
				  'ButtonRelease 'PointerMotion)
	'Asynchronous 'Asynchronous 'None 'None 2 (make-mask 'keymask) scr)
   ))
