;;;
;;;              Copyright 1990 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;
;;;    $Id: graph-obj.sc,v 1.4 91/09/15 01:13:21 johani Exp $

;;; SCIX Graphic objects.

;;; Request #64: PolyPoint -- coord-mode is in '(origin previous)
(define-class (polypoint coord-mode point-list)
  (methods
   (draw (lambda (the-gc drawable . rest)
	   (send-polypoint drawable the-gc coord-mode
			   point-list (the-gc 'screen) rest) ))
   (add! (lambda (point-l)
	   (set! point-list (if (pair? (car point-l))
				(append point-l point-list)
				(cons point-l point-list) )))) ))

;;; Request #65: PolyLine -- coord-mode is in '(origin previous)
(define-class (polyline coord-mode point-list)
  (methods
   (draw (lambda (the-gc drawable . rest)
	   (send-polyline drawable the-gc coord-mode
			  point-list (the-gc 'screen) rest) ))
   (add! (lambda (point-l)
	   (set! point-list (if (pair? (car point-l))
				(append point-l point-list)
				(cons point-l point-list) )))) ))

;;; Request #66: PolySegment -- segment-lists are like '((x1 y1 x2 y2) ...)
(define-class (polysegment seg-list)
  (methods
   (draw (lambda (the-gc drawable . rest)
	   (send-polysegment drawable the-gc seg-list
			     (the-gc 'screen) rest) ))
   (add! (lambda (seg-l)
	   (set! seg-list (if (pair? (car seg-l))
				(append seg-l seg-list)
				(cons seg-l seg-list) )))) ))

;;; Request #67: PolyRectangle -- rectangle-lists are like '((x1 y1 w h) ...)
(define-class (polyrectangle rectangle-list)
  (methods
   (draw (lambda (the-gc drawable . rest)
	   (send-polyrectangle drawable the-gc
			       rectangle-list (the-gc 'screen) rest) ))
   (add! (lambda (rect)
	   (set! rectangle-list (if (pair? (car rect))
				    (append rect rectangle-list)
				    (cons rect rectangle-list) )))) ))
   
;;; Request #68: PolyArc -- arc-lists are like '((x y w h ang1 ang2) ...)
(define-class (polyarc arc-list)
  (methods
   (draw (lambda (the-gc drawable . rest)
	   (send-polyarc drawable the-gc arc-list (the-gc 'screen) rest) ))
   (add! (lambda (arc-l)
	   (set! arc-list (if (pair? (car arc-l))
			      (append arc-l arc-list)
				    (cons arc-l arc-list) )))) ))

;;; Request #69: FillPoly -- shape is in '(complex nonconvex convex)
;;;                       -- coord-mode is in '(origin previous)
(define-class (fillpoly shape coord-mode point-list)
  (methods
   (draw (lambda (the-gc drawable . rest)
	   (send-fillpoly drawable the-gc shape coord-mode
			  point-list (the-gc 'screen) rest) ))
   ;; The use for the option to add points to a polygon is uncertain.
   (add! (lambda (point-l)
	   (set! point-list (if (pair? (car point-l))
				(append point-l point-list)
				(cons point-l point-list) )))) ))

;;; Request #70: PolyFillRectangle -- rectangle-lists: '((x1 y1 w h) ...)
(define-class (polyfillrectangle rectangle-list)
  (methods
   (draw (lambda (the-gc drawable . rest)
	   (send-polyfillrectangle drawable the-gc
				   rectangle-list (the-gc 'screen) rest) ))
   ;; add! -- can add one or more rects at a time.
   (add! (lambda (rect)
	   (set! rectangle-list (if (pair? (car rect))
				    (append rect rectangle-list)
				    (cons rect rectangle-list) ))))
   ;; remove! -- can only remove one rect at a time.
   (remove! (lambda (rect)
	      (set! rectangle-list (remove! rect rectangle-list) ) ))))

;;; Request #71: PolyFillArc -- arc-lists are like '((x y w h ang1 ang2) ...)
(define-class (polyfillarc arc-list)
  (methods
   (draw (lambda (the-gc drawable . rest)
	   (send-polyfillarc drawable the-gc
			     arc-list (the-gc 'screen) rest) ))) )

;;; Note: PolyText and make-textitem should be united into one contructor...

;;; Request #74: PolyText8 -- items are generated by (make-textitem ...)
(define-class (polytext8 x y items)
  (methods
   (draw (lambda (the-gc drawable . rest)
	   (send-polytext8 drawable the-gc x y
			   items (the-gc 'screen) rest) ))) )

;;; Request #75: PolyText16 -- items are generated by (make-textitem ...)
(define-class (polytext16 x y items)
  (methods
   (draw (lambda (the-gc drawable . rest)
	   (send-polytext16 drawable the-gc x y
			    items (the-gc 'screen) rest) ))) )

;;; Request #76: ImageText8
;;; Note: the 'set-pos! and 'set-text! method is highly experimental.
(define-class (imagetext8 x y string)
  (methods
   (draw (lambda (the-gc drawable . rest)
	   (send-imagetext8 drawable the-gc x y string (the-gc 'screen) rest)))
   (set-pos! (lambda (newx newy)
	       (set! x newx)
	       (set! y newy) ))
   (set-text! (lambda (str)
		(set! string str) )) ))

;;; Request #77: ImageText16
(define-class (imagetext16 x y string)
  (methods
   (draw (lambda (the-gc drawable . rest)
	   (send-imagetext16 drawable the-gc x y
			     string (the-gc 'screen) rest)))) )

;;; We have not yet had time to experiment with String16's.

