;;;
;;;              Copyright 1990 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;; $Id: formats.sc,v 1.4 91/07/25 16:49:01 johani Exp $

;;; formats.sc -- event- and error-formats used for lookup by the disassembler.

;;; *error-names* -- Vector to be indexed by error-number containing name
;;;                  of error and "additional info" (the second byte of the
;;;                  error).
(define *error-names* (vector '(no-error       . unused)
			      '(request        . unused)
			      '(value          . bad-value)
			      '(window         . bad-resource-id)
			      '(pixmap         . bad-resource-id)
			      '(atom           . bad-atom-id)
			      '(cursor         . bad-resource-id)
			      '(font           . bad-resource-id)
			      '(match          . unused)
			      '(drawable       . bad-resource-id)
			      '(access         . unused)
			      '(alloc          . unused)
			      '(colormap       . bad-resource-id)
			      '(gcontext       . bad-resource-id)
			      '(idchoice       . bad-resource-id)
			      '(name           . unused)
			      '(length         . unused)
			      '(implementation . unused) ))

;;; formats for the different X events for use by make-event.
;;;                     NOTE: The initial byte (indicating event type) should
;;;                     NOT be parsed here. It should be masked off in the
;;;                     routine that calls make-event.
(define *event-formats*
  `#(() ()
;;; Event #2: KeyPress
     ((display sent-event? event-name detail seq-nr time root event child
       root-x root-y event-x event-y state same-screen)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name  . ,(d-identity 'keypress))
      (detail      . ,d-keycode)
      (seq-nr      . ,d-card16)
      (time        . ,d-timestamp)
      (root        . ,d-window)
      (event       . ,d-window)
      (child       . ,(d-const #f d-window '((0 . None))))
      (root-x      . ,d-int16)
      (root-y      . ,d-int16)
      (event-x     . ,d-int16)
      (event-y     . ,d-int16)
      (state       . ,d-setofkeybutmask)
      (same-screen . ,d-bool)
      (unused      . ,(d-unused 1)) )
;;; Event #3: KeyRelease
     ((display sent-event? event-name detail seq-nr time root event child
       root-x root-y event-x event-y state same-screen)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name  . ,(d-identity 'keyrelease))
      (detail      . ,d-keycode)
      (seq-nr      . ,d-card16)
      (time        . ,d-timestamp)
      (root        . ,d-window)
      (event       . ,d-window)
      (child       . ,(d-const #f d-window '((0 . None))))
      (root-x      . ,d-int16)
      (root-y      . ,d-int16)
      (event-x     . ,d-int16)
      (event-y     . ,d-int16)
      (state       . ,d-setofkeybutmask)
      (same-screen . ,d-bool)
      (unused      . ,d-card8) )
;;; Event #4: ButtonPress
     ((display sent-event? event-name detail seq-nr time root event child
       root-x root-y event-x event-y state same-screen)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name  . ,(d-identity 'buttonpress))
      (detail      . ,d-button)
      (seq-nr      . ,d-card16)
      (time        . ,d-timestamp)
      (root        . ,d-window)
      (event       . ,d-window)
      (child       . ,(d-const #f d-window '((0 . None))))
      (root-x      . ,d-int16)
      (root-y      . ,d-int16)
      (event-x     . ,d-int16)
      (event-y     . ,d-int16)
      (state       . ,d-setofkeybutmask)
      (same-screen . ,d-bool)
      (unused      . ,d-card8) )
;;; Event #5: ButtonRelease
     ((display sent-event? event-name detail seq-nr time root event child
       root-x root-y event-x event-y state same-screen)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name  . ,(d-identity 'buttonrelease))
      (detail      . ,d-button)
      (seq-nr      . ,d-card16)
      (time        . ,d-timestamp)
      (root        . ,d-window)
      (event       . ,d-window)
      (child       . ,(d-const #f d-window '((0 . None))))
      (root-x      . ,d-int16)
      (root-y      . ,d-int16)
      (event-x     . ,d-int16)
      (event-y     . ,d-int16)
      (state       . ,d-setofkeybutmask)
      (same-screen . ,d-bool)
      (unused      . ,d-card8) )
;;; Event #6: MotionNotify
     ((display sent-event? event-name detail seq-nr time root
       event child root-x root-y event-x event-y state same-screen)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name  . ,(d-identity 'MotionNotify))
      (detail      . ,(d-const #t d-card8 '((0 . Normal)
					    (1 . Hint))))
      (seq-nr      . ,d-card16)
      (time        . ,d-timestamp)
      (root        . ,d-window)
      (event       . ,d-window)
      (child       . ,(d-const #f d-window '((0 . None))))
      (root-x      . ,d-int16)
      (root-y      . ,d-int16)
      (event-x     . ,d-int16)
      (event-y     . ,d-int16)
      (state       . ,d-setofkeybutmask)
      (same-screen . ,d-bool)
      (unused      . ,d-card8) )
;;; Event #7: EnterNotify
;;; Note: Since one byte is used for both same-screen and focus, we are
;;;       forced to use the lowlevel functions bit-and and peek-next-byte here.
     ((display sent-event? event-name detail seq-nr time root event
       child root-x root-y event-x event-y state mode same-screen focus)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name  . ,(d-identity 'enternotify))
      (detail      . ,(d-const #t d-card8 '((0 . Ancestor)
					    (1 . Virtual)
					    (2 . Inferior)
					    (3 . Nonlinear)
					    (4 . NonlinearVirtual) )))
      (seq-nr      . ,d-card16)
      (time        . ,d-timestamp)
      (root        . ,d-window)
      (event       . ,d-window)
      (child       . ,(d-const #f d-window '((0 . None))))
      (root-x      . ,d-int16)
      (root-y      . ,d-int16)
      (event-x     . ,d-int16)
      (event-y     . ,d-int16)
      (state       . ,d-setofkeybutmask)
      (mode        . ,(d-const #t d-card8 '((0 . Normal)
					    (1 . Grab)
					    (2 . Ungrab) )))
      (same-screen . ,(lambda (str dpy)
		       (= (bit-and (peek-next-byte str) 1) 1) ))
      (focus       . ,(lambda (str dpy)
			(= (bit-and (d-card8 str dpy) 2) 2) )))
;;; Event #8: LeaveNotify
     ((display sent-event? event-name detail seq-nr time root event child
       root-x root-y event-x event-y state mode same-screen focus)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name  . ,(d-identity 'leavenotify))
      (detail      . ,(d-const #t d-card8 '((0 . Ancestor)
					    (1 . Virtual)
					    (2 . Inferior)
					    (3 . Nonlinear)
					    (4 . NonlinearVirtual) )))
      (seq-nr      . ,d-card16)
      (time        . ,d-timestamp)
      (root        . ,d-window)
      (event       . ,d-window)
      (child       . ,(d-const #f d-window '((0 . None))))
      (root-x      . ,d-int16)
      (root-y      . ,d-int16)
      (event-x     . ,d-int16)
      (event-y     . ,d-int16)
      (state       . ,d-setofkeybutmask)
      (mode        . ,(d-const #t d-card8 '((0 . Normal)
					    (1 . Grab)
					    (2 . Ungrab) )))
      (same-screen . ,(lambda (str dpy)
			(= (bit-and (peek-next-byte str) 1) 1) ))
      (focus       . ,(lambda (str dpy)
			(= (bit-and (d-card8 str dpy) 2) 2) )))
;;; Event #9: FocusIn
     ((display sent-event? event-name detail seq-nr event mode)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name  . ,(d-identity 'focusin))
      (detail      . ,(d-const #t d-card8 '((0 . Ancestor)
					    (1 . Virtual)
					    (2 . Inferior)
					    (3 . Nonlinear)
					    (4 . NonlinearVirtual)
					    (5 . Pointer)
					    (6 . PointerRoot)
					    (7 . None) )))
      (seq-nr      . ,d-card16)
      (event       . ,d-window)
      (mode        . ,(d-const #t d-card8 '((0 . Normal)
					    (1 . Grab)
					    (2 . Ungrab)
					    (3 . WhileGrabbed) )))
      (unused      . ,(d-unused 23)) )
;;; Event #10: FocusOut
     ((display sent-event? event-name detail seq-nr event mode)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name . ,(d-identity 'focusout))
      (detail . ,(d-const #t d-card8 '((0 . Ancestor)
				      (1 . Virtual)
				      (2 . Inferior)
				      (3 . Nonlinear)
				      (4 . NonlinearVirtual)
				      (5 . Pointer)
				      (6 . PointerRoot)
				      (7 . None) )))
      (seq-nr . ,d-card16)
      (event . ,d-window)
      (mode . ,(d-const #t d-card8 '((0 . Normal)
				    (1 . Grab)
				    (2 . Ungrab)
				    (3 . WhileGrabbed) )))
      (unused . ,(d-unused 23)) )
;;; Event #11: KeymapNotify
     ((display sent-event? event-name keys)
      ,(lambda (e) ((e 'display) 'keyboard))  ; Recipient object for this event
      (event-name . ,(d-identity 'keymapnotify))
      (keys . ,(lambda (str dpy)
	      (d-string8 31 str dpy) )))
;;; Event #12: Expose
     ((display sent-event? event-name seq-nr window x y width height count)
      ,(lambda (e) (e 'window))		; Recipient object for this event
      (event-name . ,(d-identity 'expose))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (window . ,d-window)
      (x . ,d-card16)
      (y . ,d-card16)
      (width . ,d-card16)
      (height . ,d-card16)
      (count . ,d-card16)
      (unused . ,(d-unused 14)) )
;;; Event #13: GraphicsExposure
     ((display sent-event? event-name seq-nr drawable x y width height
       minor-opcode count major-opcode)
      ,(lambda (e) (e 'drawable))	; Recipient object for this event
      (event-name . ,(d-identity 'graphicsexposure))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (drawable . ,d-drawable)
      (x . ,d-card16)
      (y . ,d-card16)
      (width . ,d-card16)
      (height . ,d-card16)
      (minor-opcode . ,d-card16)
      (count . ,d-card16)
      (major-opcode . ,d-card8)
      (unused . ,(d-unused 11)) )
;;; Event #14: NoExposure
     ((display sent-event? event-name seq-nr
	       drawable minor-opcode major-opcode)
      ,(lambda (e) (e 'drawable))	; Recipient object for this event
      (event-name . ,(d-identity 'noexposure))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (drawable . ,d-drawable)
      (minor-opcode . ,d-card16)
      (major-opcode . ,d-card8)
      (unused . ,(d-unused 21)) )
;;; Event #15: VisibilityNotify
     ((display sent-event? event-name seq-nr window state)
      ,(lambda (e) (e 'window))		; Recipient object for this event
      (event-name . ,(d-identity 'visibilitynotify))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (window . ,d-window)
      (state . ,(d-const #t d-card8 '((0 . Unobscured)
				     (1 . PartiallyObscured)
				     (2 . FullyObscured) )))
      (unused . ,(d-unused 23)) )
;;; Event #16: CreateNotify
     ((display sent-event? event-name seq-nr parent window x y
       width height border-width override-redirect)
      ,(lambda (e) (e 'window))		; Recipient. Should it be parent?
      (event-name . ,(d-identity 'createnotify))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (parent . ,d-window)
      (window . ,d-window)
      (x . ,d-int16)
      (y . ,d-int16)
      (width . ,d-card16)
      (height . ,d-card16)
      (border-width . ,d-card16)
      (override-redirect . ,d-bool)
      (unused . ,(d-unused 9)) )
;;; Event #17: DestroyNotify
     ((display sent-event? event-name seq-nr event window)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name . ,(d-identity 'destroynotify))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (event . ,d-window)
      (window . ,d-window)
      (unused . ,(d-unused 20)) )
;;; Event #18: UnmapNotify
     ((display sent-event? event-name seq-nr event window from-configure)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name . ,(d-identity 'unmapnotify))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (event . ,d-window)
      (window . ,d-window)
      (from-configure . ,d-bool)
      (unused . ,(d-unused 19)) )
;;; Event #19: MapNotify
     ((display sent-event? event-name seq-nr event window override-redirect)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name . ,(d-identity 'mapnotify))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (event . ,d-window)
      (window . ,d-window)
      (override-redirect . ,d-bool)
      (unused . ,(d-unused 19)) )
;;; Event #20: MapRequest
     ((display sent-event? event-name seq-nr parent window)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name . ,(d-identity 'maprequest))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (parent . ,d-window)
      (window . ,d-window)
      (unused . ,(d-unused 20)) )
;;; Event #21: ReparentNotify
     ((display sent-event? event-name seq-nr event
	       window parent x y override-redirect)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name . ,(d-identity 'reparentnotify))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (event . ,d-window)
      (window . ,d-window)
      (parent . ,d-window)
      (x . ,d-int16)
      (y . ,d-int16)
      (override-redirect . ,d-bool)
      (unused . ,(d-unused 11)) )
;;; Event #22: ConfigureNotify
     ((display sent-event? event-name seq-nr event window above-sibling
       x y width height border-width override-redirect)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name . ,(d-identity 'configurenotify))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (event . ,d-window)
      (window . ,d-window)
      (above-sibling . ,(d-const #f d-window '((0 . None))))
      (x . ,d-int16)
      (y . ,d-int16)
      (width . ,d-card16)
      (height . ,d-card16)
      (border-width . ,d-card16)
      (override-redirect . ,d-bool)
      (unused . ,(d-unused 5)) )
;;; Event #23: ConfigureRequest
     ((display sent-event? event-name stack-mode seq-nr parent window sibling
       x y width height border-width value-mask)
      ,(lambda (e) (e 'window))		; Recipient object for this event
      (event-name . ,(d-identity 'configurerequest))
      (stack-mode . ,(d-const #t d-card8 '((0 . Above)
					  (1 . Below)
					  (2 . TopIf)
					  (3 . BottomIf)
					  (4 . Opposite) )))
      (seq-nr . ,d-card16)
      (parent . ,d-window)
      (window . ,d-window)
      (sibling . ,(d-const #f d-window '((0 . None))))
      (x . ,d-int16)
      (y . ,d-int16)
      (width . ,d-card16)
      (height . ,d-card16)
      (border-width . ,d-card16)
      (value-mask . ,d-bitmask)
      (unused . ,(d-unused 4)) )
;;; Event #24: GravityNotify
     ((display sent-event? event-name seq-nr event window x y)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name . ,(d-identity 'gravitynotify))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (event . ,d-window)
      (window . ,d-window)
      (x . ,d-int16)
      (y . ,d-int16)
      (unused . ,(d-unused 16)) )
;;; Event #25: ResizeRequest
     ((display sent-event? event-name seq-nr window width height)
      ,(lambda (e) (e 'window))		; Recipient object for this event
      (event-name . ,(d-identity 'resizerequest))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (window . ,d-window)
      (width . ,d-card16)
      (height . ,d-card16)
      (unused . ,(d-unused 20)) )
;;; Event #26: CirculateNotify
     ((display sent-event? event-name seq-nr event window place)
      ,(lambda (e) (e 'event))		; Recipient object for this event
      (event-name . ,(d-identity 'circulatenotify))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (event . ,d-window)
      (window . ,d-window)
      (unused . ,d-window)
      (place . ,(d-const #t d-card8 '((0 . Top) (1 . Bottom))))
      (unused . ,(d-unused 15)) )
;;; Event #27: CirculateRequest
     ((display sent-event? event-name seq-nr parent window place)
      ,(lambda (e) (e 'window))		; Recipient object for this event
      (event-name . ,(d-identity 'circulaterequest))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (parent . ,d-window)
      (window . ,d-window)
      (unused . ,(d-unused 4))
      (place . ,(d-const #t d-card8 '((0 . Top) (1 . Bottom))))
      (unused . ,(d-unused 15)) )
;;; Event #28: PropertyNotify
     ((display sent-event? event-name seq-nr window atom time state)
      ,(lambda (e) (e 'window))		; Recipient object for this event
      (event-name . ,(d-identity 'propertynotify))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (window . ,d-window)
      (atom . ,d-atom)
      (time . ,d-timestamp)
      (state . ,(d-const #t d-card8 '((0 . NewValue) (1 . Deleted))))
      (unused . ,(d-unused 15)) )
;;; Event #29: SelectionClear
     ((display sent-event? event-name seq-nr time owner selection)
      ,(lambda (e) (e 'owner))		; Recipient object for this event
      (event-name . ,(d-identity 'selectionclear))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (time . ,d-timestamp)
      (owner . ,d-window)
      (selection . ,d-atom)
      (unused . ,(d-unused 16)) )
;;; Event #30: SelectionRequest
     ((display sent-event? event-name seq-nr
	       time owner requestor selection target property)
      ,(lambda (e) (e 'owner))		; Recipient object for this event
      (event-name . ,(d-identity 'selectionrequest))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (time . ,(d-const #f d-timestamp '((0 . CurrentTime))))
      (owner . ,d-window)
      (requestor . ,d-window)
      (selection . ,d-atom)
      (target . ,d-atom)
      (property . ,(d-const #f d-atom '((0 . None))))
      (unused . ,(d-unused 4)) )
;;; Event #31: SelectionNotify
     ((display sent-event? event-name seq-nr time
	       requestor selection target property)
      ,(lambda (e) (e 'requestor))	; Recipient object for this event
      (event-name . ,(d-identity 'selectionnotify))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (time . ,(d-const #f d-timestamp '((0 . CurrentTime))))
      (requestor . ,d-window)
      (selection . ,d-atom)
      (target . ,d-atom)
      (property . ,(d-const #f d-atom '((0 . None))))
      (unused . ,(d-unused 8)) )
;;; Event #32: ColormapNotify
     ((display sent-event? event-name seq-nr window colormap new state)
      ,(lambda (e) (e 'window))		; Recipient object for this event
      (event-name . ,(d-identity 'colormapnotify))
      (unused . ,(d-unused 1))
      (seq-nr . ,d-card16)
      (window . ,d-window)
      (colormap . ,(d-const #f d-colormap '((0 . None))))
      (new . ,d-bool)
      (state . ,(d-const #t d-card8 '((0 . Uninstalled) (1 . Installed))))
      (unused . ,(d-unused 18)) )
;;; Event #33: ClientMessage
     ((display sent-event? event-name format seq-nr window type data)
      ,(lambda (e) (e 'window))		; Recipient object for this event
      (event-name . ,(d-identity 'clientmessage))
      (format . ,d-card8)
      (seq-nr . ,d-card16)
      (window . ,d-window)
      (type . ,d-atom)
      (data . ,(lambda (str dpy)
		(let loop ((nxt (get-next-byte! str)) (num 20))
		  (if (= num 0)
		      '()
		      (cons nxt (loop (get-next-byte! str) (- num 1))) )))))
;;; Event #34: MappingNotify
     ((display sent-event? event-name seq-nr request first-keycode count)
      ,(lambda (e) ((e 'display) 'keyboard))  ; Recipient object for this event
      (event-name    . ,(d-identity 'mappingnotify))
      (unused        . ,(d-unused 1))
      (seq-nr        . ,d-card16)
      (request       . ,(d-const #t d-card8 '((0 . Modifier)
					      (1 . Keyboard)
					      (2 . Pointer) )))
      (first-keycode . ,d-keycode)
      (count         . ,d-card8)
      (unused        . ,(d-unused  25)) )))
