;;;
;;;              Copyright 1991 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;;
;;; util.sc -- some utilities used by various demos. Things that prove really
;;;            useful might propagate over to ../stox/util.sc

;;; $Id: util.sc,v 1.1 91/09/15 01:01:44 johani Exp $

(module demoutil)

(include "../include/scix.sch")
(include "../include/stox.sch")
(include "../macros/extsyntax.sc")
(include "../macros/oos.sc")		; Grr. Just to get the match-arg macro.

;;; file-cache -- a trivial cache mechanism to avoid reading the same file
;;;               multiple times.
(define file-cache
  (let ((cached-files '()))
    (lambda (filename fnt)
      (cond ((string? filename)
	     (let ((pair (assoc filename cached-files)))
	       (if pair
		   (cdr pair)
		   (let* ((lsize (fnt 'querytextextents
				     (s8->s16 (make-string 80 #\M)) ))
			  (new-file (read-file filename
					       (lsize 'font-ascent)
					       (+ (lsize 'font-ascent)
						  (lsize 'font-descent) ))))
		     (if new-file
			 (begin
			   (set! cached-files
				 (cons (cons filename new-file)
				       cached-files))
			   new-file)
			 (vector #f
				 (imagetext8 'make 1 (lsize 'font-ascent)
					     (format "Unable to open file ~a."
						     filename))) )))))
	    ((eq? filename 'debug)
	     (map car cached-files) )
	    ((eq? filename 'clear)
	     (set! cached-files '()) )))))

;;; read-file -- read the file filename and return a vector with an
;;;              imagetext8 object for each line at the position in the
;;;              vector corresponding to the linenumber.
(define (read-file filename first-y delta-y)
  (if (file-readable? filename)
      (let ((r '(#f)) (fp (open-input-file filename)))
	(let loop ((last r) (line (read-line fp)) (ycoord first-y))
	  (if (eof-object? line)
	      (close-port fp)
	      (begin
		(set-cdr! last (list (imagetext8 'make 1 ycoord line)))
		(loop (cdr last) (read-line fp) (+ ycoord delta-y))) ))
	(list->vector r) )
      #f))

;;; read-line -- returns one line from the file fp at a time as a string.
(define read-line
  (let ((line #f))
    (lambda (fp)
      (set! line (list #f))
      (let loop ((last line) (c (read-char fp)))
	(cond ((eof-object? c) c)
	      ((char=? c #\newline) (list->string (cdr line)))
	      (else
	       (set-cdr! last (list c))
	       (loop (cdr last) (read-char fp)) ))))))

;;; This version works perfectly interpreted, but compiles to strangely
;;; broken code.
;;; read-line -- returns one line from the file fp at a time as a string.
;(define (read-line fp)
;  (let ((line '(#f)))
;    (let loop ((last line) (c (read-char fp)))
;      (cond ((eof-object? c) c)
;	    ((char=? c #\newline) (list->string (cdr line)))
;	    (else
;	     (set-cdr! last (list c))
;	     (loop (cdr last) (read-char fp)) )))))


;;; view-textfile -- show the file with name name in a text-window.
(define (view-textfile . args)
  (let* ((name  (find-file (match-arg 'filename 'no-default args)))
	 (scr   (match-arg 'screen 'no-default args))
	 (title (match-arg 'title name args))
	 (t (file-cache name ((scr 'gcache) 'font)))
         (tw (text-window 'make 'parent (scr 'root) 'text t 'title title)) )
    (tw 'stox-activate) ))

