;;; A SCIX version of Hello, World! Hakan Huss, KTH and Johan Ihren, KTH
;;; Please note that this code does not, on purpose, use any widgets or
;;; other special mechanisms provided by SCIX.

;;; $Id: hello.sc,v 2.2 91/09/15 01:02:11 johani Exp $

(module demohello (top-level demo-hello))

(include "../include/stox.sch")
(include "../include/scix.sch")

(define (demo-hello scr)
  (let* ((w (window 'make 'screen scr 'width 400 'height 400
		    'mask (make-window-value-mask
			   `(background-pixel ,(scr 'whitepixel))
			   `(event-mask
			     ,(make-mask 'event 'ButtonPress 'KeyPress
					 'Exposure))) ))
	 (f1 (font 'make 'screen scr 'fontname "variable"))
	 (view (view 'make))
	 (mygc (gc 'make 'mask (make-gc-value-mask 
				`(foreground ,(scr 'blackpixel))
				`(background ,(scr 'whitepixel))
				`(font ,f1) )
		   'screen scr ))
	 (hello (imagetext8 'make 100 50 "Hello world!"))
	 (keybd (scr 'keyboard))
	 (terminate #f) )

    (view 'add! (list hello))
    (w 'add-callback! 'Expose (lambda (event window)
				(if (zero? (event 'count))
				    (begin
				      (w 'draw (list view) mygc)
				      (scr 'flush!) ))))
    (w 'add-callback! 'ButtonPress
       (lambda (event window)
	 (let ((hi (list (imagetext8 'make (event 'event-x)
				     (event 'event-y) "Hi!"))))
	   (view 'add! hi)
	   (w 'draw hi mygc)
	   (scr 'flush!) )))

    (w 'add-callback! 'KeyPress
       (lambda (event window)
	 (let* ((key (event 'detail))
		(keysym ((keybd 'getkeyboardmapping key 1) 'keysyms)) )
	   (if (= (char->integer #\Q)
		  (bit-and #xdf (caar keysym))) ; fast toupper, requires ASCII.
	       (begin
		 (w 'destroywindow)
		 (mygc 'freegc)
		 (f1 'closefont)
		 (scr 'flush!)
		 (set! terminate #t) )))))
    (w 'changeproperty 'replace 'wm_name 'string 8 "SCIX Hello, world!")
    (w 'mapwindow)
    (scr 'flush!)
    (scix-process-events scr) ))
    ;;(msg-handler 'mainloop (lambda () terminate) (list scr)) ))
