;;;
;;;              Copyright 1991 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;; Some graphics drawn in a SCIX window. Hakan Huss, KTH and Johan Ihren, KTH

;;; $Id: graphic.sc,v 2.2 91/09/15 01:02:08 johani Exp $

(module demographic)

(include "../include/scix.sch")

(define (demo-graphic size method scr)
  (let ((cmap (scr 'default-colormap))
	(w (window 'make 'width size 'height size 'screen scr
		   'mask (make-window-value-mask
			  `(background-pixel ,(scr 'whitepixel)))))

	(mygc (gc 'make (make-gc-value-mask `(line-width 1)
		                            `(foreground ,(scr 'blackpixel))
		                            `(background ,(scr 'whitepixel)) )
		  'screen scr))
	(terminate #f) )
    (w 'changeproperty 'replace 'wm_name 'string 8 "SCIX Graphics")
    (w 'mapwindow)
    (scr 'flush!)
    (msg-handler 'mainloop
		 (lambda () terminate)
		 (list scr)
		 (lambda (event-handler) ; We really don't care about events.
		   (let oloop ((r 4))
		     (w 'cleararea  #t 0 0 size size)
		     (cond ((eq? method 'natural) (natural size w mygc scr))
			   ((eq? method 'smart) (smart size w mygc scr))
			   (else (format #t "Unknown method of drawing.~%")) )
;		     (draw size w mygc scr)
		     (if (zero? r)
			 (begin
			   (mygc 'freegc)
			   (w 'destroywindow)
			   (scr 'flush!) )
			 (oloop (- r 1)) ))))))

(define (draw size w the-gc scr)
  (let loop ((c size))
    (w 'draw (list (polysegment 'make `((0 ,size ,c ,0)
					(0 ,size ,size ,c)
					(,size ,size 0 ,c)
					(,size ,size ,c 0)
					(0 0 ,size ,c)
					(0 0 ,c ,size)
					(,size 0 0 ,c)
					(,size 0 ,c ,size) )))
       the-gc)
    (if (not (zero? c))
	(loop (- c 4))
	(scr 'flush!) )))

(define (natural size w the-gc scr)
  (let loop ((c size))
    (w 'draw (list (polyline 'make 'origin `((0 ,c) (,c ,size)
						    (,size ,(- size c))
						    (,(- size c) 0)
						    (0 ,c) )))
       the-gc)
    (if (not (zero? c))
	(loop (- c 4))
	(scr 'flush!) )))

;;; Have to devise something to cope with too long point lists, though, ...
(define (smart size w the-gc scr)
  (let loop ((c size) (point-list '()))
    (if (positive? c)
	(loop (- c 4) (append point-list `((0 ,c) (,c ,size)
						  (,size ,(- size c))
						  (,(- size c) 0)
						  (0 ,c) )))
	(begin
	  (w 'draw (list (polyline 'make 'origin point-list)) the-gc)
	  (scr 'flush!) ))))

;;; The two functions below are used only when graphic is compiled as a
;;; stand-alone application.

(define (usage)
  (display "Usage: graphic [-size size] [-display display]") 
  (newline))

(define (do-graphic clargs)
  (let ((dpy #f) (size 400))
    (let loop ((ls (cdr clargs)))
      (cond ((null? ls) #t)
	    ((and (equal? (car ls) "-size")
		  (not (null? (cdr ls)))
		  (string->number (cadr ls)) )
	     (set! size (string->number (cadr ls)))
	     (loop (cddr ls)) )
	    ((and (equal? (car ls) "-display")
		  (not (null? (cdr ls)))
		  (string? (cadr ls)) )
	     (set! dpy (xdisplay 'make (cadr ls)))
	     (loop (cddr ls)) )
	    (else
	     (usage)
	     (exit) )))
    (if (not dpy)
	(set! dpy (xdisplay 'make "")) )
    (demo-graphic size 'smart (dpy 'defaultscreen)) ))
