;;;
;;;              Copyright 1990 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;; $Id: bitmasks.sc,v 1.1 90/06/26 09:46:10 johani Exp $

;;; bitmasks.sc -- Formats of the various bitmasks of X. Calls are of
;;;                the form (make-<name>-mask 'id ...).

(module scixbmsk (top-level make-event-mask make-pointerevent-mask
	                    make-deviceevent-mask make-keybutmask-mask
			    make-keymask-mask))

(include "../include/util.sch")
(include "../include/lowlevel.sch")

(include "../macros/extsyntax.sc")
(include "../macros/mask-obj.sc")

(define (make-event-mask . initial-settings)
  (let ((the-mask (make-mask (KeyPress
			      KeyRelease
			      ButtonPress
			      ButtonRelease
			      EnterWindow
			      LeaveWindow
			      PointerMotion
			      PointerMotionHint
			      Button1Motion
			      Button2Motion
			      Button3Motion
			      Button4Motion
			      Button5Motion
			      ButtonMotion
			      KeyMapState
			      Exposure
			      VisibilityChange
			      StructureNotify
			      ResizeRedirect
			      SubstructureNotify
			      SubstructureRedirect
			      FocusChange
			      PropertyChange
			      ColormapChange
			      OwnerGrabButton))))
    (for-each (lambda (bit)
		(the-mask 'set! bit) )
	      initial-settings)
    the-mask))

(define (make-pointerevent-mask . initial-settings)
  (let ((the-mask (make-mask (unused
			      unused
			      ButtonPress
			      ButtonRelease
			      EnterWindow
			      LeaveWindow
			      PointerMotion
			      PointerMotionHint
			      Button1Motion
			      Button2Motion
			      Button3Motion
			      Button4Motion
			      Button5Motion
			      ButtonMotion
			      KeyMapState))))
    (for-each (lambda (bit)
		(the-mask 'set! bit) )
	      initial-settings)
    the-mask))

(define (make-deviceevent-mask . initial-settings)
  (let ((the-mask (make-mask (KeyPress
			      KeyRelease
			      ButtonPress
			      ButtonRelease
			      unused
			      unused
			      PointerMotion
			      unused
			      Button1Motion
			      Button2Motion
			      Button3Motion
			      Button4Motion
			      Button5Motion
			      ButtonMotion))))
    (for-each (lambda (bit)
		(the-mask 'set! bit) )
	      initial-settings)
    the-mask))

(define (make-keybutmask-mask . initial-settings)
  (let ((the-mask (make-mask (Shift
			      Lock
			      Control
			      Mod1
			      Mod2
			      Mod3
			      Mod4
			      Mod5
			      Button1
			      Button2
			      Button3
			      Button4
			      Button5))))
    (for-each (lambda (bit)
		(the-mask 'set! bit) )
	      initial-settings)
    the-mask))

(define (make-keymask-mask . initial-settings)
  (let ((the-mask (make-mask (Shift
			      Lock
			      Control
			      Mod1
			      Mod2
			      Mod3
			      Mod4
			      Mod5))))
    (for-each (lambda (bit)
		(the-mask 'set! bit) )
	      initial-settings)
    the-mask))

