;;;
;;;              Copyright 1990 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;; SCIX Graphic objects.

;;; Request #64: PolyPoint -- coord-mode is in '(origin previous)
(define-lw-class (polypoint coord-mode point-list)
  (methods
   (draw (lambda (gc drawable . rest)
	   (send-polypoint drawable gc coord-mode
			   point-list (gc 'screen) rest) ))))

;;; Request #65: PolyLine -- coord-mode is in '(origin previous)
(define-lw-class (polyline coord-mode point-list)
  (methods
   (draw (lambda (gc drawable . rest)
	   (send-polyline drawable gc coord-mode
			  point-list (gc 'screen) rest) ))))

;;; Request #66: PolySegment -- segment-lists are like '((x1 y1 x2 y2) ...)
(define-lw-class (polysegment segment-list)
  (methods
   (draw (lambda (gc drawable . rest)
	   (send-polysegment drawable gc segment-list (gc 'screen) rest) ))))

;;; Request #67: PolyRectangle -- rectangle-lists are like '((x1 y1 w h) ...)
(define-lw-class (polyrectangle rectangle-list)
  (methods
   (draw (lambda (gc drawable . rest)
	   (send-polyrectangle drawable gc
			       rectangle-list (gc 'screen) rest) ))))

;;; Request #68: PolyArc -- arc-lists are like '((x y w h ang1 ang2) ...)
(define-lw-class (polyarc arc-list)
  (methods
   (draw (lambda (gc drawable . rest)
	   (send-polyarc drawable gc arc-list (gc 'screen) rest) ))))

;;; Request #69: FillPoly -- shape is in '(complex nonconvex convex)
;;;                       -- coord-mode is in '(origin previous)
(define-lw-class (fillpoly shape coord-mode point-list)
  (methods
   (draw (lambda (gc drawable . rest)
	   (send-fillpoly drawable gc shape coord-mode
			  point-list (gc 'screen) rest) ))))

;;; Request #70: PolyFillRectangle -- recttangle-lists: '((x1 y1 w h) ...)
(define-lw-class (polyfillrectangle rectangle-list)
  (methods
   (draw (lambda (gc drawable . rest)
	   (send-polyfillrectangle drawable gc
				   rectangle-list (gc 'screen) rest) ))))

;;; Request #71: PolyFillArc -- arc-lists are like '((x y w h ang1 ang2) ...)
(define-lw-class (polyfillarc arc-list)
  (methods
   (draw (lambda (gc drawable . rest)
	   (send-polyfillarc drawable gc arc-list (gc 'screen) rest) ))))

;;; Request #74: PolyText8 -- items are generated by (make-textitem ...)
(define-lw-class (polytext8 x y items)
  (methods
   (draw (lambda (gc drawable . rest)
	   (send-polytext8 drawable gc x y items (gc 'screen) rest) ))))

;;; Request #75: PolyText16 -- items are generated by (make-textitem ...)
(define-lw-class (polytext16 x y items)
  (methods
   (draw (lambda (gc drawable . rest)
	   (send-polytext16 drawable gc x y items (gc 'screen) rest) ))))

;;; Request #76: ImageText8
(define-lw-class (imagetext8 x y string)
  (methods
   (draw (lambda (gc drawable . rest)
	   (send-imagetext8 drawable gc x y string (gc 'screen) rest) ))))

;;; Request #77: ImageText16
(define-lw-class (imagetext16 x y string)
  (methods
   (draw (lambda (gc drawable . rest)
	   (send-imagetext16 drawable gc x y string (gc 'screen) rest) ))))

;;; We have not yet had time to experiment with String16's.

