(herald (back_end generate_y)
  (env t (orbit_top defs) (back_end closure) (back_end bookkeep)))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

;;; Copyright (c) 1985 David Kranz

;;; GENERATE-LET&LABELS Divide up the procedures depending on whether they
;;; need to be closed or can be jumped to.

(define (generate-labels node)        
  (destructure (((cont master) (call-args node)))
    (destructure (((body . procs) (call-args (lambda-body master))))
      (xselect (lambda-strategy master)
        ((strategy/heap)
         (generate-heap-labels node body procs))                            
        ((strategy/label)))
      (cond ((and (lambda-node? cont)
		  (eq? (lambda-strategy cont) strategy/stack))
	     (let* ((cont-saved (save-live-registers cont node))
		    (hv (lambda-self-var *heap-env*))
		    (live (if (or (register-loc hv) (temp-loc hv))
			      (cons hv (lambda-live body))
			      (lambda-live body)))
		    (main-saved (kill-cont-vars-and-save node live)))
	       (generate-save-jump-and-link body)
	       (emit-stack-template cont main-saved)
	       (restore-live-registers-and-continue cont-saved cont)
	       (emit-tag body)
	       (clear-slots)
	       (walk (lambda (pair) (mark (car pair) (cdr pair))) main-saved)
	       (maybe-allocate-red-frame *lambda*)
	       (allocate-call (lambda-body body)))) ;body will deallocate
	    (else
	     (allocate-call (lambda-body body)))))))

(define (kill-cont-vars-and-save node live)
  (iterate loop ((i P) (saved '()))
    (cond ((fx= i *first-stack-register*)
	   (iterate loop ((i i) (saved saved))
	     (cond ((fx= i *virtual-registers*) saved)
		   (else
		    (let ((var (reg-node i)))
		      (cond ((and (variable? var)
				  (memq? var live)
				  (not (assq var saved)))
			     (let ((reg (get-reg-if-free node)))
			       (cond ((not reg)
				      (bug "Too many live in hack labels"))
				     (else
				      (generate-move i reg)
				      (lock reg)
				      (loop (fx+ i 1) (cons (cons var reg) saved))))))
			    (else
			     (loop (fx+ i 1) saved))))))))
	  (else
	   (let ((var (reg-node i)))
	     (cond ((not var)
		    (loop (fx+ i 1) saved))
		   ((not (memq? var live))
		    (kill var)
		    (loop (fx+ i 1) saved))
		   (else
		    (loop (fx+ i 1) (cons (cons var i) saved)))))))))


(define (generate-heap-labels node body closures)
    (if closures
        (let ((closure (environment-closure (lambda-env (car closures)))))
          (make-heap-closure node closure)
          (lock AN)
          (walk (lambda (var)
                  (let ((reg (get-register node))
                        (offset (cdr (assq var (closure-env closure)))))
                    (generate-move-address (reg-offset AN offset) reg)
                    (mark var reg)))
                (filter (lambda (closure)
                          (memq? closure (lambda-live body)))
                        (cdr (closure-members closure))))
          (unlock AN)
          (if (memq? (car (closure-members closure)) (lambda-live body))
              (mark (car (closure-members closure)) AN)))))
                                                         
                                                         
(define (get-or-set-join-state node lamb)
  (let ((join (lambda-env lamb)))
    (cond ((eq? (join-point-global-registers join) 'not-yet-determined)
	   (set-join-state node join lamb)
	   (set (join-point-*lambda* join) *lambda*)))
    join))

(define (fully-recursive? lamb)
  (if (labels-lambda? lamb)
      (not (ezclose-allowed? lamb))
      (not (continuation? lamb))))


;;; SET-JOIN-STATE The first jump (compile time) is about to be made to this
;;; point.  We must set up places for the free variables to go.  For now,
;;; put one in a register and the rest in temporaries. Move them there.


(define (set-join-state node join lamb)
  (let ((p-ok? (not (join-point-contour-needed? join))))
    (lambda-queue lamb)
    (receive (aspecs global)
             (compute-label-arg-specs node lamb join p-ok?
				      (not (fully-recursive? lamb))
				      (join-point-call-below? join))
      (let ((global (if p-ok?
			global
			(cons (cons (if (and (join-point-call-below? join)
					     (not (fully-recursive? lamb)))
					*first-stack-register*
					P)
				    (join-point-contour join))
			      global))))
      (set (join-point-global-registers join) global)
      (set (join-point-arg-specs join) (reverse! aspecs))))))

(define (compute-label-arg-specs node label join p-ok? stack-ok? stack?)
  (receive (formals actuals) (if (continuation? label)
                                 (return (lambda-variables label)
                                         (call-args node))
                                 (return (cdr (lambda-variables label))
                                         (cdr (call-args node))))
  (iterate loop ((actuals actuals)
		 (formals formals)
		 (arg-specs '())
		 (env (join-point-env join))
		 (env-specs '())
		 (eleft '())
		 (regs (cond (p-ok?
			      (list AN))
			     ((and stack? stack-ok?)
			      (list *first-stack-register* AN))
			     (else
			      (list P AN)))))
    (cond ((null? formals)
	   (cond ((null? env)
		  (iterate loop ((env-specs env-specs)
				 (env eleft)
				 (regs regs))
			   (cond ((null? env)
				  (maybe-set-lambda-max regs)
				  (return arg-specs env-specs))
				 (else
				  (let ((reg (cond ((ok-next-register? (car env)
								       regs
								       label
								       stack-ok?
								       stack?
								       '#t))
						   (else
						    (get-free-register regs
								       p-ok?
								       stack-ok?
								       stack?
								       '#t)))))
				    (loop (cons (cons reg (car env)) env-specs)
					  (cdr env)
					  (cons reg regs)))))))
		 ((in-ok-register? (car env) regs stack-ok? stack? '#t)
		  => (lambda (reg)
		       (loop actuals
			     formals
			     arg-specs
			     (cdr env)
			     (cons (cons reg (car env)) env-specs)
			     eleft
			     (cons reg regs))))
		 (else
		  (loop actuals
			formals
			arg-specs
			(cdr env)
			env-specs
			(cons (car env) eleft)
			regs))))
          (else
	   (let ((reg (cond ((and (reference-node? (car actuals))
				  (in-ok-register?
				   (reference-variable (car actuals)) regs
				   stack-ok?
				   stack?
				   '#f)))
			    ((and (car formals)
				  (ok-next-register? (car formals)
						     regs label 
						     stack-ok? stack? '#f)))
			    (else (get-free-register regs p-ok? stack-ok? 
						     stack? '#f)))))
	     (loop (cdr actuals)
		   (cdr formals)
		   (cons reg arg-specs)
		   env
		   env-specs
		   eleft
		   (cons reg regs))))))))

(define (in-ok-register? var regs stack-ok? stack? free-var?)
  (cond ((or (register-loc var) (temp-loc var))
	 => (lambda (reg)
	      (and (not (memq? reg regs))
		   (ok-register? reg stack-ok? stack? free-var?)
		   reg)))
	(else nil)))

(define (ok-next-register? var regs label stack-ok? stack? free-var?)
  (cond ((likely-next-reg var label)
	 => (lambda (reg)
	      (and (not (memq? reg regs))
		   (not (reg-node reg))
		   (ok-register? reg stack-ok? stack? free-var?)
		   reg)))
	(else nil)))
  
(define-integrable (ok-register? reg stack-ok? stack? free-var?)  
  (if stack-ok?
      (cond ((and stack? free-var?)
	     (fx>= reg *first-stack-register*))
	    (free-var? '#t)
	    (else
	     (fx< reg *real-registers*)))
      (fx< reg *first-stack-register*)))
  
  
(define (get-free-register used p-ok? stack-ok? stack? free-var?)
  (really-get-free-register used nil 
			    (if (and stack-ok? stack? free-var?)
				(if p-ok?
				    *first-stack-register*
				    (fx+ *first-stack-register* 1))
				(if p-ok? P A1))
			    (if stack-ok?
				*real-registers*
				*first-stack-register*)))


(define (really-get-free-register used force? start stop)
     (iterate loop ((i start))
       (cond ((fx>= i stop)    
              (cond (force?
                     (do ((j *real-registers* (fx+ j 1)))
                         ((if (fx>= j *virtual-registers*)
                              (bug "ran out of registers in GET-FREE-REGISTER")
                              (not (memq? j used)))
                          j)))
                     (else 
                      (really-get-free-register used t start stop))))
             ((memq? i used) (loop (fx+ i 1)))
             ((or force? (not (reg-node i))) i)
             (else (loop (fx+ i 1))))))

(define (maybe-set-lambda-max regs)
  (do ((regs regs (cdr regs))
       (m 0 (max m (car regs))))
      ((null? regs)
       (or (fx< m *first-stack-register*)
	   (modify (lambda-max-temps *lambda*)
		   (lambda (max-temp)
		     (max m max-temp)))))))
