(herald mipslap)

(define lap-pseudo-ops (make-table 'lap-pseudo-ops))
(define lap-instructions (make-table 'lap-instruction))

(define-local-syntax (define-lap-instruction n1 n2)
  `(set (table-entry lap-instructions ',n1) ,n2))


(define-local-syntax (define-lap-syntax pattern . body)
  `(set (table-entry lap-pseudo-ops ',(car pattern))
	(object (lambda ,(cdr pattern) ,@body)
	  ((identification self) ',(car pattern)))))

(define-local-syntax (define-j-syntax j)
  `(define-lap-syntax (,j arg1 arg2 label)
     (*jlap ,(concatenate-symbol 'jump-op/ j) arg1 arg2 label)))

(define-local-syntax (define-arith-syntax op)
  `(define-lap-syntax (,op arg1 arg2 . arg3)
     (*arithlap ,(concatenate-symbol 'risc/ op) arg1 arg2
		(if arg3 (car arg3) arg2))))
 
(define-j-syntax j=)
(define-j-syntax jn=)
(define-j-syntax j<)
(define-j-syntax j<=)
(define-j-syntax j>)
(define-j-syntax j>=)
(define-j-syntax uj<)
(define-j-syntax uj>)
(define-j-syntax uj<=)
(define-j-syntax uj>=)

(define-lap-syntax (jbr lab)
  (emit-jump lab))

(define-lap-syntax (jl lab)
  (emit-branch-and-link lab))

(define (*jlap jop arg1 arg2 label)
  (let ((next (cons label nil)))
    (emit-compare jop (lap-eval arg1) (lap-eval arg2) label next)
    (emit-tag next)))

(define (*arithlap inst arg1 arg2 arg3)
  (emit inst (lap-eval arg1) (lap-eval arg2) (lap-eval arg3)))

(define-lap-syntax (move a b)
  (emit risc/add (lap-eval a) zero (lap-eval b)))

(import t-implementation-env bignum?)

(define-lap-syntax (movec a b)
  (let ((num (eval a orbit-env))
	(tar (lap-eval b)))
    (xcond ((bignum? num)
	    (emit mips/lui (unsigned-num
			    (bignum-bit-field num 16 16)) tar)
	    (emit risc/or
		  (unsigned-num (bignum-bit-field num 0 16))
		  tar tar))
           ((16bit? num)
	    (emit risc/add (machine-num num) zero tar))
	   ((fixnum? num)
	    (emit mips/lui (unsigned-num
			    (fixnum-logand #xffff (fixnum-ashr num 16))) tar)
	    (emit risc/or
		  (unsigned-num (fixnum-logand #xffff num))
		  tar tar)))))

(define-lap-syntax (template pointer nargs nary?)
  (asemit stemplate1 '(()))
  (asemit template2 '())
  (asemit laptemplate3 (list pointer nargs nary?)))

(define-lap-syntax (movea lab reg)
  (emit-branch-and-link 8)
  (emit risc/add (label-offset lab) link-reg (lap-eval reg)))

(define-lap-syntax (clear size mem)
  (emit risc/store size zero (lap-eval mem)))

(define-lap-syntax (store size reg mem)
    (emit risc/store size (lap-eval reg) (lap-eval mem)))

(define-lap-syntax (load size mem reg)
    (emit risc/load size (lap-eval mem) (lap-eval reg)))

(define-lap-syntax (jalr reg)
  (emit mips/jalr (lap-eval reg) link-reg))

(define-lap-syntax (jump-to-template reg)
  (emit risc/add (machine-num 2) (lap-eval reg) (lap-eval reg))
  (emit mips/jr (lap-eval reg)))

(define-arith-syntax add)
(define-arith-syntax sub)
(define-arith-syntax or)
(define-arith-syntax and)
(define-arith-syntax xor)
(define-arith-syntax sra)
(define-arith-syntax srl)
(define-arith-syntax sll)
(define-lap-instruction lui mips/lui)
(define-lap-instruction jr mips/jr)
(define-lap-instruction noop mips/noop)

(set (table-entry lap-pseudo-ops 'mask)
     (table-entry lap-pseudo-ops 'and))

(define %%car 1)
(define %%cdr -3)
	   
	      



