#! /bin/sh

# Script which creates T from its sources.

# You define TMACHINE, TSOURCES and TSYSTEM.
TMACHINE=sun3
TSOURCES=./sources

RISC=${TSOURCES}
BUILD=${TSOURCES}/comp/build
ORBIT_TOP=${TSOURCES}/comp/top
TOP=${ORBIT_TOP}
FRONT_END=${TSOURCES}/comp/front_end
BACK_END=${TSOURCES}/comp/back_end
ASSEMBLER=${TSOURCES}/comp/assembler
T3_PRIMOPS=${TSOURCES}/comp/primops
PRIMOP_SOURCE=${TSOURCES}/comp/primops
PRIMOP_DEST=${TSOURCES}/comp/primops
OSYS=${TSOURCES}/sys
LINK=${TSOURCES}/link
TSCHEME=${TSOURCES}/scheme

# export TMACHINE
export TSYSTEM TSOURCES
export RISC BUILD TOP ORBIT_TOP FRONT_END BACK_END ASSEMBLER 
export T3_PRIMOPS PRIMOP_SOURCE PRIMOP_DEST OSYS LINK TSCHEME

echo Start at; date

echo TSYSTEM = $TSYSTEM
echo TSOURCES = $TSOURCES

# make wt.o
echo "(load '(build ${TMACHINE}build) orbit-env) \
	(compile-support) (exit)" \
	| time t
echo "(load '(build ${TMACHINE}build) orbit-env) \
	(compile-sources) (exit)" \
	| time t -h 8000000
echo "(load '(build ${TMACHINE}build) orbit-env) \
	(link-t 'wt) (exit)" \
	| time t -h 8000000

# make wt (T without a compiler).
$TSYSTEM/linkt wt wt.o

# make xt.o
echo "((*value t-implementation-env 'load-and-suspend-system) \
	'xt t) (exit)" | time wt -h 8000000

# make xt
$TSYSTEM/linkt xt xt.o

echo Done at; date
