(herald n_dispatch (env tsys))

(define (dispatch-init)
  (lap (handle-stype handle-true handle-fixnum handle-pair
        handle-char handle-nonvalue *handlers* icall-wrong-nargs
        bogus-return bogus-return-miss apply handle-immediate
	handle-magic-frame no-default-method)

    (movi d p (d@r nil-reg slink/dispatch))
    (addr (label dispatch) (d@r nil-reg slink/dispatch-label))
    (movi d ($ -1) nargs)
    (movi d (@r sp) tp)
    (jump (@r tp))))


           
(lap-template (0 0 -1 nil stack handle-dispatch-return)
dispatch-return                  
    (cmpi d AN (d@r nil-reg 1))                         ; did we get a method?
    (j= default)                                ; AN contains code
    (movi d  A1 P)                             ;  environment
    (movi d (d@r P -2) TP)
    (movi d (d@r SP 16) A1)                    ; self is first arg of method
op-icall
    (cmpi b NARGS (d@r AN template/nargs))         ; check number of args
    (j= %icall-ok)
    (j< %icall-wrong-nargs)
    (cmpi b ($ (fx+ header/template 128)) (d@r AN -2))
    (jn= %icall-wrong-nargs)
%icall-ok
    (jump (@r AN))
%icall-wrong-nargs
  (movi d a1 (d@r TASK task/t0))
  (movi d a2 (d@r TASK (fx+ task/t0 4)))
  (movi d a3 (d@r TASK (fx+ task/t0 8)))
  (movi d ($ 0) s0)
  (jsr (*d@r nil-reg slink/nary-setup))
  (movi d an a2)
  (movi d (d@r SP 8) a1)   ; operation
  (adjspi b ($ -20))
  (movi d (d@r nil-reg slink/dispatch) P)
  (movi d (d@r P (static 'icall-wrong-nargs)) P)
  (movi d (d@r p 2) p)
  (movi d (d@r P -2) TP)
  (jump  (@r TP))
default
    (movi d (d@r SP 16) A1)                         ; self is first arg of method
    (movi d (d@r P offset/operation-default) P)
    (cmpi d p (d@r nil-reg 1))
    (j= no-default)
    (adjspi b ($ -20))
    (jump (*d@r nil-reg slink/icall))
no-default    
  (movi d a1 (d@r TASK task/t0))
  (movi d a2 (d@r TASK (fx+ task/t0 4)))
  (movi d a3 (d@r TASK (fx+ task/t0 8)))
  (movi d ($ 0) s0)
  (jsr (*d@r nil-reg slink/nary-setup))
  (movi d an a2)
  (movi d (d@r SP 8) a1)   ; operation
  (adjspi b ($ -20))
  (movi d (d@r nil-reg slink/dispatch) P)
  (movi d (d@r P (static 'no-default-method)) P)
  (movi d (d@r p 2) p)
  (movi d (d@r P -2) TP)
  (jump  (@r TP))
handle-dispatch-return    
    (spri d nil-reg AN)
    (ret ($ 0)))


(define *structure-template*                                           ;86/12/27
  (lap-template (0 0 0 nil heap structure-handler)
    (jump (*d@r nil-reg slink/undefined-effect))
structure-handler
    (movi d (d@r A1 -2) A1)                       ; internal-template
    (movi d (d@r A1 -30) A1)                      ; stype-handler
    (jump (label dispatch))))

;;; stype size is 9 (see struct.t).  The last 3 slots are a closure-internal-
;;; template (for structure instances of this stype) pointing to
;;; *structure-template*.  On the N32 that address must be scrambled, so
;;; it isn't a valid pointer.  Thus we declare the 3 CIT slots as scratch.
;;; This is OK because the GC will never relocate *structure-template*.

(define *stype-template*                                               ;86/12/27
  (lap-template (10 0 0 nil heap stype-handler)
    (jump (*d@r nil-reg slink/undefined-effect))
stype-handler
    (movi d (d@r nil-reg slink/dispatch) AN)
    (movi d (d@r AN (static 'handle-stype)) A1)
    (movi d (d@r a1 2) a1)
    (jump (label dispatch))))

(define *traced-op-template*                                           ;86/12/27
  (lap-template (0 0 0 nil stack t-op)
    (movi d A1 (tos))                                       ; self
    (spri d nil-reg (tos))
    (movi d P (tos))                                        ; op
    (movi d A1 (tos))                                       ; obj
    (movi d ($ (fx+ (fixnum-ashl 4 16) header/vframe)) (tos))
    (addr (label traced-op-return) (tos))
    (jump (label dispatch))
t-op))

(lap-template (0 0 -1 nil stack handle-traced-op-return)               ;86/12/27
traced-op-return                  
    (cmpi d AN (d@r nil-reg slink/nil-car))     ; did we get a method?
    (j= traced-op-default)                      ; AN contains code
    (movi d A1 P)                               ; environment
    (movi d (d@r P -2) TP)
    (movi d (d@r SP 16) A1)                        ; self is first arg of method
    (jbr op-icall)
traced-op-default
    (movi d (d@r P 6) P)                        ; rhs is operation
    (jbr default)
handle-traced-op-return    
    (spri d nil-reg AN)
    (ret ($ 0)))
  

;;; We have the operation in P, the object in A1 and we can use AN which is
;;; where the method is returned

(define *operation-template*
  (lap-template (3 0 1 t heap operation-handler)
    (movi d A1 (tos))                                       ; self
    (spri d nil-reg (tos))                                  ; next
    (movi d P (tos))                                        ; op
    (movi d A1 (tos))                                       ; obj
    (movi d ($ (fx+ (fixnum-ashl 4 16) header/vframe)) (tos))
    (addr (label dispatch-return) (tos))
dispatch 
    (movi d A1 S0)                                    ; is object extend?
    (andi b ($ 3) S0)                              
    (cmpi b ($ tag/extend) S0)
    (jn= object-not-extend)                         ; if so
    (movi d (d@r A1 -2) TP)                           ; get object's header
    (movi d TP S0)
    (andi b ($ 3) S0)                                 ; is header a template?
    (cmpi b ($ tag/extend) S0)
    (jn= object-not-closure)                        ; if so
    (cmpi d ($ N32-JUMP-ABSOLUTE-HACK) (@r TP))   ; closure internal template?
    (j= cit)
    (movxid w (d@r TP -8) S0)                         ; get signed handler offset
    (cmpi w ($ 0) S0)
    (j= no-handler)                                 ; if so, no handler
    (jump (index-b (@r TP) S0))                       ; jump to handler
no-handler
    (spri d nil-reg AN)
    (ret ($ 0))
cit
    (movi d (d@r tp 6) an)
    (movxid w (d@r an -8) S0)                         ; get signed handler offset
    (cmpi w ($ 0) S0)
    (j= no-handler)                                 ; if so, no handler
    (jump (index-b (@r an) S0))                       ; jump to handler
object-not-extend
    (movi d (d@r nil-reg slink/dispatch) AN)
    (cmpi b ($ tag/fixnum) S0)
    (j= fixnum)
    (cmpi b ($ tag/pair) S0)
    (j= pair)
    (movi d A1 S0)
    (cmpi b ($ header/char) S0)
    (j= char)
    (cmpi b ($ header/true) S0)
    (j= true)
    (cmpi b ($ header/nonvalue) S0)
    (j= nonvalue)
    (movi d (d@r AN (static 'handle-immediate)) A1)
    (movi d (d@r a1 2) a1)
    (jump (label dispatch))
true
    (movi d (d@r AN (static 'handle-true)) A1)
    (movi d (d@r a1 2) a1)
    (jump (label dispatch))
fixnum   
    (movi d (d@r AN (static 'handle-fixnum)) A1)
    (movi d (d@r a1 2) a1)
    (jump (label dispatch))
pair
    (movi d (d@r AN (static 'handle-pair)) A1)
    (movi d (d@r a1 2) a1)
    (jump (label dispatch))
char
    (movi d (d@r AN (static 'handle-char)) A1)
    (movi d (d@r a1 2) a1)
    (jump (label dispatch))            
nonvalue
    (movi d (d@r AN (static 'handle-nonvalue)) A1)
    (movi d (d@r a1 2) a1)
    (jump (label dispatch))            
object-not-closure
    (movi d (d@r nil-reg slink/dispatch) AN)
    (movi d (d@r AN (static '*handlers*)) AN)
    (movi d (d@r AN 2) AN)
    (movi d TP S0)                            ; get header field
    (andi d ($ #x7C) S0)                      ; lo seven bits have (tagged) offset
    (movi d (index-b (d@r AN 2) S0) A1)       ; index into vector of handlers
    (jump (label dispatch))
operation-handler
    (movi d (d@r A1 offset/operation-handler) A1)
    (jump (label dispatch))))


;;; At the top of the join loop the stack looks like    self                       
;;;                                                     next
;;;                                                     op
;;;                                                     obj
;;;                                                     vframe-header
;;;                                               sp -> dispatch-return-template

(define *join-template*                                                ;86/12/27
  (lap-template (2 0 1 t heap join-handler)
join-template
    (movi d (d@r P 2) P)                     ; joined lhs
    (jump (*d@r nil-reg slink/icall))                       
join-handler                                            
    (movi d (d@r A1 6) (d@r SP 16))          ; next <- rhs
    (movi d (d@r A1 2) A1)                   ; get joined lhs
    (movi d A1 (d@r SP 8))                   ; obj  <- lhs
    (addr (label join-return) (tos))
    (jump (label dispatch))))                ; try to get a handler from lhs

(lap-template (0 0 -1 t stack join-return-handler)                     ;86/12/27
join-return
    (cmpi d AN (d@r nil-reg slink/nil-car))  ; did we get a handler?
    (j= join-miss)
    (ret ($ 0))
join-miss
    (movi d (d@r SP 16) A1)                  ; get next
    (movi d A1 (d@r SP 8))                   ; obj <- next
    (movi d (d@r nil-reg slink/dispatch) AN)                    
    (spri d nil-reg (d@r SP 16)) ; next <- tbsh
    (jump (label dispatch))                 ; try rhs
join-return-handler
    (spri d nil-reg AN)
    (ret ($ 0)))

(define *bogus-entity-template*                                        ;86/12/27
  (lap-template (2 0 1 t heap bogus-entity-handler)
    (movi d (d@r P 2) P)
    (jump (*d@r nil-reg slink/icall))
bogus-entity-handler
    (movi d nargs (d@r TASK task/scratch))
    (movi d A2 (d@r TASK 4))
    (movi d A3 (d@r TASK 8))
    (movi d ($ 1) S0)
    (jsr (*d@r nil-reg slink/nary-setup))
    (movi d (d@r A1 6) A2)               ; bogus-entity handler
    (movi d P A1)                        ; operation is argument to handler
    (movi d A2 P)
    (movi d (d@r TASK task/scratch) (tos))
    (movi d AN (tos))
    (addr (label bogus-return) (tos))
    (movi d ($ 2) NARGS)
    (jump (*d@r nil-reg slink/icall))))

(lap-template (1 1 -1 nil stack bogus-return-handler)                  ;86/12/27
bogus-return
    (cmpi d A1 (d@r nil-reg 1))
    (jn= bogus-return-hit)
    (movi d (d@r nil-reg slink/dispatch) AN)
    (movi d (d@r SP 4) A3)               ; args
    (movi d A1 A2)                       ; method
    (movi d (d@r AN (static 'bogus-return-miss)) A1)
    (movi d (d@r a1 2) a1)
    (movi d (d@r AN (static 'apply)) P)
    (movi d (d@r p 2) p)
    (adjspi b ($ -12))
    (movi d ($ 4) NARGS)
    (movi d (d@r P -2) TP)
    (jump (@r TP))
bogus-return-hit
    (movi d (d@r nil-reg slink/dispatch) AN)
    (movi d (d@r SP 4) (d@r TASK (+ task/T0 12)))               ; args
    (movi d A1 A2)                       ; method
    (movi d (d@r AN (static 'bogus-return)) A1)
    (movi d (d@r a1 2) a1)
    (movi d (d@r AN (static 'apply)) P)
    (movi d (d@r p 2) p)
    (movi d ($ 5) NARGS)      ; dummy obj in a3
    (movi d (d@r P -2) TP)
    (jump (@r TP))
bogus-return-handler
    (spri d nil-reg AN)
    (ret ($ 0)))

(define (bogus-return-miss method  . args)
  (lap ()
    (spri d  nil-reg AN)                  ; compiled handlers return register
    (addr (label join-return) A1)
    (cmpi d (@r SP) A1)
    (j= joined-bogus-return-miss)
    (movi d (d@r SP 12) P)                ; restore operation
    (ret ($ 0))
joined-bogus-return-miss
    (movi d (d@r SP 16) P)                ; restore operation
    (adjspi b ($ -4))                      ; pop return addr
    (jbr join-miss)))

(define (bogus-return method obj . args)
  (lap ()
    (movi d (d@r SP 8) NARGS)            ; restore nargs and pop continuation
    (addi d ($ 1) NARGS)                  ; add one for obj
    (adjspi b ($ -12))
    (movi d A1 P)                        ; method in procedure register
    (addr (label join-return) A1)          ; is a join return address on top?
    (cmpi d (@r SP) A1)
    (jn= bogus-dispatch-return)
joined-bogus-return
    (adjspi b ($ -4))                      ; pop join return addr
bogus-dispatch-return
    (movi d (d@r SP 20) A1)              ; self is first of interpreted method
    (movi d (d@r SP 8)  A2)              ; obj is second of interpreted method
    (adjspi b ($ -24))                    ; dispatch return + vframe 
    (jump (*d@r nil-reg slink/icall))))


(define *magic-frame-template*                                         ;86/12/27
  (lap-template (4 0 -1 t stack magic-frame-handler)
    (adjspi b ($ -20))
    (movi d (@r sp) tp)
    (jump (@r tp))
magic-frame-handler
    (movi d (d@r nil-reg slink/dispatch) AN)
    (movi d (d@r AN (static 'handle-magic-frame)) A1)
    (movi d (d@r a1 2) a1)
    (jump (label dispatch))))

(dispatch-init)