(herald n32_bignum (env tsys))                                         ;87/02/19

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

(define (set-bignum-length! bignum length)                             ;87/02/19
  (lap ()  
    (movi d (d@r A1 -2) S0)           ; get header
    (ashi d ($ -6) S0)                ; length in bytes
    (andi b ($ #b11111100) S0)
    (subi d A2 S0)                    ; size of bogus bytev including header
    (subi d ($ 4) S0)                 ; bytev length
    (ashi d ($ 8) S0)
    (movi b ($ header/bytev) S0)      ; bogus bytev header
    (movi d S0 (index-b (d@r A1 2) A2))
    (movi d A2 S0)                    ; new length
    (ashi d ($ 6) S0)
    (movi b (d@r A1 -2) S0)
    (movi d S0 (d@r A1 -2))
    (movi d ($ -2) NARGS)
    (movi d (@r sp) tp)
    (jump (@r tp))))

(define-constant (bignum-positive? bignum) ; if bit 7 of header is on  ;87/02/19
  (fx= (mref-8-u bignum -4) 
       (fixnum-add header/bignum 128)))

(define-constant bignum-negate!                                        ;87/02/19
  (primop bignum-negate! ()
    ((primop.side-effects? self) t)
    ((primop.generate self node)                               
     (let ((reg (->register 'pointer node (leaf-value ((call-arg 2) node)) '*)))
       (emit n32/xori b (machine-num #b10000000) (reg-offset reg -2))))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) bignum)])))


;;; Somewhat tricky to glue together two tagged 30-bit integers in one 64-bit
;;; (untagged) register pair, using only 2 scratch registers.

(define (%digit-divide x1 x0 y)  ; Divide x1x0 by y with x1 < (* 2 y)  ;87/02/19
  (lap ()                        ; assumes (S0,NARGS) is a register pair
    (movi d A2 S0)                 ; lo reg gets lo bigit
    (roti d ($ -2) S0)             ; remove type tag
    (movi d A1 NARGS)              ; hi reg gets hi bigit
    (andi d ($ #b1100) NARGS)      ; grab 2 least significant bits
    (roti d ($ -4) NARGS)          ; move them to the top 2 bits
    (ori  d NARGS S0)              ; and transfer to lo reg
    (movi d A1 NARGS)              ; hi reg gets hi bigit again (only 2 scr regs)
    (lshi d ($ -4) NARGS)          ; remove type tag and 2 lsbs
                                 ; Dividend now in (S0,NARGS)
    (movi d A3 (d@r TASK task/extra-scratch))     ; Divisor
    (roti d ($ -2) (d@r TASK task/extra-scratch)) ; remove tag

    (deii d (d@r TASK task/extra-scratch) S0)    ; Extended divide

    (ashi d ($ 2) NARGS)           ; Fixnumize quotient
    (ashi d ($ 2) S0)              ;   and remainder
    (movi d NARGS A1)              ; Return quotient
    (movi d S0 A2)                 ;   and remainder
    (movi d ($ -3) nargs)          ; Two values returned
    (movi d (@r sp) tp)
    (jump (@r tp))))

