(herald syscheck)
            
(define (syscheck files ext)
    (cond ((compile-noise-files (map ->filename files) ext)
           => (lambda (free)
                (pp `(unresolved ,free))
                *repl-wont-print*))
          (else
           'all-variables-resolved)))

(define (compile-noise-files files ext)
  (iterate loop ((files files) (def bootstrap-symbols) (free '()))
    (cond ((null? files)
           (iterate loop ((files free) (res '()))
             (cond ((null? files) res)
                   (else
                    (let ((free (setdiff (cadar files) def)))
                      (if free
                          (loop (cdr files) `((,(caar files) ,free) . ,res))
                          (loop (cdr files) res)))))))
          (else
           (let ((vars 
               (with-open-streams ((noi (open (filename-with-type (car files) ext)
                                             '(in))))
                  (format t "~s~%" (filename-name (car files)))
                  (read noi))))
               (loop (cdr files)
                     (union def (union (nth vars 6) (nth vars 8)))
                     `((,(filename-name (car files))
                        ,(union (nth vars 2) (nth vars 4)))
                       . ,free)))))))


(define-constant BOOTSTRAP-SYMBOLS 
  '(*boot-env* *the-initial-symbols* *the-slink* *the-initial-modules*
    *pure-initial-mem-begin* *pure-initial-mem-end* *impure-initial-mem-begin*               
    *impure-initial-mem-end* *code-unit-map* *the-environment*)) 





