(herald ieee_float
  (env tsys))

;;; Flonum dismemberment.

;;; Returns sign, and normalized mantissa and exponent  
;;; PRECISION is number of bits desired in the mantissa 
;;; EXCESS is the exponent excess
;;; HIDDEN-BIT-IS-1.? is true if the hidden bit preceeds the
;;;  binary point (it does in Apollo IEEE, does not on the VAX).

(define (normalize-float-parts sign m e precision excess hidden-bit-is-1.?)
  (let* ((have (integer-length m))
         (need (fx- precision have))
         (normalized-m (%ash m need))
         (normalized-e (- (+ e 
                             precision 
                             excess
                             (if hidden-bit-is-1.? -1 0))
                           need)))
     (return (if (= sign 1) 0 1) normalized-m normalized-e)))


(define (string->flonum s)
  (kludgy-string->flonum s))

(lset *print-flonums-kludgily?* t)

(define-handler double-float
  (object nil
    ((extended-number-type self) %%flonum-number-type)
    ((print self stream)
     (if *print-flonums-kludgily?*
         (print-flonum-kludgily self stream)
         (print-flonum self stream)))))
                                               
