(herald vorbit_changes)

(set (print-env-warnings?) nil)
(set *compile-primops?* nil)
(define (cs x) (create-support x x))
(set (table-entry *modules* 'bignum) '(osys vax_bignum))
(load-quietly '(t3_primops vconstants t))
(set (orbit-syntax-table) (env-syntax-table t-implementation-env))
(comment
(walk load '((assembler expand)
                (assembler fg_spec)  
             (assembler fg_expr)  
          (assembler as_syntax)))
)

(define (orbit-vax-init . directory)
  (orbit-vax-setup (if directory (car directory) '#f))
  (orbit-init 'base
              'constants
              'primops
              'arith
              'locations
              'low
              'predicates
              'open
              'aliases
              'carcdr
	      'genarith))
  (walk (lambda (x) (load x orbit-env)) (*value orbit-env '*orbit-vax-files*))
  (load '(assembler vaxmini))
  (walk (lambda (x) (load x orbit-env)) (cdr (*value orbit-env '*tas-vax-files*)))
  (load '(back_end unvaxgen) orbit-env)
 (orbit-vax-init 't3_primops/VAXM68)


(define (comsys system . start)
  (walk (lambda (file)
	  (xcase (car file)
            ((osys)
	     (set (tc-syntax-table) (env-syntax-table t-implementation-env))
	     (comfile file))
	    ((t3_primops)
	     (set (tc-syntax-table) primop-syntax-table)
	     (bind ((write-support-file false))
	       (comfile file)))))
	(let ((files (xcase system
		       ((z) *zvm-system*)
		       ((t) *t-system*))))
	  (if start (mem alikev? (car start) files) files))))
	
(set (print-env-warnings?) t)

