(herald (back_end n32arithgen)                                         ;86/11/13
  (env t (orbit_top defs)))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

;;; Most code resembles M68 because we have no 3-op instructions.  DIV and 
;;; ASH were modelled on the VAX DIV.  Some rewriting to remove duplicated
;;; code.


(define (n32-op op)                                                    ;87/05/18
  (xcase op                
    ((add) n32/addi)
    ((sub) n32/subi)
    ((mul) n32/muli)
    ((div) n32/quoi)
    ((rem) n32/remi)
    ((ash) n32/ashi)
    ((and) n32/andi)
    ((or)  n32/ori)
    ((xor) n32/xori)
    ((mov) n32/movi)
    ((cmp) n32/cmpi)))

(define (n32-size rep)                                                 ;87/05/18
  (xcase rep
    ((rep/char rep/integer-8-u rep/integer-8-s) b)
    ((rep/integer-16-u rep/integer-16-s) w)
    ((rep/pointer rep/integer) d)))

(define (fixnum-comparator node inst)                                  ;86/11/13
  (comparator node inst))

(define (character-comparator node inst)                               ;86/11/13
  (comparator node inst))

(define (comparator node inst)                                         ;86/11/13
  (destructure (((then else () ref1 ref2) (call-args node)))
    (let* ((val2 (leaf-value ref2))   ;; like VAX, opposite of M68
           (val1 (leaf-value ref1))
           (rep (cond ((and (variable? val1) 
                            (neq? (variable-rep val1) 'rep/pointer))
                       (variable-rep val1))
                      ((variable? val2) (variable-rep val2))
                      (t 'rep/pointer))))
        (let ((access (access-with-rep node val2 rep)))
          (protect-access access)
          (emit (n32-op 'cmp) (n32-size rep)
                (access-with-rep node val1 rep) 
                access)
          (emit-jump (get-jop inst rep) else then)
          (release-access access)))))

(define (get-jop inst rep)                                             ;86/11/13
  (xcase inst 
    ((jneq) jump-op/jn=)
    ((jgeq)
     (case rep
       ((rep/char rep/integer-8-u rep/integer-16-u)  ;;; unsigned guys
        jump-op/uj>=)
       (else
        jump-op/j>=)))))
            
;;; literals converted at compile time (!)

(define (generate-char->ascii node)                                    ;86/11/13
  (destructure (((cont arg) (call-args node)))
    (receive (t-spec t-rep) (continuation-wants cont)
      (let ((var (leaf-value arg))
            (t-reg (get-target-register node t-spec))) 
        (lock t-reg)            
        (cond ((variable? var)
               (let ((acc (access-value node var)))
                 (unlock t-reg)
                 (kill-if-dying var node)
                 (case (variable-rep var)
                   ((rep/char)
                    (really-rep-convert node acc 'rep/integer-8-u t-reg t-rep))
                   (else
                    (protect-access acc)
                    (let ((reg (if (eq? (reg-type t-reg) 'scratch)
                                   t-reg
                                   (get-register 'scratch node '*))))
                      (release-access acc)
                      (generate-move acc reg)
                      (emit n32/lshi w (machine-num (if (eq? t-rep 'rep/pointer)
                                                      -6 -8))
                                       reg)
                      (generate-move reg t-reg))))))
              (else
               (emit n32/movi d
                     (access-with-rep node (char->ascii var) t-rep) 
                     t-reg)))
          (mark-continuation node t-reg)))))

(define (generate-ascii->char node)                                    ;87/05/18
  (destructure (((cont arg) (call-args node)))
    (receive (t-spec t-rep) (continuation-wants cont)
      (let ((var (leaf-value arg))
            (t-reg (get-target-register node t-spec)))
        (lock t-reg)                        
        (cond ((variable? var)
               (let ((acc (access-value node var)))
                 (unlock t-reg)
                 (kill-if-dying var node)
                 (case (variable-rep var)
                   ((rep/pointer)
                    (case t-rep 
                      ((rep/pointer)
                       (shift-to-pointer-reg acc t-reg 6 var node))
                      (else                         
                       (generate-move acc t-reg)
                       (emit n32/lshi w (machine-num -2) t-reg))))
                   (else
                    (case t-rep
                      ((rep/pointer)
                       (shift-to-pointer-reg acc t-reg 8 var node))
                      (else
                       (if (neq? acc t-reg)
                           (emit (n32-op 'mov) (n32-size (variable-rep var))
                                 acc t-reg))))))))
              (else
               (emit n32/movi d
                     (access-with-rep node (ascii->char var) t-rep)
                     t-reg)))
          (mark-continuation node t-reg)))))

(define (shift-to-pointer-reg acc t-reg nbits var node)                ;87/05/18
  (protect-access acc)
  (let ((reg (if (eq? (reg-type t-reg) 'scratch)
                  t-reg
                  (get-register 'scratch node '*))))
    (release-access acc)
    (emit (n32-op 'mov) (n32-size (variable-rep var)) acc reg)
    (emit n32/ashi w (machine-num nbits) reg)
    (emit n32/andi d (machine-num #xffff) reg)
    (emit n32/movi b (machine-num header/char) reg)
    (generate-move reg t-reg)))


(define (generate-fixnum-binop node inst commutes?)                    ;87/02/26
 (case inst 
   ((mul)     (do-multiply node))
   ((ash div) (do-post-shifted-binop node inst))
   (else
  (destructure (((cont right left) (call-args node)))
    (receive (t-spec t-rep) (continuation-wants cont)
      (let* ((lvar (leaf-value left))
             (rvar (leaf-value right))
             (l-acc (access-with-rep-reg node lvar t-rep t-spec)))
        (protect-access l-acc)
        (let ((r-acc (access-with-rep-reg node rvar t-rep t-spec)))
          (release-access l-acc) 
          (let ((l-target? (and commutes?
                                (can-clobber? l-acc lvar node)))
                (r-target? (can-clobber? r-acc rvar node)))
            (cond ((and l-target?
                        (or (not r-target?) 
                            (eq? t-spec l-acc)))
                   (emit (n32-op inst) (n32-size t-rep) r-acc l-acc)
                   (kill lvar)
                   (mark-continuation node l-acc))
                  (r-target?
                   (emit (n32-op inst) (n32-size t-rep) l-acc r-acc)
                   (kill rvar)
                   (mark-continuation node r-acc))
                  (else
                   (protect-access l-acc)
                   (let ((t-reg (get-2op-target-register node cont t-spec)))
                     (release-access l-acc)
                     (emit (n32-op 'mov) (n32-size t-rep) r-acc t-reg)
                     (emit (n32-op inst) (n32-size t-rep) l-acc t-reg)
                     (mark-continuation node t-reg))))))))))))

(define (do-multiply node)                                             ;87/02/26
  (destructure (((cont right left) (call-args node)))
    (receive (t-spec t-rep) (continuation-wants cont)
      (let ((lvar (leaf-value left))
            (rvar (leaf-value right)))
        (receive (l-rep r-rep)
                 (get-reps-for-multiply lvar rvar t-rep)
          (let ((l-acc (access-with-rep-reg node lvar l-rep t-spec)))
            (protect-access l-acc)
            (let ((r-acc (access-with-rep-reg node rvar r-rep t-spec)))
              (release-access l-acc) 
              (let ((l-target? (can-clobber? l-acc lvar node))
                    (r-target? (can-clobber? r-acc rvar node)))
                (cond ((and l-target?
                            (or (not r-target?) 
                                (eq? t-spec l-acc)))
                       (emit (n32-op 'mul) (n32-size t-rep) r-acc l-acc)
                       (kill lvar)
                       (mark-continuation node l-acc))
                      (r-target?
                       (emit (n32-op 'mul) (n32-size t-rep) l-acc r-acc)
                       (kill rvar)
                       (mark-continuation node r-acc))
                      (else
                       (receive (acc1 acc2)
                                (if (eq? r-rep t-rep)
                                    (return r-acc l-acc)
                                    (return l-acc r-acc))
                         (protect-access acc2)
                         (let ((t-reg (get-2op-target-register node cont t-spec)))
                           (release-access acc2)
                           (emit (n32-op 'mov) (n32-size t-rep) acc1 t-reg)
                           (emit (n32-op 'mul) (n32-size t-rep) acc2 t-reg)
                           (mark-continuation node t-reg)))))))))))))

;;; If result is to be tagged (t-rep is rep/pointer), use one tagged and one
;;; untagged operand.  This prevents unnecessary overflow.

(define (get-reps-for-multiply lvar rvar t-rep)                        ;86/11/12
  (if (eq? t-rep 'rep/pointer)
      (cond ((variable? lvar) 
             (if (eq? (variable-rep lvar) 'rep/pointer)
                 (return 'rep/pointer 'rep/integer)
                 (return 'rep/integer 'rep/pointer)))
            ((and (variable? rvar)
                  (eq? (variable-rep rvar) 'rep/pointer))
             (return 'rep/integer 'rep/pointer))
            (else
             (return 'rep/pointer 'rep/integer)))
      (return t-rep t-rep)))
               

;;; DIV and ASH must be post-shifted if result is to be tagged.  Can't 
;;; pre-shift (as in MULTIPLY) because (fx/ 1 2) or (ash 1 -1) would leave 
;;; incorrect type bits.  Intermediate (untagged) result must be stored
;;; in a scratch register.  (Modeled on VAX DO-DIVIDE)

(define (do-post-shifted-binop node inst)                              ;87/02/26
  (destructure (((cont right left) (call-args node)))
    (receive (t-spec t-rep) (continuation-wants cont)
      (let ((lvar (leaf-value left))
            (rvar (leaf-value right))
            (op-rep (xcase inst
                           ((ash) 'rep/integer)
                           ((div) t-rep))))
        (let ((l-acc (access-with-rep-reg node lvar op-rep t-spec)))
          (protect-access l-acc)
          (let ((r-acc (access-with-rep-reg node rvar op-rep t-spec)))
            (release-access l-acc)
            (cond ((eq? t-rep 'rep/pointer)
                   (protect-access l-acc)
                   (let* ((t-reg (get-2op-target-register node cont t-spec))
                          (scratch (if (eq? (reg-type t-reg) 'scratch)
                                       t-reg
                                       (get-register 'scratch node '*))))
                     (release-access l-acc)
                     (generate-move r-acc scratch)
                     (emit (n32-op inst) (n32-size t-rep) l-acc scratch)
                     (emit n32/ashi d (machine-num 2) scratch)
                     (generate-move scratch t-reg)
                     (mark-continuation node t-reg)))
                  ((can-clobber? r-acc rvar node)
                   (emit (n32-op inst) (n32-size t-rep) l-acc r-acc)
                   (kill rvar)
                   (mark-continuation node r-acc))
                  (else
                   (protect-access l-acc)
                   (let ((t-reg (get-2op-target-register node cont t-spec)))
                     (release-access l-acc)
                     (emit (n32-op 'mov) (n32-size t-rep) r-acc t-reg)
                     (emit (n32-op inst) (n32-size t-rep) l-acc t-reg)
                     (mark-continuation node t-reg))))))))))


;;; Similar to GET-TARGET-REGISTER but unique to binops
         
(define (get-2op-target-register node cont t-spec)                     ;86/11/11
  (cond ((not (register? t-spec))
         (get-register t-spec node '*))
        ((and (not (locked? t-spec))
              (maybe-free t-spec cont))
          t-spec)
        (else
         (get-register (reg-type t-spec) node '*))))

;;; We can use ACC as a target register if its contents VAR exist elsewhere
;;; or if VAR is dying.

;(define (can-clobber? acc var node)                                    ;86/11/12
;  (and (register? acc)
;       (or (neq? acc (register-loc var))
;           (dying? var node))))
;

;;; Yes, I can clobber a register if its contents exist elsewhere, but because
;;; David didn't make this distinction it doesn't mesh with the rest of the
;;; code.  In GENERATE-FIXNUM-BINOP, we have:
;;;     (r-target? (can-clobber? r-acc rvar node)))
;;; If we choose r-acc as the target register, we do (kill rvar).  This is 
;;; only appropriate if the value is dying, which David's code guarantees.
;;; n32/mul needs the test.  m68 didn't because mul isn't an op; vax didn't
;;; because of 3-op instructions.

(define (can-clobber? acc var node)                                    ;87/02/26
  (and (register? acc)
       (dying? var node)))

(define (generate-two-fixnums node)
  (destructure (((then else () ref1 ref2) (call-args node)))
    (let ((val2 (leaf-value ref2))   ;; like VAX, opposite of M68
	  (val1 (leaf-value ref1))
	  (scratch (get-register 'scratch node '*)))
      (let ((access (access-with-rep node val2 'rep/pointer)))
	(protect-access access)
	(emit n32/movi d (access-with-rep node val1 'rep/pointer) scratch)
	(if (variable? val2)
	    (emit n32/ori d access scratch))
	(emit n32/andi b ($ 3) scratch)
	(emit n32/cmpi b ($ 0) scratch)
	(emit-jump jump-op/jn= else then)
	(release-access access)))))


(define (generate-op-with-overflow node op) 
  (destructure (((then else () ref1 ref2) (call-args node)))
    (let ((reg1 (access-with-rep node (leaf-value ref1) 'rep/pointer)))
      (protect-access reg1)
      (let ((reg2 (access-with-rep node (leaf-value ref2) 'rep/pointer)))
	(release-access reg1)
	(let ((scratch (get-register 'scratch node '*)))
	  (emit n32/movi d reg1 scratch)
	  (xcase op
	    ((add) (emit n32/addi d reg2 scratch))
	    ((subtract) (emit n32/subi d reg2 scratch))
	    ((multiply)
	     (emit n32/ashi d ($ -2) scratch)
	     (emit n32/muli d reg2 scratch)))
	  (emit-jump jump-op/flag_set then else)                               
	  (mark (car (lambda-variables else)) scratch))))))



