@part[ADVICE, Root "TMAN.MSS"]		@Comment{-*-System:TMAN-*-}
@appendix[Friendly advice]

@section[Comparison with other Lisp dialects]

Some of the terminology may take some getting used to.  We always say
@i[procedure] instead of @i[function], for example.  @i[Special form]
and @i[reserved word] have special meaning.  @i[Syntax] usually refers
not to what the reader does but to what the compiler does.
@index[functions]

As in Common Lisp, but unlike most familiar Lisp dialects besides Scheme,
@Tau[] is lexically scoped.

As in Scheme, there is full support for lexical closures,
and tail-recursive calls are reliably performed as jumps.

Generic operations are like message-passing.
@tc[JOIN] can be used to implement object systems analogous to
the Lisp Machine's flavor system.

Synonyms generalize Lisp Machine Lisp's @tc[MAKE-SYN-STREAM].

See also the equivalences appendix for some rough functional analogues.

@section[Incompatibilities]

The empty list is distinguished from the symbol whose print name
is @tc["NIL"].  That is, @wt[(NEQ? NIL 'NIL)].  The @i[value] of the
variable @tc[NIL] is the empty list.  The empty list is the same as the
logical false value.

All @qu"global" variables must be declared using @tc[LSET] before they
are assigned using @tc[SET] or @tc[BIND].  This is quite unlike most Lisp
dialects where the first @tc[SETQ] causes a variable to come into existence.

@tau[] has no @tc[FEXPR] or @tc[NLAMBDA] mechanism.  Their effect may be
accomplished using procedures or macros.

There are no @tc[SPECIAL] declarations and no implicit dynamic
binding.  @tc[BIND] must be used explicitly when a variable is to be
dynamically bound. 

@tc[COND] and @tc[CASE] don't yield nil in the fall-through case;
they yield undefined values.

@tc[RETURN] and @tc[GO]-tags are not supported in @tc[DO].
Lisp @tc[RETURN] may be simulated using @wt[(CATCH RETURN ...)].

@tc[NTH] is incompatible with Maclisp's function of the same name.
Maclisp's takes the index as the first argument and the list as
the second, instead of the other way around.

@tc[LAST] returns the last @i[element] of the list, not the
last @i[pair], as in Maclisp.
Maclisp's @tc[LAST] is like @tau[]'s @tc[LASTCDR].

@tc[APPEND] isn't defined to copy all but the last list.  I.e.
the language definition allows the implementation to
yield @tc[X], and not a copy of it, for @tc[(APPEND X '())].

@tc[PUSH]'s syntax is incompatible with that of @tc[PUSH]
in Maclisp and Common Lisp.

Locatives aren't as cheap as they are in Lisp Machine Lisp; creating
a locative may involve consing.

@dc{ 

@section[Style suggestions]

Coding style cannot be dictated.  The @Tau[] designers and implementors
attempt to adhere to a strict programming discipline.  The less
@qu"randomness" there is in a program, the easier it is to understand.
The noise level must be kept to a minimum.  ...

Understand @tc[NIL], @tc[()], @tc['()], and @tc[T].
As a matter of style, users are advised to write @tc[NIL] as an
expression which evaluates to a logically false value, and @tc['()] as
an expression which evaluates to the empty list.  Use @tc[()] in
quoted structures: @wt[(CADR '(A () B)) @ev[] ()], but @wt[(CADR '(A NIL
B)) @ev[] NIL].

That car and cdr of null evaluate to null is sometimes considered a
programming convenience, but code which depends on this fact may be
difficult to read and is considered stylistically poor.

In Maclisp-like Lisp dialects, many users program with macros as a way
to get certain trivial operations to @qu"open-code."  @Tau[] provides
@i[integrable procedures] (see section @Ref[DefineIntegrableSection])
for that purpose, and we encourage their use.

It is usually unnecessary to use @tc[SET] on local variables.
@tc[LET] and various side-effect-free iteration constructs usually
suffice to express most code which in other Lisp dialects would
require @tc[SET].

   Avoid irregular abbreviations.

   Indent and comment properly.

   Avoid side-effects.

   Avoid @tc[EVAL].

   Use locales sparingly.

}
