@part[Program, root "TMAN.MSS"] @Comment{-*-System:TMAN-*-}
@chap[Program structure]
@label[Program chapter]


This chapter provides information about organizing, loading, and
compiling programs.


@section[Environment structure]

Lexical environments in @Tau[] are hierarchically arranged.  Variable
bindings are inherited from outer (superior) contours to inner
(inferior) ones.  At the top of the hierarchy is a
root environment, which has no bindings in it.  Inferior to that is a
standard environment which has bindings for all standard system
variables, for example, @tc[CAR] and @tc[+].  (See section @ref[standard
environment section].)
Inferior to the standard environment are environments into which programs
have been or are to be loaded.  In the standard environment, the variable
@tc[*STANDARD-ENV*] is bound to the standard environment itself.

When a @Tau[] system starts up, it sets up an initial environment
configuration which has one environment inferior to the standard
environment, called the @iix[scratch environment].  The variable
@tc[*SCRATCH-ENV*] is bound in the standard
environment to the scratch environment.  The scratch environment has
no variable bindings in it at first; however, the initial
read-eval-print loop (section @ref[REPL section]) is started in this
environment, so that if no other provision is made, user global variable
(i.e. definitions) will be made in the scratch environment.

In @Timp[] 2.7, there is another environment called the
@iix[implementation environment] (page @pageref[*T-IMPLEMENTATION-ENV*]).
This is the value of @tc[*T-IMPLEMENTATION-ENV*] in the standard
environment.  The implementation environment is not inferior to the
standard environment, but instead is inferior to the root.

  @begin[ProgramExample]
                            ------ root environment (empty) ----------
                           /                            |             \
            ------- *STANDARD-ENV* ------     *T-IMPLEMENTATION-ENV*   ...
           /      |        |      ...    \
*SCRATCH-ENV*  *TC-ENV*  *EWE-ENV*   other environments
                                    /      ...         \
                                   ...                 ...
  @end[ProgramExample]

Empty environments may be created using @tc[MAKE-EMPTY-LOCALE] (page
@pageref[MAKE-EMPTY-LOCALE]).  For example:
  @begin[ProgramExample]
(DEFINE *ALMOST-USELESS-ENV* (MAKE-EMPTY-LOCALE '*ALMOST-USELESS-ENV*))
(*DEFINE *ALMOST-USELESS-ENV* '+ +)
(*DEFINE *ALMOST-USELESS-ENV* '- -)
(EVAL '(+ 5 (- 21 13)) *ALMOST-USELESS-ENV*)  @ev[]  13
  @end[ProgramExample]

@desc[*STANDARD-ENV* @yl[] @i[locale]]
The value of @tc[*STANDARD-ENV*] is an environment (a locale)
in which all system variables have appropriate values,
as described in this manual.  That is, it is a @i[standard environment]
in the sense of section @ref[StandardEnvironmentSection].
@index[Standard environment]
@EndDesc[*STANDARD-ENV*]

@label[user-env]@Comment{(REPL-ENV)}
@desc[*SCRATCH-ENV* @yl[] @i[locale]]
The value of @tc[*SCRATCH-ENV*] is an environment (a locale)
inferior to @tc[*STANDARD-ENV*].
It is provided by a @Tau[] implementation as an environment in which a user
may evaluate expressions and write programs.
Other evaluation environments may be created inferior
to @tc[*STANDARD-ENV*], however, with @tc[MAKE-LOCALE] (page
@pageref[MAKE-LOCALE]).
@EndDesc[*SCRATCH-ENV*]


@section[Source files]

@Tau[] programs are usually represented by collections of one or more text
files resident in a file system.  Text files containing @Tau[] programs
are called @iix[source files].

A source file consists of a sequence of (external representations of)
@Tau[] expressions.  Source files may be @i[loaded] into a @Tau[] environment.
When a file is loaded, the expressions in the file are evaluated.
Typically, this means that useful side-effects, such as procedure
definitions, occur which then make the program available in that @Tau[]
environment.
@index[loading]

A compilation (semantic analysis) step must occur either as a file
is being loaded, or prior to loading the file.  In the former case,
compilation is typically performed by a compiler such as the
@qu"standard compiler" (page @pageref[STANDARD-COMPILER]) which itself runs
relatively quickly and produces intermediate code which must then
be interpreted.  In the latter case, an auxiliary file known as an
@i[object file] is involved; the compilation step need only be performed
once, even if the file is to be loaded many times.  (The term @i[object
file] is completely unrelated to the term @i[object.])

A @i[file compiler] (such as TC; see section @ref[TC section]) takes
a source file as input and produces an object file as output.  The
object file may then be loaded in lieu of the source file, with
the same effect.

@BeginInset[Note:]
In the current implementation, the standard compiler cannot be used
as a file compiler, and TC cannot be used as an @qu"on-the-fly"
compiler.  In principle, the two dimensions of compiler and compilation
mode are orthogonal:  it should be possible to use either compiler
in either manner.  In practice, this is not the case, but it turns out
not to be too much of a problem.
@EndInset[]


@section[File syntax]

The first form in a source file must be a list whose car is the
symbol @tc[HERALD].  This form is not an expression, but
rather is part of the syntax of the file.
It provides information relevant to programs which operate on the
source file (such as readers, compilers, and loaders).
The syntax of a @tc[HERALD]-form is as follows:
  @begin[ProgramExample]
(HERALD @i[identification] . @i[items])
  @end[ProgramExample]
@i[Identification] should be either @tc[()] or a symbol identifying
the file (usually the same as the root of the name of the file).
It is for documentary purposes only.

@i[Items] is a sequence of lists.  Each @i[item] should be
a list beginning with a valid keyword symbol, as described below.

Example:
  @begin[ProgramExample]
(HERALD FACT
        (READ-TABLE *MATH-READ-TABLE*)
        (ENV T (MATH MATHMACROS)))
  @end[ProgramExample]

@info[NOTES="Herald item"]
@desc[(READ-TABLE @i[expression])]
@i[Expression] should evaluate to a read table, which is used
in reading the expressions which follow the @tc[HERALD]-form from
the source file.  The environment in which @i[expression] is evaluated
depends on the program processing the file (but might be, e.g., the
scratch environment).

If this item is absent, then expressions are read using the
standard read table.
@enddesc[READ-TABLE]

@info[NOTES="Herald item"]
@desc[(SYNTAX-TABLE @i[expression])]
@i[Expression] should evaluate to a syntax table, which is used
in compiling (evaluating) the expressions in the source file.
The environment in which @i[expression] is evaluated
depends on the program processing the file (but might be, e.g., the
scratch environment).

If this item is absent, then expressions are compiled according
to an appropriate syntax table: the syntax table associated with the
locale into which the file is being loaded, if the file is being loaded,
or the current value of @tc[(TC-SYNTAX-TABLE)] (see below), if the
file is being compiled using TC.
    @BeginInset[Bug:]
    In @Timp[] 2.7, this works in TC, but is ignored in the
    standard compiler (that is, when loading a source file directly).
    @tc[LOAD] will always use the syntax table of the environment into
    which the file is being loaded.
    @EndInset[]
@enddesc[SYNTAX-TABLE]

@dc{
@info[NOTES="Herald item"]
@desc[(SUPPORT @i[expression])]
@i[Expression] should evaluate to a support environment, which is
used to compile the file.
@enddesc[SUPPORT]
}

@info[NOTES="Herald item"]
@desc[(ENV @i[support-env-name] . @i[filespecs])]
Specifies a support (early binding) environment for compiling the file.
The support environment consists of the support environment named
by @i[support-env-name], augmented by information obtained from
support files named by @i[filespecs].

If this item is absent, then the standard support environment,
whose name is @tc[T], is used.  The ability to create and name other
support environments is not yet documented.
@enddesc[ENV]


@section[Loading files]

@dc{

    REQUIRE
    INCLUDE
    FILE-LOADED?

}


@desc[(LOAD @i[filespec] @i[environment]) @yl[] @i[undefined]]
Loads the file named by @i[filespec].  If the file is a source file,
then each expression in the file is compiled (with the standard
compiler) and run in @i[environment].  If the file is an object file,
as produced by TC, then the compiled object code is simply run in
@i[environment].

If no explicit file type is given in the @i[filespec], then @tc[LOAD]
will load either an object file (file type @tc[BIN]), if one exists,
or a source file (file type @tc[T]) otherwise.
@EndDesc[LOAD]

@dc{
@desc[(*REQUIRE @i[file-id] @i[filespec] @i[environment]) @yl[] @i[undefined]]
Ensures that the file specified by @i[filespec] has been
loaded into @i[environment].  More precisely, it loads the specified file
unless a file whose file identifier (as given in its @tc[HERALD] form)
is @i[file-id] has already been loaded into @i[environment].
@enddesc[*REQUIRE]

@info[Notes="Special form"]
@desc[(REQUIRE @i[file-id] @i[filespec]) @yl[] @i[undefined]]
Like @tc[*REQUIRE], but operates with the current lexical environment.
E.g. if the current lexical environment is @tc[*MATH-ENV*],
then
  @begin[ProgramExample]
(REQUIRE FACT (MATH FACT))  @ce[]  (*REQUIRE 'FACT '(MATH FACT) *MATH-ENV*)
  @end[ProgramExample]
@enddesc[REQUIRE]
}

@dc{
@desc[(OBJECT-FILE? @i[filespec]) @yl[] @i[boolean]]
Returns true if the specified file is an object file.
@index[Object files]
(Object files are the result of assembling the output of
TC; see page @pageref[COMFILE].)
@EndDesc[OBJECT-FILE?]

@desc[(OBJECT-FILE-STREAM? @i[input-stream]) @yl[] @i[boolean]]
Returns true if @i[stream] is a stream open on an object file.
This is only defined to work if no input has yet been read from @i[stream].
@EndDesc[OBJECT-FILE-STREAM?]
}


@section[File compilation]
@label[TC section]

In addition to the standard compiler invoked when @tc[EVAL] or
@tc[LOAD] is called,
@Timp[] provides a so-called optimizing compiler.  This compiler,
known as TC (for @qu"@Tau[] compiler"), trades compilation
speed for execution speed: @tc[STANDARD-COMPILER] tries to compile quickly,
while TC tries to generate executable code which will run
fast.@index[Compilers]@index[Early binding]

To help produce more efficient code, TC makes assumptions about the
values that some variables will have at run-time.  These assumptions
are called @iix[early bindings.]  For example, it will ordinarily assume
that the variable @tc[PAIR?] will have the standard @tc[PAIR?] predicate
as its top-level value.  This means that if an object file produced
under this assumption is loaded into a lexical environment where this
is not the case, then calls to @tc[PAIR?] will not execute the same as
they would if the source file had been loaded.

Early bindings are obtained from @iix[support environments].
The support environment to be used in compiling a file may be
specified by an @tc[ENV] clause in the file's
header.  (See page @pageref[ENV].)
A support environment may contain user-defined integrable procedure
and constant definitions.

Besides early binding, another source of improved efficiency is a
difference in the handling of undefined effects (that is, run-time
program errors).
@index[undefined effects]
When code compiled using the standard compiler incurs an error, an
error is signalled, and the error system is entered, giving the user
an opportunity to debug the problem at the point where it occurs.
Code compiled using TC has less error-checking, so the effect of an
error may go unnoticed until long after the error occurred, or a
secondary error of an obscure or unexpected kind will occur.

Instead of being a part of the normal @Timp[] run-time system, the optimizing
compiler is invoked as a separate program with an appropriate
system command
(probably @qu"@t[tc]").  When TC starts up it is in a
read-eval-print loop and looks very much like @timp[].
In fact, TC is simply a version of @Timp[] with the following additional
definitions available in @tc[*STANDARD-ENV*].

@desc[(COMFILE @i[filespec]) @yl[] @i[undefined]]

Compiles a file.  For example, to compile file @tc[fact.t], say
@wt[(COMFILE "fact")].  TC writes three output files, all having the
same file name as the
@tau[] source, and distinguished by extension:

@begin[Itemize]
The @iixs[noise file] is a transcript of what TC wrote to the terminal
in the course of the compilation.  TC also writes some additional
statistics and cross-referencing information to noise files.

The @iixs[support file] contains early binding information useful
for compiling other files with TC.  See the @tc[ENV] file header
clause, page @pageref[ENV].

The @iixs[assembly file] should be assembled on the target machine to
get an @iixs[object file] that can be loaded into @timp[].
@end[itemize]

The file extensions for the output files depend on the target system.
For MC68000/Aegis, VAX/Unix, and VAX/VMS, the extensions are as follows:
@begin[display]
@TabDivide[6]
System @\Architecture @\Support   @\Noise     @\Assembly  @\Object
Aegis  @\68000        @\@tc[.ams] @\@tc[.amn] @\@tc[.asm] @\@tc[.bin]
Unix   @\VAX11        @\@tc[.uvs] @\@tc[.uvn] @\@tc[.s]   @\@tc[.o]
VMS    @\VAX11        @\@tc[.vvs] @\@tc[.vvn] @\@tc[.mar] @\@tc[.bin]
@TabClear
@end[display]
@EndDesc[COMFILE]

@info[NOTES="Settable"]
@desc[(TC-SYNTAX-TABLE) @yl[] @i[syntax-table]]
This is the basic syntax table from which TC
obtains macro definitions.  TC obtains additional macro
definitions from the support environment set up by an @tc[(ENV ...)]
@tc[HERALD] clause.  Its default value is the syntax table of the
scratch environment.
@EndDesc[TC-SYNTAX-TABLE]

@info[NOTES="Settable"]
@desc[(TC-MACRO-DEFINITION-ENV) @yl[] @i[environment]]
The environment in which macro
definition bodies themselves are evaluated, either as a result of
encountering a @tc[DEFINE-LOCAL-SYNTAX] or @tc[LET-SYNTAX]
expression, or by loading macro definitions from a
support file.  Its default value is the scratch environment.
@enddesc[TC-MACRO-DEFINITION-ENV]

@dc{ Should talk about what the compiler does; model of compiler as file
transducer, procedure integration and optimization, and all the rest.
Implementation of closures; when things are consed, how big they are.
@tc[HERALD], environments, and support files.  Problems with readmacros
and routines used by macro definitions.  Future work. }

@dc{ Need to talk about debugging compiled code - nonvalues and all that.
"Reference to non-existent memory." }
