; "line-io", line oriented input/output functions for Scheme.
; Copyright (c) 1992, Aubrey Jaffer

;  (read-line port)					procedure
;  (read-line)						procedure

;Returns a string of the characters up to, but not including a newline
;or end of file, updating the port to point to the character following
;the newline.  If no characters are available, an end of file object
;is returned.  Port may be ommited, in which case it defaults to the
;value returned by current-input-port.

;  (read-line! string port)				procedure
;  (read-line! string)					procedure

;Fills string with characters up to, but not including a newline or
;end of file, updating the port to point to the last character read or
;following the newline if it was read.  If no characters are
;available, an end of file object is returned.  If a newline or end of
;file was found, the number of characters read is returned.
;Otherwise, #f is returned.  Port may be ommited, in which case it
;defaults to the value returned by current-input-port.

;  (write-line string port)				procedure
;  (write-line string)					procedure

;Writes string followed by a newline to the given port and returns an
;unspecified value.  Port may be ommited, in which case it defaults to
;the value returned by current-input-port.

(define (read-line . arg)
  (let* ((char (apply read-char arg)))
    (if (eof-object? char)
	char
	(do ((char char (apply read-char arg))
	     (clist '() (cons char clist)))
	    ((or (eof-object? char) (char=? #\newline char))
	     (list->string (reverse clist)))))))

(define (read-line! str . arg)
  (let* ((char (apply read-char arg))
	 (len (+ -1 (string-length str))))
    (if (eof-object? char)
	char
	(do ((char char (apply read-char arg))
	     (i 0 (+ 1 i)))
	    ((or (eof-object? char)
		 (char=? #\newline char)
		 (>= i len))
	     (cond ((or (eof-object? char) (char=? #\newline char))
		    i)
		   (else
		    (string-set! str i char)
		    (set! char (apply peek-char arg))
		    (if (or (eof-object? char) (char=? #\newline char))
			(+ 1 i) #f))))
	  (string-set! str i char)))))

(define (write-line str . arg)
  (apply display str arg)
  (apply newline arg))
