;;;; Implementation of COMMON LISP list functions for Scheme
;;; Copyright (C) 1991 Aubrey Jaffer.

;;; Some of these functions may be already defined in your Scheme.
;;; Comment out those definitions for functions which are already defined.

;;;; LIST FUNCTIONS FROM COMMON LISP

(define (make-list k obj)
  (if (<= k 0) '() (cons obj (make-list (- k 1) obj))))

(define (copy-list lst) (append lst '()))

(define (adjoin e l) (if (memq e l) l (cons e l)))

(define (union l1 l2)
  (cond ((null? l1) l2)
	((null? l2) l1)
	(else (union (cdr l1) (adjoin (car l1) l2)))))

(define (position obj lst)
  (letrec ((pos (lambda (n lst)
		  (cond ((null? lst) #f)
			((eqv? obj (car lst)) n)
			(else (pos (+ 1 n) (cdr lst)))))))
    (pos 0 lst)))

(define (reduce-init p init l)
  (if (null? l)
      init
      (reduce-init p (p init (car l)) (cdr l))))

(define (reduce p l)
  (cond ((null? l) l)
	((null? (cdr l)) (car l))
	(else (reduce-init p (car l) (cdr l)))))

(define (some pred l)
  (and (not (null? l))
       (or (pred (car l)) (some pred (cdr l)))))

(define (every pred l)
  (or (null? l)
      (and (pred (car l)) (every pred (cdr l)))))

(define (notevery pred l) (not (every pred l)))

(define (find-if t l)
  (cond ((null? l) #f)
	((t (car l)) (car l))
	(else (find-if t (cdr l)))))

(define (member-if t l)
  (cond ((null? l) #f)
	((t (car l)) l)
	(else (member-if t (cdr l)))))

(define (remove-if p l)
  (cond ((null? l) l)
	((p (car l)) (remove-if p (cdr l)))
	(else (cons (car l) (remove-if p (cdr l))))))

(define (remove-if-not p l)
  (cond ((null? l) l)
	((p (car l)) (cons (car l) (remove-if-not p (cdr l))))
	(else (remove-if-not p (cdr l)))))

(define nconc
  (lambda args
    (cond ((null? args) '())
	  ((null? (cdr args)) (car args))
	  ((null? (car args)) (cadr args))
	  (else
	   (set-cdr! (last-pair (car args))
		     (apply nconc (cdr args)))
	   (car args)))))

(define (butlast lst n)
  (letrec ((l (- (length lst) n))
	   (bl (lambda (lst n)
		 (cond ((null? lst) lst)
		       ((positive? n)
			(cons (car lst) (bl (cdr lst) (+ -1 n))))
		       (else '())))))
    (bl lst (if (negative? n)
		(slib:error "negative argument to butlast")
		l))))

;;;; CONDITIONALS

(define (and? . args)
  (cond ((null? args) #t)
	((car args) (apply and? (cdr args)))
	(else #f)))

(define (or? . args)
  (cond ((null? args) #f)
	((car args) #t)
	(else (apply or? (cdr args)))))

(define (identity x) x)

(require 'rev3-procedures)
