;;;; Implementation of VICINITY and MODULES for Scheme
;;; Copyright (C) 1991 Aubrey Jaffer.

;;;; WARNING: this code redefines LOAD.

(define (user-vicinity)
  (case (software-type)
    ((VMS)	"[.]")
    (else	"")))

(define program-vicinity
  (let ((*vicinity-suffix*
	 (case (software-type)
	   ((AMIGA)	'(#\: #\/))
	   ((UNIX)	'(#\/))
	   ((VMS)	'(#\: #\]))
	   ((MSDOS)	'(#\\))
	   ((MACOS THINKC)	'(#\:)))))
    (lambda ()
      (let loop ((i (- (string-length *load-pathname*) 1)))
	(cond ((negative? i) "")
	      ((memv (string-ref *load-pathname* i)
		     *vicinity-suffix*)
	       (substring *load-pathname* 0 (+ i 1)))
	      (else (loop (- i 1))))))))

(define sub-vicinity
  (case (software-type)
    ((VMS)
     (lambda
      (vic name)
      (let ((l (string-length vic)))
	(if (or (zero? (string-length vic))
		(not (char=? #\] (string-ref vic (- l 1)))))
	    (string-append vic "[" name "]")
	    (string-append (substring vic 0 (- l 1))
			   "." name "]")))))
    (else
     (let ((*vicinity-suffix*
	    (case (software-type)
	      ((UNIX AMIGA) "/")
	      ((MSDOS)	"\\"))))
       (lambda (vic name)
	 (string-append vic name *vicinity-suffix*))))))

(define in-vicinity string-append)

(define (make-vicinity <pathname>) <pathname>)

(define *catalog*
  (map
   (lambda (p) (cons (car p) (in-vicinity (library-vicinity) (cdr p))))
   '(
     (rev4-optional-procedures	.	"sc4opt.scm")
     (rev3-procedures		.	"sc3.scm")
     (rev2-procedures		.	"sc2.scm")
;     (multiarg/and-		.	"multarg.scm")
;     (multiarg-apply		.	"multaply.scm")
     (logical			.	"logical.scm")
     (random			.	"random.scm")
     (random-inexact		.	"randinex.scm")
     (modular			.	"modular.scm")
     (rationalize		.	"ratize.scm")
     (prime			.	"prime.scm")
     (charplot			.	"charplot.scm")
     (sort			.	"sort.scm")
     (common-list-functions	.	"comlist.scm")
     (format			.	"format.scm")
     (pretty-print		.	"pp.scm")
     (stdio			.	"stdio.scm")
     (debug			.	"debug.scm")
     (eval			.	"eval.scm")
     (record			.	"record.scm")
     (promise			.	"promise.scm")
     (synchk			.	"synchk.scm")
     (macro			.	"sc-macro.scm")
     )))

(define *load-pathname* #f)

(let ((*old-load* load))
  (set! load				;WARNING: redefining LOAD
	(lambda (<pathname>)
	  (let ((old-load-pathname *load-pathname*))
	    (set! *load-pathname* <pathname>)
	    (*old-load* <pathname>)
	    (require:provide <pathname>)
	    (set! *load-pathname* old-load-pathname)))))

;;;; MODULES

(define *modules* '())

(define (require:provided? feature)
  (if (symbol? feature)
      (or (memq feature *features*)
	  (let ((path (cdr (or (assq feature *catalog*) '(else . #f)))))
	    (and path (member path *modules*))))
      (member feature *modules*)))

(define (require:require feature)
  (if (symbol? feature)
      (or (memq feature *features*)
	  (let ((path (cdr (or (assq feature *catalog*) '(else . #f)))))
	    (cond ((not path)
		   (newline)
		   (display ";required feature not supported: ")
		   (display feature)
		   (newline)
		   (slib:error ";required feature not supported: " feature))
		  ((member path *modules*))
		  (else
		   (load path)
		   (require:provide feature)))))
      (or (member feature *modules*)
	  (begin (load feature)
		 (require:provide feature)))))

(define (require:provide feature)
  (if (symbol? feature)
      (if (not (memq feature *features*))
	  (set! *features* (cons feature *features*)))
      (if (not (member feature *modules*))
	  (set! *modules* (cons feature *modules*)))))

(require:provide 'vicinity)

(define provide require:provide)
(define provided? require:provided?)
(define require require:require)

(if (inexact? (string->number "0.0")) (provide 'inexact))
(if (rational? (string->number "1/19")) (provide 'rational))
(if (real? (string->number "0.0")) (provide 'real))
(if (complex? (string->number "1+i")) (provide 'complex))
(if (exact? (string->number "9999999999999999999999999999999"))
    (provide 'bignum))
