/* Scheme implementation intended for JACAL.
   Copyright (C) 1990, 1991, 1992 Aubrey Jaffer.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

The author can be reached at jaffer@ai.mit.edu or
Aubrey Jaffer, 84 Pleasant St., Wakefield MA 01880
*/

#include <stdio.h>
#include <signal.h>
#include "scm.h"

#ifdef vms
# ifndef CHEAP_CONTINUATIONS
#  include "setjump.h"
# else
#  include <setjmp.h>
# endif
#else
# include <setjmp.h>
#endif

/* On VMS, GNU C's errno.h contains a special hack to get link attributes
   for errno correct for linking to the C RTL. */
#ifdef vms
# include <errno.h>
#else /* vms */
# ifndef MSDOS
extern int errno;
# endif
#endif /* vms */

#if (__TURBOC__==1)
/* Needed for TURBOC V1.0 */
extern int errno;
#define LACK_FTIME
#define LACK_TIMES
#undef MSDOS
#endif

#ifdef STDC_HEADERS
# include <time.h>
# ifdef sun
#  include <sys/types.h>
#  include <sys/times.h>
# endif
#else
# ifdef SVR2
#  include <time.h>
# else
#  include <sys/time.h>
# endif
# include <sys/types.h>
# include <sys/times.h>
#endif

/* Define this if your system lacks ftime(). */
/* #define LACK_FTIME */
/* Define this if your system lacks times(). */
/* #define LACK_TIMES */
#ifdef THINK_C
# define LACK_FTIME
# define LACK_TIMES
# define CLK_TCK 60
#endif
#ifdef SVR2
# define LACK_FTIME
#endif
#ifdef GNUDOS
# define LACK_FTIME
# define LACK_TIMES
#endif

#ifdef MSDOS
# include <sys\types.h>
# include <sys\timeb.h>
#endif
#ifndef LACK_FTIME
# ifdef unix
#  include <sys/timeb.h>
# endif
#endif

#ifdef CLK_TCK
# define CLKTCK CLK_TCK
# ifdef CLOCKS_PER_SEC
#  ifdef unix
#   include <sys/times.h>
#   define LACK_CLOCK
    /* This is because clock() might be POSIX rather than ANSI.
       This occurs on HP-UX machines */
#  endif
# endif
#else
# define LACK_CLOCK
# ifdef AMIGA
#  include <stddef.h>
#  define LACK_TIMES
#  define LACK_FTIME
#  define CLKTCK 1000
# else
#  define CLKTCK 60
# endif
#endif

#ifdef __STDC__
#define timet time_t
#else
#define timet long
#endif

#ifdef LACK_CLOCK
# ifdef LACK_TIMES
#  ifdef AMIGA
/* From: "Fred Bayer" <bayerf@lan.informatik.tu-muenchen.de> */
#   ifdef AZTEC_C		/* AZTEC_C */
#    include <devices/timer.h>
long mytime()
{
        long sec,mic,mili=0;
        struct timerequest *timermsg;
        struct MsgPort *timerport;
        if(!(timerport = (struct MsgPort *)CreatePort(0,0))){
        fputs("No mem for port.\n",stderr);
                return mili;
        }
        if(!(timermsg = (struct timerequest *)
                 CreateExtIO(timerport,sizeof(struct timerequest)))){
                fputs("No mem for timerequest.\n",stderr);
                DeletePort(timermsg->tr_node.io_Message.mn_ReplyPort);
        return mili;
        }
        if(!(OpenDevice(TIMERNAME,UNIT_MICROHZ,timermsg,0))){
                timermsg->tr_node.io_Command = TR_GETSYSTIME;
                timermsg->tr_node.io_Flags = 0;
                DoIO(timermsg);
                sec = timermsg->tr_time.tv_secs;
                mic = timermsg->tr_time.tv_micro;
                mili = sec*1000+mic/1000;
                CloseDevice(timermsg);
        }
        else fputs("No Timer available.\n",stderr);
        DeletePort(timermsg->tr_node.io_Message.mn_ReplyPort);
        DeleteExtIO(timermsg);
        return mili ;
}
#   else			/* this is for SAS/C */
long mytime()
{
   unsigned int cl[2];
   timer(cl);
   return(cl[0]*1000+cl[1]/1000);
}
#   endif /* AZTEC_C */
#  else /* AMIGA */
#   define mytime() ((time(0L) - your_base) * CLKTCK)
#  endif /* AMIGA */
# else /* LACK_TIMES */
long mytime()
{
  struct tms time_buffer;
  times(&time_buffer);
  return time_buffer.tms_utime + time_buffer.tms_stime;
}
# endif /* LACK_TIMES */
#else /* LACK_CLOCK */
# define mytime clock
#endif /* LACK_CLOCK */

#ifdef LACK_FTIME
# ifdef AMIGA
SCM your_time()
{
  return MAKINUM(mytime());
}
# else
timet your_base;
SCM your_time()
{
	return MAKINUM((time(0L) - your_base) * (int)CLKTCK);
}
# endif /* AMIGA */
#else /* LACK_FTIME */
struct timeb your_base;
SCM your_time()
{
	struct timeb time_buffer;
	long tmp;
	ftime(&time_buffer);
	time_buffer.time -= your_base.time;
	tmp = time_buffer.millitm - your_base.millitm;
	tmp = time_buffer.time*1000L + tmp;
	tmp *= CLKTCK;
	tmp /= 1000;
	return MAKINUM(tmp);
}
#endif /* LACK_FTIME */

long my_base=0;
SCM my_time()
{
  return MAKINUM(mytime()-my_base);
}
SCM s_itups = BOOL_F;

void init_time()
{
	s_itups=sysintern("internal-time-units-per-second");
	VCELL(s_itups)=MAKINUM((long)CLKTCK);
#ifdef LACK_FTIME
# ifndef AMIGA
	time(&your_base);
# endif
#else
	ftime(&your_base);
#endif
	my_base = mytime();
}

#ifndef STDC_HEADERS
struct tm *localtime();
#endif
SCM dcdtime()
{
  int i=sizeof(struct tm)/sizeof(int);
  SCM ans=make_vector(MAKINUM((long)i),UNDEFINED);
  timet timv=time(0L);
  struct tm *tmptr=localtime(&timv);
  while(i--) VELTS(ans)[i]=MAKINUM((long)(((int *)tmptr)[i]));
  return ans;
}

long time_in_msec(x)
     long x;
{
  if (CLKTCK==60) return (x*50)/3;
  else return x*(long)(1000/CLKTCK);
}

SCM sym_features=EOL;
static char s_tryload[]="try-load";
#define s_load (&s_tryload[4])

char *features[] = {
#ifdef IO_EXTENSIONS
# ifdef HAVE_PIPE
  "pipe",
# endif
  "i/o-extensions",
#endif
#ifdef STR_EXTENSIONS
  "substring-move",
#endif
#ifndef CHEAP_CONTINUATIONS
  "full-continuation",
#endif
#ifdef RECKLESS
  "reckless",
#endif
#ifdef vms
  "ed",
#endif
  0};

void init_features()
{
  char **feats = features;
  sym_features = sysintern("*features*");
  VCELL(sym_features) = EOL;
  for(;*feats;feats++) {
      VCELL(sym_features) =
      cons(sysintern(*feats),
	   VCELL(sym_features));
  }    
}

struct errdesc {char *msg;char *s_response;short parent_err;};
struct errdesc errmsgs[] = {
  {"Wrong number of args to",0,0},
  {"numerical overflow",0,FPE_SIGNAL},
  {"Argument out of range",0,FPE_SIGNAL},
  {"Could not allocate","out-of-storage",0},
  {"Could not open file","could-not-open",0},
  {"EXIT","end-of-program",-1},
  {"hang up","hang-up",EXIT},
  {"user interrupt","user-interrupt",0},
  {"arithmetic error","arithmetic-error",0},
  {"bus error",0,0},
  {"segment violation",0,0},
  {"alarm",0,0}
};

jmp_buf errjmp;
int errjmp_ok = 0, sig_disabled = 1,  sig_deferred = 0;
SCM err_exp,err_env;
char *err_pos, *err_s_subr;
SCM sym_errobj = BOOL_F;
SCM sym_loadpath = BOOL_F;
long linum = 1;
int verbose = 0;
long cells_allocated = 0, gc_rt, gc_time_taken;
long gc_cells_collected, gc_malloc_collected, gc_ports_collected;
void def_err_response();

SCM repl_driver(argc,argv)
int argc;
char **argv;
{
  long i;
  stack_start_ptr = &i;
  i=setjmp(errjmp);
 drloop:
  switch ((int)i) {
  default:
    {
      char *name = errmsgs[i-WNA].s_response;
      if (name) {
	SCM proc = VCELL(intern(name,strlen(name)));
	if NIMP(proc) apply(proc,EOL,EOL);
      }
      if (i=errmsgs[i-WNA].parent_err) goto drloop;
      def_err_response();
      goto reset_toplvl;
    }
  case 0:
    errjmp_ok = 1;
    errno = 0;
    sig_deferred = 0;
    sig_disabled = 0;
    progargs = EOL;
    while (argc--)
      progargs = cons(makfromstr(argv[argc], strlen(argv[argc])), progargs);
    {
      SCM name = lgetenv(makfromstr("SCM_INIT_PATH",
				    (sizet) (sizeof "SCM_INIT_PATH"-1)));
      if FALSEP(name)
#ifdef IMPLINIT
	name = makfromstr(IMPLINIT, (sizet) (sizeof IMPLINIT-1));
#else
      goto noname;
#endif
      if (BOOL_T != tryload(name))
      noname:
	wta(name,(char *)FILNOTFND,s_load);
    }
  case -2:
  reset_toplvl:
    errjmp_ok = 1;
    sig_deferred = 0;
    sig_disabled = 0;
    VCELL(sym_loadpath) = BOOL_F;
    repl();
    err_pos = (char *)EXIT;
    i= EXIT;
    goto drloop;		/* encountered EOF on stdin */
  case -1:
    return throwval;
  }
}

SCM line_num()
{
  return MAKINUM(linum);
}
SCM prog_args()
{
	return progargs;
}

void growth_mon(obj, size, units)
char *obj;
long size;
char *units;
{
	if (verbose>1)
	{
		DEFER_SIGINT;
		fputs("; grew ",stdout);
		fputs(obj,stdout);
		fputs(" to ",stdout);
		iprint(size,10,stdout);
		putc(' ',stdout);
		puts(units);
		ALLOW_SIGINT;
	}
}

void gc_start()
{
	gc_rt = mytime();
	gc_cells_collected = 0;
	gc_malloc_collected = 0;
	gc_ports_collected = 0;
	if (verbose>2) fputs(";GC ",stdout);
	fflush(stdout);
}
void gc_end()
{
	gc_rt = mytime() - gc_rt;
	gc_time_taken = gc_time_taken + gc_rt;
	if (verbose>2) {
		iprint(time_in_msec(gc_rt),10,stdout);
		fputs(" cpu mSec, ",stdout);
		iprint(gc_cells_collected,10,stdout);
		fputs(" cells, ",stdout);
		iprint(gc_malloc_collected,10,stdout);
		fputs(" malloc, ",stdout);
		iprint(gc_ports_collected,10,stdout);
		puts(" ports collected");
		fflush(stdout);
	}
}

SCM prolixity(arg)
SCM arg;
{
  int old = verbose;
  if (!UNBNDP(arg)) {
    if FALSEP(arg) verbose = 0;
    else verbose = INUM(arg);
  }
  return MAKINUM(old);
}

void repl()
{
  SCM x;
  long rt;
  DEFER_SIGINT;
  while(1) {
    fputs("> ",stdout);
    fflush(stdout);
    ALLOW_SIGINT;
    x = lread(cur_inp);
    if (x == EOF_VAL) break;
    rt = mytime();
    cells_allocated = 0;
    gc_time_taken = 0;
    x = EVAL(x,EOL);
    DEFER_SIGINT;
    if (verbose) {
      fputs(";Evaluation took ",stdout);
      iprint(time_in_msec(mytime()-rt),10,stdout);
      fputs(" mSec (",stdout);
      iprint(time_in_msec(gc_time_taken),10,stdout);
      fputs(" in gc) ",stdout);
      iprint(cells_allocated,10,stdout);
      puts(" cons work");
    }
    iprin1(x,stdout,1);
    putc('\n',stdout);
  }
}
SCM quit(n)
SCM n;
{
  if UNBNDP(n) n=INUM0;
  throwval = n;
  longjmp(errjmp,-1);
}
void err_ctrl_c()
{
  sig_deferred=0;
  wta(UNDEFINED,(char *)INT_SIGNAL,"");
}
SCM abrt()
{
  longjmp(errjmp,-2);
}

SCM tryload(filename)
SCM filename;
{
  ASSERT(NIMP(filename) && STRINGP(filename),filename,ARG1,s_load);
  {
    SCM oloadpath = VCELL(sym_loadpath);
    long olninum = linum;
    SCM form,port;
    FILE *f;
    errno = 0;
    f = fopen(CHARS(filename),"r");
    if (!f) return BOOL_F;
    port = makport(f,tc_inport);
    VCELL(sym_loadpath) = filename;
    linum = 1;
    while(1) {
      form = lread(port);
      if (EOF_VAL == form) break;
      SIDEVAL(form,EOL);
    }
    close_port(port);
    linum = olninum;
    VCELL(sym_loadpath) = oloadpath;
  }
  return BOOL_T;
}

void err_head(str)
char *str;
{
	fflush(stdout);
	putc('\n',stderr);
	if(BOOL_F != VCELL(sym_loadpath)) {
		iprin1(VCELL(sym_loadpath),stderr,1);
		fputs(", line ",stderr);
		iprint((long)linum,10,stderr);
		fputs(": ",stderr);
	}
	fflush(stderr);
	if (errno>0) perror(str);
}
void warn(str1,str2)
char *str1,*str2;
{
	DEFER_SIGINT;
	err_head("WARNING");
	fputs("WARNING: ",stderr);
	fputs(str1,stderr);
	fputs(str2,stderr);
	putc('\n',stderr);
	fflush(stderr);
	ALLOW_SIGINT;
}

SCM seterrno(arg)
SCM arg;
{
  errno = INUM(arg);
  return UNSPECIFIED;
}
static char s_perror[]="perror";
SCM lperror(arg)
SCM arg;
{
  ASSERT(NIMP(arg) && STRINGP(arg),arg,ARG1,s_perror);
  err_head(CHARS(arg));
  return UNSPECIFIED;
}
extern cell dummy_cell;
void def_err_response()
{
  SCM obj = VCELL(sym_errobj);
  DEFER_SIGINT;
  err_head("ERROR");
  fputs("ERROR: ",stderr);
  if (err_s_subr && *err_s_subr) {
    fputs(err_s_subr,stderr);
    fputs(": ",stderr);
  }
  if ((~0x1fL) & (long)err_pos) fputs(err_pos,stderr);
  else if (WNA>(long)err_pos) {
    fputs("Wrong type in arg",stderr); putc('0'+(int)err_pos,stderr);
  }
  else {
    fputs(errmsgs[((int)err_pos)-WNA].msg,stderr);
    goto outobj;
  }
  if (IMP(obj) || SYMBOLP(obj)) {
outobj:
    if (!UNBNDP(obj)) {
      putc(' ',stderr);
      iprin1(obj,stderr,1);
    }
  }
  else fputs(" (see errobj)",stderr);
  if UNBNDP(err_exp) goto getout;
  if NIMP(err_exp) {
    fputs("\n; in expression: ",stderr);
    if (err_exp == (SCM)&dummy_cell) iprin1(CAR(err_exp),stderr,1);
    else if ECONSP(err_exp)
      iprlist("(... ",err_exp,')',stderr,1);
    else iprin1(err_exp,stderr,1);
  }
  if NULLP(err_env) fputs("\n; in top level environment.",stderr);
  else {
    SCM env=err_env;
    fputs("\n; in scope:",stderr);
    while NNULLP(env) {
      putc('\n',stderr);
      fputs(";   ",stderr);
      iprin1(CAR(CAR(env)),stderr,1);
      env = CDR(env);
    }
  }
 getout:
  putc('\n',stderr);
  fflush(stderr);
  err_exp = err_env = UNDEFINED;
  if (!errjmp_ok) {
    iprin1(obj,stderr,1);
    fputs("\nFATAL ERROR DURING CRITICAL CODE SECTION\n",stderr);
    quit(MAKINUM(errno?(long)errno:1L));
  }
  errno=0;
}
void everr(exp,env,arg,pos,s_subr)
SCM exp,env,arg;
char *pos, *s_subr;
{
  err_exp=exp;
  err_env=env;
  VCELL(sym_errobj)=arg;
  err_pos=pos;
  err_s_subr=s_subr;
  if (((~0x1fL) & (long)pos) || (WNA>(long)pos)) {
    def_err_response();
    abrt();
  }
  longjmp(errjmp,(int)pos);
}
void wta(arg,pos,s_subr)
SCM arg;
char *pos, *s_subr;
{
 everr(UNDEFINED,EOL,arg,pos,s_subr);
}

static iproc subr0s[]={
	{"program-arguments",prog_args},
	{"line-number",line_num},
	{"get-internal-run-time",my_time},
	{"get-internal-real-time",your_time},
	{"abort",abrt},
	{"get-decoded-time",dcdtime},
	{0,0}};

static iproc subr1s[]={
	{"set-errno!",seterrno},
	{s_perror,lperror},
	{s_load,tryload},
	{s_tryload,tryload},
	{0,0}};

static iproc subr1os[]={
	{"quit",quit},
	{"verbose",prolixity},
	{0,0}};

void init_repl()
{
	sym_errobj=sysintern("errobj");
	VCELL(sym_errobj)=UNDEFINED;
	sym_loadpath=sysintern("*load-pathname*");
	VCELL(sym_loadpath)=BOOL_F;
	init_iprocs(subr0s, tc7_subr_0);
	init_iprocs(subr1os, tc7_subr_1o);
	init_iprocs(subr1s, tc7_subr_1);
}
