/* Scheme implementation intended for JACAL.
   Copyright (C) 1990, 1991 Aubrey Jaffer.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

The author can be reached at jaffer@ai.mit.edu or
Aubrey Jaffer, 84 Pleasant St., Wakefield MA 01880
*/

#include <stdio.h>
#include <signal.h>
#include "scm.h"
#include "patchlvl.h"

void init_banner()
{
  fputs("SCM version ",stdout);
  fputs(SCMVERSION,stdout);
  iprint((long)PATCHLEVEL,10,stdout);
  puts(", Copyright (C) 1990, 1991 Aubrey Jaffer.\n\
SCM comes with ABSOLUTELY NO WARRANTY; for details type `(terms)'.\n\
This is free software, and you are welcome to redistribute it\n\
under certain conditions; type `(terms)' for details.");
}

/* SIGRETTYPE is the type that signal handlers return.  See <signal.h>*/

#ifdef __STDC__
#define SIGRETTYPE void
#else
#define SIGRETTYPE int
#endif

#ifdef unix
SIGRETTYPE bus_signal(sig)
int sig;
{
	signal(SIGBUS,bus_signal);
	wta(UNDEFINED,"bus error","");
}
#endif
SIGRETTYPE segv_signal(sig)
int sig;
{
	signal(SIGSEGV,segv_signal);
	wta(UNDEFINED,"segment violation","");
}
#ifdef FLOATS
SIGRETTYPE fpe_signal(sig)
int sig;
{
	signal(SIGFPE,fpe_signal);
	wta(UNDEFINED,"numerical exception","");
}
#endif
SIGRETTYPE int_signal(sig)
int sig;
{
	signal(SIGINT,int_signal);
	if (sig_disabled) sig_deferred = 1;
	else err_ctrl_c();
}
extern SCM throwval;

int main(argc,argv)
int argc;
char **argv;
{
  SIGRETTYPE (*oldint)();
#ifdef unix
  SIGRETTYPE (*oldbus)();
#endif
  SIGRETTYPE (*oldsegv)();
#ifdef FLOATS
  SIGRETTYPE (*oldfpe)();
#endif
  SCM i;
  stack_start_ptr = &i;		/* stack_start_ptr gets set */
  if (argc <= 1) init_banner();
  init_tables();
  init_storage();
  init_subrs();
  init_io();
  init_scl();
  init_scm();
  init_features();
  init_time();
  init_repl();
  progargs = EOL;
  while (argc--)
    progargs = cons(makfromstr(argv[argc], strlen(argv[argc])),
		    progargs);
  oldint = signal(SIGINT,int_signal);
#ifdef unix
  oldbus = signal(SIGBUS,bus_signal);
#endif
  oldsegv = signal(SIGSEGV,segv_signal);
#ifdef FLOATS
  oldfpe = signal(SIGFPE,fpe_signal);
#endif
  i = repl_driver();
  signal(SIGINT,oldint);
#ifdef unix
  signal(SIGBUS,oldbus);
#endif
  signal(SIGSEGV,oldsegv);
#ifdef FLOATS
  signal(SIGFPE,oldfpe);
#endif
  if (argc <= 1) puts(";EXIT");
  return (int)INUM(i);
}

SCM prog_args()
{
	return progargs;
}
static iproc subr0s[]={
	{"program-arguments",prog_args},
	{0,0}};

void init_scm()
{
	init_iprocs(subr0s, tc7_subr_0);
}
