/* Scheme implementation intended for JACAL.
   Copyright (C) 1989, 1990 Aubrey Jaffer.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

The author can be reached at jaffer@ai.mit.edu or
Aubrey Jaffer, 84 Pleasant St., Wakefield MA 01880
*/

typedef long SCM;
typedef struct {SCM car,cdr;} cell;
typedef struct {long sname;SCM (*cproc)();} subr;
typedef struct {char *string;SCM (*cproc)();} iproc;
typedef struct {iproc *iprocra;int typc;} iproclist;

#include "config.h"

#define IMP(x) ((x)&6)
#define NIMP(x) (!IMP(x))

#define INUMP(x) ((x)&2)
#define NINUMP(x) (!INUMP(x))
#define MAKINUM(x) (((x)<<2)+2L)
#define INUM0 ((SCM) 2)
#if ((((-1)<<2)+2)>>2 == -1)
#define SIGNED_RIGHT_SHIFT
#define INUM(x) ((x)>>2)
#else
#define INUM(x) (((x)<0) ? ~((~(x))>>2) : (x)>>2)
#endif

#define ICHRP(x) (((x)&0xff)==252)
#define ICHR(x) ((unsigned char)((x)>>8))
#define MAKICHR(x) (((x)<<8)+0xfcL)

#define ILOCP(n) (((n)&0xffff)==0x807c)
#define ILOC00	(0x0000807cL)
#define IDINC	(0x00010000L)
#define ICDR	(0x00800000L)
#define IFRINC	(0x01000000L)
#define IDSTMSK	(IFRINC-IDINC)
#define IFRAME(n) ((n)>>24)
#define IDIST(n) (((n)>>16)&127)
#define ICDRP(n) ((n)&ICDR)

#define ISYMP(n) (((n)&0xe087)==4)
#define IFLAGP(n) (((n)&0xc087)==4)
#define ISYMNUM(n) (((n)>>8)&0x1f)
#define ISYMCHARS(n) (isymnames[ISYMNUM(n)])
#define MAKSPCSYM(n) (((n)<<8)+((n)<<3)+4L)
#define MAKISYM(n) (((n)<<8)+0x7cL)
#define MAKIFLAG(n) (((n)<<8)+0x207cL)

extern char *isymnames[];
#define I_AND MAKSPCSYM(0)
#define I_BEGIN MAKSPCSYM(1)
#define I_CASE MAKSPCSYM(2)
#define I_COND MAKSPCSYM(3)
#define I_DEFINE MAKSPCSYM(4)
#define I_DO MAKSPCSYM(5)
#define I_IF MAKSPCSYM(6)
#define I_LAMBDA MAKSPCSYM(7)
#define I_LET MAKSPCSYM(8)
#define I_LETSTAR MAKSPCSYM(9)
#define I_LETREC MAKSPCSYM(10)
#define I_OR MAKSPCSYM(11)
#define I_QUASIQUOTE MAKSPCSYM(12)
#define I_QUOTE MAKSPCSYM(13)
#define I_SET MAKSPCSYM(14)

#define I_ARROW MAKISYM(15)
#define I_ELSE MAKISYM(16)
#define I_UNQUOTE MAKISYM(17)
#define I_UQ_SPLICING MAKISYM(18)
#define I_DOT MAKISYM(19)
#define NUM_ISYMS 20

#define BOOL_F MAKIFLAG(NUM_ISYMS+0)
#define BOOL_T MAKIFLAG(NUM_ISYMS+1)
#define UNDEFINED MAKIFLAG(NUM_ISYMS+2)
#define EOF_VAL MAKIFLAG(NUM_ISYMS+3)
#define EOL MAKIFLAG(NUM_ISYMS+4)
#define UNSPECIFIED MAKIFLAG(NUM_ISYMS+5)

#define FALSEP(x) ((x) == BOOL_F)
#define NFALSEP(x) ((x) != BOOL_F)
#define NULLP(x) ((x) == EOL)
#define NNULLP(x) ((x) != EOL)
#define UNBNDP(x) ((x) == UNDEFINED)
#define CELLP(x) (!NCELLP(x))
#define NCELLP(x) ((x) &7)

#define GCMARKP(x) (CDR(x) &1)
#define SETGCMARK(x) CDR(x) |= 1;
#define CLRGCMARK(x) CDR(x) &= ~1;
#define TYP3(x) (CAR(x) &7)
#define TYP7(x) (CAR(x) &0x7f)
#define TYP16(x) (CAR(x) &0xffff)

#define NCONSP(x) (CAR(x) &1)
#define CONSP(x) (!NCONSP(x))
#define ECONSP(x) (CONSP(x) || (TYP3(x) == 1))
#define NECONSP(x) (NCONSP(x) && (TYP3(x) != 1))
#define CAR(x) (((cell *)(x))->car)
#define CDR(x) (((cell *)(x))->cdr)
#define GCCDR(x) (CDR(x) &~1)
#define SETCDR(x,v) CDR(x)=(SCM)(v)

#define CLOSUREP(x) (TYP3(x) == tc3_closure)
#define CODE(x) (CAR(x)-tc3_closure)
#define SETCODE(x,e) CAR(x)=(e)+tc3_closure
#define ENV(x) CDR(x)

#define SYMBOLP(x) (TYP3(x) == tc3_symbol)
#define NAMESTR(x) (CAR(x)-tc3_symbol)
#define SETNAMESTR(x,v) CAR(x)=(v)+tc3_symbol
#define VCELL(x) CDR(x)

#define PORTP(x) (TYP16(x) == tc16_port)
#define INPORTP(x) ((CAR(x) & ~WRTNG) == tc_inport)
#define OUTPORTP(x) ((CAR(x) & ~RDNG) == tc_outport)
#define STREAM(x) ((FILE *)(CDR(x)))
#define SETSTREAM(x,v) SETCDR(x,v)
#define OPENP(x) (CDR(x))
#define CLOSEDP(x) (!OPENP(x))

#define SUBRP(x) ((TYP3(x)==7) && (CAR(x)&96) && (TYP7(x)!=tc7_smob))
#define SNAME(x) (heap_org+(CAR(x)>>7))
#define SETSNAME(x,v,t) CAR(x)=((((cell *)(v))-heap_org)<<7)+(t)
#define SUBRF(x) (((subr *)(x))->cproc)

#define NTSTRP(x) ((CAR(x) == tc_ntstr)

#define MALLOCP(x) ((CAR(x) &0x607) == 7)
#define STRINGP(x) (TYP7(x) == tc7_string)
#define NSTRINGP(x) (!STRINGP(x))
#define VECTORP(x) (TYP7(x) == tc7_vector)
#define NVECTORP(x) (!VECTORP(x))
#define LENGTH(x) (CAR(x)>>7)
#define SETLENGTH(x,v,t) CAR(x) = ((v)<<7)+t
#define CHARS(x) ((char *)(CDR(x)))
#define VELTS(x) ((SCM *)(CDR(x)))
#define GCVELTS(x) ((SCM *)(CDR(x) &~1))
#define SETCHARS(x,v) SETCDR(x,v)
#define SETVELTS(x,v) SETCDR(x,v)

#define JMPBUF(x) (jmp_buf *)CHARS(x)
#define SETJMPBUF(x,v) SETCDR(x,v)

#define FREEP(x) (CAR(x) == tc_free_cell)
#define NFREEP(x) (!FREEP(x))

#define tcs_cons_imcar 2:case 4:case 6:case 10:\
		 case 12:case 14:case 18:case 20:\
		 case 22:case 26:case 28:case 30:\
		 case 34:case 36:case 38:case 42:\
		 case 44:case 46:case 50:case 52:\
		 case 54:case 58:case 60:case 62:\
		 case 66:case 68:case 70:case 74:\
		 case 76:case 78:case 82:case 84:\
		 case 86:case 90:case 92:case 94:\
		 case 98:case 100:case 102:case 106:\
		 case 108:case 110:case 114:case 116:\
		 case 118:case 122:case 124:case 126
#define tcs_cons_nimcar 0:case 8:case 16:case 24:\
		 case 32:case 40:case 48:case 56:\
		 case 64:case 72:case 80:case 88:\
		 case 96:case 104:case 112:case 120
#define tcs_cons_gloc 1:case 9:case 17:case 25:\
		 case 33:case 41:case 49:case 57:\
		 case 65:case 73:case 81:case 89:\
		 case 97:case 105:case 113:case 121

#define tcs_closures   3:case 11:case 19:case 27:\
		 case 35:case 43:case 51:case 59:\
		 case 67:case 75:case 83:case 91:\
		 case 99:case 107:case 115:case 123
#define tcs_symbols    5:case 13:case 21:case 29:\
		 case 37:case 45:case 53:case 61:\
		 case 69:case 77:case 85:case 93:\
		 case 101:case 109:case 117:case 125
#define tcs_subrs tc7_subr_0:case tc7_subr_1:case tc7_cxr:case tc7_subr_3:\
	case tc7_subr_2:case tc7_subr_2x:case tc7_subr_1o:\
	case tc7_subr_2o:case tc7_lsubr:case tc7_lsubr_2:case tc7_asubr

#define tc3_cons	0
#define tc3_cons_gloc	1
#define tc3_closure	3
#define tc3_symbol	5

#define tc7_vector	7
#define tc7_bignum	15
#define tc7_string	23
#define tc7_contin	31
#define tc7_subr_0	39
#define tc7_subr_1	47
#define tc7_cxr		55
#define tc7_subr_3	63
#define tc7_subr_2	71
#define tc7_subr_2x	79
#define tc7_subr_1o	87
#define tc7_subr_2o	95
#define tc7_lsubr	103
#define tc7_lsubr_2	111
#define tc7_asubr	119

#define tc7_smob	127
#define tc_free_cell	127
#define tc_ntstr	255
#define tc16_port       0x017f
#define RDNG		(1L<<16)
#define WRTNG		(2L<<16)
#define tc_inport	(tc16_port|RDNG)
#define tc_outport	(tc16_port|WRTNG)
#define tc_ioport	(tc16_port|RDNG|WRTNG)

extern SCM sys_protects[];
#define cur_inp sys_protects[0]
#define cur_outp sys_protects[1]
#define listofnull sys_protects[2]
#define undefineds sys_protects[3]
#define nullvect sys_protects[4]
#define nullstr sys_protects[5]
#define symhash sys_protects[6]
#define NUM_PROTECTS 7

/* now for connects between source files */

extern unsigned char upcase[],downcase[];
extern int symhash_dim;
extern unsigned long heap_size;
extern cell *heap_org;
extern SCM *stack_start_ptr, freelist;
extern long gc_cells_collected,	gc_malloc_collected, gc_ports_collected;
extern long cells_allocated;
extern long line_num;
extern int errjmp_ok, sig_disabled, sig_deferred;
char *must_malloc();
long ilength();

#define long_cpp_name15
#ifndef long_cpp_name16
#define char_ci_eq chci_eq
#define char_ci_lessp chci_lessp
#define string_ci_equal stci_equal
#define string_ci_lessp stci_lessp
#define string_length st_length
#define string_lessp st_lessp
#define string_ref st_ref
#define string_set st_set
#define string_equal st_equal
#define string_append st_append
#define call_with_current_continuation call_cc
#define call_with_input_file cw_input_file
#define call_with_output_file cw_output_file
#define current_input_port cur_input_port
#define current_output_port cur_output_port
#endif

extern char s_read[], s_write[], s_newline[];
extern char s_list[], s_vector[], s_string[];

SCM intern(), makstr(), makfromstr(), makport(), closure();
SCM ceval(), gc_status(), gc(), gc_for_newcell();
SCM char_readyp(), iiopen();
SCM cons2(),cons2r();

SCM lnot(), booleanp(), eq(), equal();
SCM consp(), cons(), nullp();
SCM setcar(), setcdr();
SCM listp(), list(), length(), append(), reverse(), list_ref();
SCM memq(), member(), assq(), assoc();
SCM symbolp(), symbol2string(), string2symbol();
SCM numberp(), exactp(), inexactp(), numident();
SCM eqp(), lessp(), greaterp(), lesseqp(), greatereqp();
SCM zerop(), positivep(), negativep(), oddp(), evenp();
SCM lmax(), lmin(), sum(), product(), difference(), quotient(), absval();
SCM remainder(), modulo(), lgcd(), llcm(), number2string(), string2number();

SCM charp(), char_lessp(), chci_eq(), chci_lessp();
SCM char_alphap(), char_nump(), char_whitep(), char_upperp(), char_lowerp();
SCM char2int(), int2char(), char_upcase(), char_downcase();
SCM stringp(), make_string(), string();
SCM st_length(), st_ref(), st_set();
SCM st_equal(), stci_equal();
SCM st_lessp(), stci_lessp(), substring(), st_append();

SCM vectorp(), make_vector(), vector(), vector_length();
SCM vector_ref(), vector_set();
SCM for_each(), procedurep(), apply(), map(), call_cc();

SCM cw_input_file(), cw_output_file();
SCM input_portp(), output_portp(), cur_input_port(), cur_output_port();
SCM open_input_file(), open_output_file();
SCM lread(), read_char(), peek_char(), eof_objectp();
SCM close_port(), lwrite(), display(), newline(), write_char();
SCM cw_io_file(), open_io_file(), file_set_pos(), file_get_pos();
SCM read_into_string();

#define DIGITS '0':case '1':case '2':case '3':case '4':\
		case '5':case '6':case '7':case '8':case '9'

#ifdef RECKLESS
#define ASSERT(_cond,_arg,_pos,_subr) ;
#define ASRTGO(_cond,_label) ;
#else
#define ASSERT(_cond,_arg,_pos,_subr) if(!(_cond))wta(_arg,_pos,_subr);
#define ASRTGO(_cond,_label) if(!(_cond)) goto _label;
#endif

extern char OUTOFRANGE[], OVERFLOW[];

#define ARG1 1L
#define ARG2 2L
#define ARG3 3L
#define WNA -1L
#define NALLOC -4L
#define NOFILE -5L

#define EVAL(x,env) (IMP(x)?(x):ceval((x),(env)))
#define SIDEVAL(x,env) if NIMP(x) ceval((x),(env))

#define CHECK_SIGINT {if (sig_deferred) err_ctrl_c();}
#define DEFER_SIGINT {sig_disabled = 1;}
#define ALLOW_SIGINT {sig_disabled = 0;CHECK_SIGINT}
