/* Scheme implementation intended for JACAL.
   Copyright (C) 1989, 1990 Aubrey Jaffer.
   See the file `scm.c' for terms applying to this program */

#ifndef SCMVERSION
#define SCMVERSION "2b"
#endif

/* If your scheme code runs under this program without any errors you
can disable almost all error checking by compiling all files with this
line or better yet by changing the makefile. */

/* #define RECKLESS */

/* WARRANTY is the pathname (surrounded by double quotes) of the file
which contains the text of the GNU GENERAL PUBLIC LICENSE.  This is
automatically generated in the makefile if possible */

#ifndef WARRANTY
#define WARRANTY "~jaffer/scm/public.lic"
#endif

/* This will speed up most local variable references.  You will need
to remove this and recompile eval.c if you use very large or deep
environments (more than 255 bound variables in one procedure) */

#define MEMOIZE_LOCALS

/* If a filename in the command line or given as an argument to the
Scheme function `load' is not found scm tries to find the name with
FILE_EXTENSION appended.  #define FILE_EXTENSTION "" to disable */

#define FILE_EXTENSION ".scm"

/* char_code_limit is the number of distinct characters represented by
the char datatype. */

#define char_code_limit 256

/* the rest of this applies only to sys.c */

#ifdef IN_SYS

/* LINE_INCREMENTORS are the characters which cause the line count to
be incremented for the purposes of error reporting.  This feature is
only used for scheme code loaded from files.

WHITE_SPACES are other characters which should be treated like spaces
in programs.  in both cases sparate characters with ":case " */

#define LINE_INCREMENTORS  '\n'
#define WHITE_SPACES  ' ':case '\t':case '\r':case '\f'

/* If you only need straight stack continuations CHEAP_CONTINUATIONS
will run faster and use less storage than not having it.  Machines
with unusual stacks (such as vax and SUN-4) need this. */

/* #define CHEAP_CONTINUATIONS */
#ifdef vms
#define CHEAP_CONTINUATIONS
#endif
#ifdef sparc
#define CHEAP_CONTINUATIONS
#endif

/* if stack is not longword aligned then */

/* #define SHORT_ALIGN */
#ifdef THINK_C
#define SHORT_ALIGN
#endif
#ifdef MSDOS
#define SHORT_ALIGN
#endif

/* If stacks grow up then */

/* #define STACK_GROWS_UP */

/* PTR_LT defines how to compare two CELLPTRs (which may not be in the
same array).  This is used only by garbage collection and storage
initialization.  CELLPTR is a pointer to a cons cell which may be
compared.  CELLPTRs are only used where comparisons are done. */ 

#ifdef TURBO
typedef cell far *CELLPTR;
#else
typedef cell *CELLPTR;
#endif
#define PTR_LT(x,y) (x < y)

/* CELL_UP and CELL_DN are used by init_heap_seg to find cell aligned inner
bounds for allocated storage */

#define CELL_UP(p) (CELLPTR)((((long)(p))+7)&~7)
#define CELL_DN(p) (CELLPTR)(((((long)(p))-7)|7)+1)

/* how to get the local definition for malloc */

#ifdef unix
	char *malloc();
	char *realloc();
#else
#ifdef MSDOS
#ifdef TURBO
#include <alloc.h>
#else
#include <malloc.h>
#endif
#endif
#endif

/* NUM_HASH_BUCKETS is the number of symbol hash table buckets.  */

#define NUM_HASH_BUCKETS 137

/* If fewer than MIN_GC_YIELD cells are recovered during a garbage
collection (GC) more space is allocated for the heap. */

#define MIN_GC_YIELD 500

/* These are parameters for controlling memory allocation.  The heap is
the area out of which cons and object headers is allocated.  Each heap
object is 8 bytes.  The units of the SIZE parameters is bytes.

INIT_HEAP_SIZE is the initial size of heap.  If this much heap cannot be
allocated, HEAP_SEG_SIZE will be used.  HEAP_SEG_SIZE is the size of
heap to try to allocate when more heap is needed.  HEAP_SEG_SIZE must
fit into type unsigned int.  MIN_HEAP_SEG_SIZE is minimum size of heap
to accept when more heap is needed.  */

#define INIT_HEAP_SIZE 200000
#define HEAP_SEG_SIZE 64800
#define MIN_HEAP_SEG_SIZE 8000

#endif /* IN_SYS */
