;;; Scheme->C
;;;
;;; This file contains external definitions for use in compiling the
;;; the interpreter.

;*              Copyright 1989 Digital Equipment Corporation
;*                         All Rights Reserved
;*
;* Permission to use, copy, and modify this software and its documentation is
;* hereby granted only under the following terms and conditions.  Both the
;* above copyright notice and this permission notice must appear in all copies
;* of the software, derivative works or modified versions, and any portions
;* thereof, and both notices must appear in supporting documentation.
;*
;* Users of this software agree to the terms and conditions set forth herein,
;* and hereby grant back to Digital a non-exclusive, unrestricted, royalty-free
;* right and license under any changes, enhancements or extensions made to the
;* core functions of the software, including but not limited to those affording
;* compatibility with other hardware or software environments, but excluding
;* applications which incorporate this software.  Users further agree to use
;* their best efforts to return to Digital any such changes, enhancements or
;* extensions that they make and inform Digital of noteworthy uses of this
;* software.  Correspondence should be provided to Digital at:
;* 
;*                       Director of Licensing
;*                       Western Research Laboratory
;*                       Digital Equipment Corporation
;*                       100 Hamilton Avenue
;*                       Palo Alto, California  94301  
;* 
;* This software may be distributed (but not offered for sale or transferred
;* for compensation) to third parties, provided such third parties agree to
;* abide by the terms and conditions of this notice.  
;* 
;* THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
;* WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
;* MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
;* CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
;* DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;* PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
;* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
;* SOFTWARE.

;;; Return the current value of sc_stacktrace.  It is not defined as a C
;;; external as the compiler emitted extern might conflict with the one
;;; in objects.h.

(define-in-line (STACKTRACE) ((lap () (UNSIGNED_TSCP "sc_stacktrace"))))

(define-external TRACE-LEVEL scdebug)

(define-external *DEBUG-ON-ERROR* scdebug)

(define-external (DOBACKTRACE start stop lines port) scdebug)

(define-external (BACKTRACE-ERROR-HANDLER id format-string . args) scdebug)

(define-external (ON-INTERRUPT sig) scdebug)

(define-external (EXPAND x) scexpand)

(define-external (INSTALL-EXPANDER keyword function) scexpand)

(define-external (ISLIST l min . max) scexpand)

(define-external (COND-MACRO exp) scexpanders1)

(define-external (LET-MACRO exp) scexpanders2)

(define-external (QUASIQUOTATION d exp) scquote)

(define-external *READING-STDIN* screp)
