.TH SCI 1 local
.SH NAME
sci \- Scheme interpreter
.SH SYNTAX
.B sci
[ option ]
.SH DESCRIPTION
The 
.B sci
command invokes
a Scheme interpreter.  The language accepted by this interpreter
is that defined in the essential portions of the
.I
Revised\v'-0.3m'3\v'0.3m' Report on the Algorithmic Language Scheme,
with minor constraints and some additions.  The
Scheme interpreter is written in Scheme which has then been compiled using
the Scheme-to-C compiler, \fBscc\fR.
.SH OPTIONS
These options are accepted by 
.B sci.
.TP 15
.B -e
Echo text read from the standard input file on the standard output file.
.TP 15
.B -emacs
Scheme interpreter is controlled by GNU emacs.
.TP 15
.B -nh
Do not print the interpreter version header on the standard output file.
.TP 15
.B -np
Do not prompt for input from the standard input file on the standard output
file.
.TP 15
.B -q
Do not print the result of each expression evaluation.
.TP 15
\fB-scgc   \fIstatflag\fR
Enables garbage collection statistics.  If set to 1, then garbage collection
statistics will be printed.  The default is 0, that will result in no
statistics.
.TP 15
\fB-sch  \fIheap\fR
Define the size of the heap in megabytes.  The default heap size is 4 MB.
.TP 15
\fB-schf  \fIheapfile\fR
Define a file containing a saved heap image that is to be used to initialize
the heap.
.TP 15
\fB-scl \fIpercent\fR
Specifies the percent of the heap allocated after a generational garbage
collection that will force a full collection.
.TP 15
\fB-scm  \fImain\fR
Define the function that should be used instead of the predefined "main".  The
function name must be entered in the correct case, i.e. letters typically 
upshifted.
.SH ENVIRONMENT VARIABLES
The items controlled by \fI-sc..\fR flags can also be controlled by environment
variables.  If both the flag and the environment variable are provided, then
the flag's value will be used.
.TP 15
.B SCGCINFO
Controls the reporting of garbage collection statistics to the standard error
file.  If set to 1, then garbage collection statistics will be printed.  The
default setting is 0 that will not print the statistics.
.TP 15
.B SCHEAP
Defines the size of the heap in megabytes.  The default heap size is 4 MB.
.TP 15
.B SCHEAPFILE
Controls initialization of the heap from a saved heap image.  If supplied, then
the heap will be loaded from the file.
.TP 15
.B SCLIMIT
Defines the percent of the heap allocated after a generational garbage
collection that will force a full collection.  The default is 33.
.SH FILES
The interpreter is one a.out file with the name \fIsci\fR.  All files
associated with the interpreter are found in the
directory \fI.../schemetoc/scrt\fB.
.SH SEE ALSO
.PP
Harold Abelson and Gerald Jay Sussman with Julie Sussman,
.I
Structure and Interpretation of Computer Programs,
The MIT Press.
.PP
Jonathan Rees and William Clinger (Editors),
.I
Revised\v'-0.3m'3\v'0.3m' Report on the Algorithmic Language Scheme,
SIGPLAN Notices, V21, #12, December 1986.
.PP
R. Kent Dybvig,
.I
The SCHEME Programming Language,
Prentice Hall, Inc.
.PP
Daniel P. Friedman and Matthias Felleisen,
.I
The Little LISPer,
MIT Press.
.PP
Joel Bartlett, documentation files in \fI.../schemetoc/...\fB.
.PP
scc(1)
.SH QUESTIONS, COMMENTS, AND COMPLAINTS
bartlett@decwrl.dec.com

