
/* SCHEME->C */

#include <objects.h>

DEFSTRING( t3674, "XHOSTADDRESSAP", 14 );
DEFSTATICTSCP( c3602 );
DEFSTRING( t3675, "XMODIFIERKEYMAPP", 16 );
DEFSTATICTSCP( c3389 );
DEFSTRING( t3676, "XQKEYMAPP", 9 );
DEFSTATICTSCP( c3218 );
DEFSTRING( t3677, "XKEYBOARDSTATEP", 15 );
DEFSTATICTSCP( c3165 );
DEFSTRING( t3678, "UNSIGNEDAP", 10 );
DEFSTATICTSCP( c2722 );

static void  init_constants()
{
        c3602 = STRINGTOSYMBOL( U_TX( ADR( t3674 ) ) );
        CONSTANTEXP( ADR( c3602 ) );
        c3389 = STRINGTOSYMBOL( U_TX( ADR( t3675 ) ) );
        CONSTANTEXP( ADR( c3389 ) );
        c3218 = STRINGTOSYMBOL( U_TX( ADR( t3676 ) ) );
        CONSTANTEXP( ADR( c3218 ) );
        c3165 = STRINGTOSYMBOL( U_TX( ADR( t3677 ) ) );
        CONSTANTEXP( ADR( c3165 ) );
        c2722 = STRINGTOSYMBOL( U_TX( ADR( t3678 ) ) );
        CONSTANTEXP( ADR( c2722 ) );
}

DEFTSCP( xws7_xreparentwindow_v );
DEFSTRING( t3679, "XREPARENTWINDOW", 15 );
EXTERNTSCPP( xlibtypes_chk_2ddisplayp );
EXTERNTSCP( xlibtypes_chk_2ddisplayp_v );
EXTERNVOIDP( XReparentWindow );

TSCP  xws7_xreparentwindow( d2605, 
                            w2606, p2607, x2608, y2609 )
        TSCP  d2605, w2606, p2607, x2608, y2609;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3679 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2605 );
        XReparentWindow( TSCP_POINTER( X1 ), 
                         TSCP_UNSIGNED( w2606 ), 
                         TSCP_UNSIGNED( p2607 ), 
                         TSCP_INT( x2608 ), 
                         TSCP_INT( y2609 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xchangesaveset_v );
DEFSTRING( t3684, "XCHANGESAVESET", 14 );
EXTERNVOIDP( XChangeSaveSet );

TSCP  xws7_xchangesaveset( d2630, w2631, m2632 )
        TSCP  d2630, w2631, m2632;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3684 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2630 );
        XChangeSaveSet( TSCP_POINTER( X1 ), 
                        TSCP_UNSIGNED( w2631 ), 
                        TSCP_INT( m2632 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xaddtosaveset_v );
DEFSTRING( t3689, "XADDTOSAVESET", 13 );
EXTERNVOIDP( XAddToSaveSet );

TSCP  xws7_xaddtosaveset( d2648, w2649 )
        TSCP  d2648, w2649;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3689 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2648 );
        XAddToSaveSet( TSCP_POINTER( X1 ), 
                       TSCP_UNSIGNED( w2649 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xremovefromsaveset_v );
DEFSTRING( t3694, "XREMOVEFROMSAVESET", 18 );
EXTERNVOIDP( XRemoveFromSaveSet );

TSCP  xws7_xremovefromsaveset( d2663, w2664 )
        TSCP  d2663, w2664;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3694 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2663 );
        XRemoveFromSaveSet( TSCP_POINTER( X1 ), 
                            TSCP_UNSIGNED( w2664 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xinstallcolormap_v );
DEFSTRING( t3699, "XINSTALLCOLORMAP", 16 );
EXTERNVOIDP( XInstallColormap );

TSCP  xws7_xinstallcolormap( d2678, c2679 )
        TSCP  d2678, c2679;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3699 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2678 );
        XInstallColormap( TSCP_POINTER( X1 ), 
                          TSCP_UNSIGNED( c2679 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xuninstallcolormap_v );
DEFSTRING( t3704, "XUNINSTALLCOLORMAP", 18 );
EXTERNVOIDP( XUninstallColormap );

TSCP  xws7_xuninstallcolormap( d2693, c2694 )
        TSCP  d2693, c2694;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3704 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2693 );
        XUninstallColormap( TSCP_POINTER( X1 ), 
                            TSCP_UNSIGNED( c2694 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xlistinstalledcolormaps_v );
DEFSTRING( t3709, "XLISTINSTALLEDCOLORMAPS", 23 );
EXTERNTSCPP( sc_make_2dstring );
EXTERNTSCP( sc_make_2dstring_v );
EXTERNTSCPP( sc_cons );
EXTERNTSCP( sc_cons_v );
EXTERNPOINTERP( XListInstalledColormaps );
EXTERNTSCPP( scrt4_c_2dint_2dref );
EXTERNTSCP( scrt4_c_2dint_2dref_v );

TSCP  xws7_xlistinstalledcolormaps( d2709, w2710 )
        TSCP  d2709, w2710;
{
        TSCP  X6, X5, X4, X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3709 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2709 );
        X2 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        X4 = POINTER_TSCP( XListInstalledColormaps( TSCP_POINTER( X1 ), 
                                                    TSCP_UNSIGNED( w2710 ), 
                                                    TSCP_POINTER( X2 ) ) );
        X3 = sc_cons( c2722, X4 );
        X6 = scrt4_c_2dint_2dref( X2, _TSCP( 0 ) );
        X5 = sc_cons( X6, EMPTYLIST );
        X4 = sc_cons( X3, X5 );
        POPSTACKTRACE( X4 );
}

DEFTSCP( xws7_xgrabpointer_v );
DEFSTRING( t3715, "XGRABPOINTER", 12 );
EXTERNINTP( XGrabPointer );

TSCP  xws7_xgrabpointer( d2737, 
                         g2738, 
                         o2739, 
                         e2740, 
                         p2741, k2742, c2743, c2744, t2745 )
        TSCP  d2737, 
              g2738, 
              o2739, 
              e2740, p2741, k2742, c2743, c2744, t2745;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3715 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2737 );
        X2 = INT_TSCP( XGrabPointer( TSCP_POINTER( X1 ), 
                                     TSCP_UNSIGNED( g2738 ), 
                                     TSCP_INT( o2739 ), 
                                     TSCP_UNSIGNED( e2740 ), 
                                     TSCP_INT( p2741 ), 
                                     TSCP_INT( k2742 ), 
                                     TSCP_UNSIGNED( c2743 ), 
                                     TSCP_UNSIGNED( c2744 ), 
                                     TSCP_UNSIGNED( t2745 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xungrabpointer_v );
DEFSTRING( t3719, "XUNGRABPOINTER", 14 );
EXTERNVOIDP( XUngrabPointer );

TSCP  xws7_xungrabpointer( d2772, t2773 )
        TSCP  d2772, t2773;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3719 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2772 );
        XUngrabPointer( TSCP_POINTER( X1 ), 
                        TSCP_UNSIGNED( t2773 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xchangeactivepointergrab_v );
DEFSTRING( t3724, "XCHANGEACTIVEPOINTERGRAB", 24 );
EXTERNVOIDP( XChangeActivePointerGrab );

TSCP  xws7_xchangeactivepointergrab( d2789, 
                                     e2790, c2791, t2792 )
        TSCP  d2789, e2790, c2791, t2792;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3724 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2789 );
        XChangeActivePointerGrab( TSCP_POINTER( X1 ), 
                                  TSCP_UNSIGNED( e2790 ), 
                                  TSCP_UNSIGNED( c2791 ), 
                                  TSCP_UNSIGNED( t2792 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xgrabbutton_v );
DEFSTRING( t3729, "XGRABBUTTON", 11 );
EXTERNVOIDP( XGrabButton );

TSCP  xws7_xgrabbutton( d2818, 
                        b2819, 
                        m2820, 
                        g2821, 
                        o2822, 
                        e2823, p2824, k2825, c2826, c2827 )
        TSCP  d2818, 
              b2819, 
              m2820, 
              g2821, 
              o2822, e2823, p2824, k2825, c2826, c2827;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3729 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2818 );
        XGrabButton( TSCP_POINTER( X1 ), 
                     TSCP_UNSIGNED( b2819 ), 
                     TSCP_UNSIGNED( m2820 ), 
                     TSCP_UNSIGNED( g2821 ), 
                     TSCP_INT( o2822 ), 
                     TSCP_UNSIGNED( e2823 ), 
                     TSCP_INT( p2824 ), 
                     TSCP_INT( k2825 ), 
                     TSCP_UNSIGNED( c2826 ), 
                     TSCP_UNSIGNED( c2827 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xungrabbutton_v );
DEFSTRING( t3734, "XUNGRABBUTTON", 13 );
EXTERNVOIDP( XUngrabButton );

TSCP  xws7_xungrabbutton( d2859, b2860, m2861, g2862 )
        TSCP  d2859, b2860, m2861, g2862;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3734 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2859 );
        XUngrabButton( TSCP_POINTER( X1 ), 
                       TSCP_UNSIGNED( b2860 ), 
                       TSCP_UNSIGNED( m2861 ), 
                       TSCP_UNSIGNED( g2862 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xgrabkeyboard_v );
DEFSTRING( t3739, "XGRABKEYBOARD", 13 );
EXTERNINTP( XGrabKeyboard );

TSCP  xws7_xgrabkeyboard( d2884, 
                          w2885, 
                          o2886, p2887, k2888, t2889 )
        TSCP  d2884, w2885, o2886, p2887, k2888, t2889;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3739 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2884 );
        X2 = INT_TSCP( XGrabKeyboard( TSCP_POINTER( X1 ), 
                                      TSCP_UNSIGNED( w2885 ), 
                                      TSCP_INT( o2886 ), 
                                      TSCP_INT( p2887 ), 
                                      TSCP_INT( k2888 ), 
                                      TSCP_UNSIGNED( t2889 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xungrabkeyboard_v );
DEFSTRING( t3743, "XUNGRABKEYBOARD", 15 );
EXTERNVOIDP( XUngrabKeyboard );

TSCP  xws7_xungrabkeyboard( d2910, t2911 )
        TSCP  d2910, t2911;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3743 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2910 );
        XUngrabKeyboard( TSCP_POINTER( X1 ), 
                         TSCP_UNSIGNED( t2911 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xgrabkey_v );
DEFSTRING( t3748, "XGRABKEY", 8 );
EXTERNVOIDP( XGrabKey );

TSCP  xws7_xgrabkey( d2930, 
                     k2931, 
                     m2932, g2933, o2934, p2935, k2936 )
        TSCP  d2930, 
              k2931, m2932, g2933, o2934, p2935, k2936;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3748 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2930 );
        XGrabKey( TSCP_POINTER( X1 ), 
                  TSCP_INT( k2931 ), 
                  TSCP_UNSIGNED( m2932 ), 
                  TSCP_UNSIGNED( g2933 ), 
                  TSCP_INT( o2934 ), 
                  TSCP_INT( p2935 ), TSCP_INT( k2936 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xungrabkey_v );
DEFSTRING( t3753, "XUNGRABKEY", 10 );
EXTERNVOIDP( XUngrabKey );

TSCP  xws7_xungrabkey( d2962, k2963, m2964, g2965 )
        TSCP  d2962, k2963, m2964, g2965;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3753 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2962 );
        XUngrabKey( TSCP_POINTER( X1 ), 
                    TSCP_INT( k2963 ), 
                    TSCP_UNSIGNED( m2964 ), 
                    TSCP_UNSIGNED( g2965 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xallowevents_v );
DEFSTRING( t3758, "XALLOWEVENTS", 12 );
EXTERNVOIDP( XAllowEvents );

TSCP  xws7_xallowevents( d2984, m2985, t2986 )
        TSCP  d2984, m2985, t2986;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3758 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2984 );
        XAllowEvents( TSCP_POINTER( X1 ), 
                      TSCP_INT( m2985 ), 
                      TSCP_UNSIGNED( t2986 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xgrabserver_v );
DEFSTRING( t3763, "XGRABSERVER", 11 );
EXTERNVOIDP( XGrabServer );

TSCP  xws7_xgrabserver( d3001 )
        TSCP  d3001;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3763 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3001 );
        XGrabServer( TSCP_POINTER( X1 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xungrabserver_v );
DEFSTRING( t3768, "XUNGRABSERVER", 13 );
EXTERNVOIDP( XUngrabServer );

TSCP  xws7_xungrabserver( d3012 )
        TSCP  d3012;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3768 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3012 );
        XUngrabServer( TSCP_POINTER( X1 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xwarppointer_v );
DEFSTRING( t3773, "XWARPPOINTER", 12 );
EXTERNVOIDP( XWarpPointer );

TSCP  xws7_xwarppointer( d3031, 
                         s3032, 
                         d3033, 
                         s3034, 
                         s3035, s3036, s3037, d3038, d3039 )
        TSCP  d3031, 
              s3032, 
              d3033, 
              s3034, s3035, s3036, s3037, d3038, d3039;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3773 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3031 );
        XWarpPointer( TSCP_POINTER( X1 ), 
                      TSCP_UNSIGNED( s3032 ), 
                      TSCP_UNSIGNED( d3033 ), 
                      TSCP_INT( s3034 ), 
                      TSCP_INT( s3035 ), 
                      TSCP_UNSIGNED( s3036 ), 
                      TSCP_UNSIGNED( s3037 ), 
                      TSCP_INT( d3038 ), TSCP_INT( d3039 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xsetinputfocus_v );
DEFSTRING( t3778, "XSETINPUTFOCUS", 14 );
EXTERNVOIDP( XSetInputFocus );

TSCP  xws7_xsetinputfocus( d3069, f3070, r3071, t3072 )
        TSCP  d3069, f3070, r3071, t3072;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3778 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3069 );
        XSetInputFocus( TSCP_POINTER( X1 ), 
                        TSCP_UNSIGNED( f3070 ), 
                        TSCP_INT( r3071 ), 
                        TSCP_UNSIGNED( t3072 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xgetinputfocus_v );
DEFSTRING( t3783, "XGETINPUTFOCUS", 14 );
EXTERNVOIDP( XGetInputFocus );
EXTERNTSCPP( scrt4_c_2dunsigned_2dref );
EXTERNTSCP( scrt4_c_2dunsigned_2dref_v );

TSCP  xws7_xgetinputfocus( d3091 )
        TSCP  d3091;
{
        TSCP  X8, X7, X6, X5, X4, X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3783 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3091 );
        X2 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        X3 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        XGetInputFocus( TSCP_POINTER( X1 ), 
                        TSCP_POINTER( X2 ), 
                        TSCP_POINTER( X3 ) );
        X4 = FALSEVALUE;
        X6 = scrt4_c_2dunsigned_2dref( X2, _TSCP( 0 ) );
        X8 = scrt4_c_2dint_2dref( X3, _TSCP( 0 ) );
        X7 = sc_cons( X8, EMPTYLIST );
        X5 = sc_cons( X6, X7 );
        POPSTACKTRACE( X5 );
}

DEFTSCP( xws7_xsetclosedownmode_v );
DEFSTRING( t3791, "XSETCLOSEDOWNMODE", 17 );
EXTERNVOIDP( XSetCloseDownMode );

TSCP  xws7_xsetclosedownmode( d3109, m3110 )
        TSCP  d3109, m3110;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3791 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3109 );
        XSetCloseDownMode( TSCP_POINTER( X1 ), 
                           TSCP_INT( m3110 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xkillclient_v );
DEFSTRING( t3796, "XKILLCLIENT", 11 );
EXTERNVOIDP( XKillClient );

TSCP  xws7_xkillclient( d3124, r3125 )
        TSCP  d3124, r3125;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3796 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3124 );
        XKillClient( TSCP_POINTER( X1 ), 
                     TSCP_UNSIGNED( r3125 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xchangekeyboardcontrol_v );
DEFSTRING( t3801, "XCHANGEKEYBOARDCONTROL", 22 );
EXTERNTSCPP( xlibtypes_rdcontrolp_b8c5a0f8 );
EXTERNTSCP( xlibtypes_rdcontrolp_b8c5a0f8_v );
EXTERNVOIDP( XChangeKeyboardControl );

TSCP  xws7_xchangekeyboardcontrol( d3140, m3141, v3142 )
        TSCP  d3140, m3141, v3142;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3801 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3140 );
        X2 = xlibtypes_rdcontrolp_b8c5a0f8( v3142 );
        XChangeKeyboardControl( TSCP_POINTER( X1 ), 
                                TSCP_UNSIGNED( m3141 ), 
                                TSCP_POINTER( X2 ) );
        X3 = FALSEVALUE;
        POPSTACKTRACE( X3 );
}

DEFTSCP( xws7_xgetkeyboardcontrol_v );
DEFSTRING( t3807, "XGETKEYBOARDCONTROL", 19 );
EXTERNVOIDP( XGetKeyboardControl );

TSCP  xws7_xgetkeyboardcontrol( d3158 )
        TSCP  d3158;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3807 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3158 );
        X2 = sc_make_2dstring( _TSCP( 224 ), EMPTYLIST );
        XGetKeyboardControl( TSCP_POINTER( X1 ), 
                             TSCP_POINTER( X2 ) );
        X3 = FALSEVALUE;
        POPSTACKTRACE( sc_cons( c3165, X2 ) );
}

DEFTSCP( xws7_xautorepeaton_v );
DEFSTRING( t3813, "XAUTOREPEATON", 13 );
EXTERNVOIDP( XAutoRepeatOn );

TSCP  xws7_xautorepeaton( d3173 )
        TSCP  d3173;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3813 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3173 );
        XAutoRepeatOn( TSCP_POINTER( X1 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xautorepeatoff_v );
DEFSTRING( t3818, "XAUTOREPEATOFF", 14 );
EXTERNVOIDP( XAutoRepeatOff );

TSCP  xws7_xautorepeatoff( d3184 )
        TSCP  d3184;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3818 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3184 );
        XAutoRepeatOff( TSCP_POINTER( X1 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xbell_v );
DEFSTRING( t3823, "XBELL", 5 );
EXTERNVOIDP( XBell );

TSCP  xws7_xbell( d3196, p3197 )
        TSCP  d3196, p3197;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3823 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3196 );
        XBell( TSCP_POINTER( X1 ), TSCP_INT( p3197 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xquerykeymap_v );
DEFSTRING( t3828, "XQUERYKEYMAP", 12 );
EXTERNVOIDP( XQueryKeymap );

TSCP  xws7_xquerykeymap( d3211 )
        TSCP  d3211;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3828 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3211 );
        X2 = sc_make_2dstring( _TSCP( 128 ), EMPTYLIST );
        XQueryKeymap( TSCP_POINTER( X1 ), 
                      TSCP_POINTER( X2 ) );
        X3 = FALSEVALUE;
        POPSTACKTRACE( sc_cons( c3218, X2 ) );
}

DEFTSCP( xws7_xsetpointermapping_v );
DEFSTRING( t3834, "XSETPOINTERMAPPING", 18 );
EXTERNTSCPP( xlibtypes_chk_2dcharap );
EXTERNTSCP( xlibtypes_chk_2dcharap_v );
EXTERNINTP( XSetPointerMapping );

TSCP  xws7_xsetpointermapping( d3228, m3229, n3230 )
        TSCP  d3228, m3229, n3230;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3834 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3228 );
        X2 = xlibtypes_chk_2dcharap( m3229 );
        X3 = INT_TSCP( XSetPointerMapping( TSCP_POINTER( X1 ), 
                                           TSCP_POINTER( X2 ), 
                                           TSCP_INT( n3230 ) ) );
        POPSTACKTRACE( X3 );
}

DEFTSCP( xws7_xgetpointermapping_v );
DEFSTRING( t3839, "XGETPOINTERMAPPING", 18 );
EXTERNINTP( XGetPointerMapping );

TSCP  xws7_xgetpointermapping( d3246, m3247, n3248 )
        TSCP  d3246, m3247, n3248;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3839 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3246 );
        X2 = xlibtypes_chk_2dcharap( m3247 );
        X3 = INT_TSCP( XGetPointerMapping( TSCP_POINTER( X1 ), 
                                           TSCP_POINTER( X2 ), 
                                           TSCP_INT( n3248 ) ) );
        POPSTACKTRACE( X3 );
}

DEFTSCP( xws7_xchangepointercontrol_v );
DEFSTRING( t3844, "XCHANGEPOINTERCONTROL", 21 );
EXTERNVOIDP( XChangePointerControl );

TSCP  xws7_xchangepointercontrol( d3267, 
                                  d3268, 
                                  d3269, a3270, a3271, t3272 )
        TSCP  d3267, d3268, d3269, a3270, a3271, t3272;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3844 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3267 );
        XChangePointerControl( TSCP_POINTER( X1 ), 
                               TSCP_INT( d3268 ), 
                               TSCP_INT( d3269 ), 
                               TSCP_INT( a3270 ), 
                               TSCP_INT( a3271 ), 
                               TSCP_INT( t3272 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xgetpointercontrol_v );
DEFSTRING( t3849, "XGETPOINTERCONTROL", 18 );
EXTERNVOIDP( XGetPointerControl );

TSCP  xws7_xgetpointercontrol( d3296 )
        TSCP  d3296;
{
        TSCP  X11, 
              X10, 
              X9, 
              X8, X7, X6, X5, X4, X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3849 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3296 );
        X2 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        X3 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        X4 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        XGetPointerControl( TSCP_POINTER( X1 ), 
                            TSCP_POINTER( X2 ), 
                            TSCP_POINTER( X3 ), 
                            TSCP_POINTER( X4 ) );
        X5 = FALSEVALUE;
        X7 = scrt4_c_2dint_2dref( X2, _TSCP( 0 ) );
        X9 = scrt4_c_2dint_2dref( X3, _TSCP( 0 ) );
        X11 = scrt4_c_2dint_2dref( X4, _TSCP( 0 ) );
        X10 = sc_cons( X11, EMPTYLIST );
        X8 = sc_cons( X9, X10 );
        X6 = sc_cons( X7, X8 );
        POPSTACKTRACE( X6 );
}

DEFTSCP( xws7_xdisplaykeycodes_v );
DEFSTRING( t3858, "XDISPLAYKEYCODES", 16 );
EXTERNVOIDP( XDisplayKeycodes );

TSCP  xws7_xdisplaykeycodes( d3317 )
        TSCP  d3317;
{
        TSCP  X8, X7, X6, X5, X4, X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3858 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3317 );
        X2 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        X3 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        XDisplayKeycodes( TSCP_POINTER( X1 ), 
                          TSCP_POINTER( X2 ), 
                          TSCP_POINTER( X3 ) );
        X4 = FALSEVALUE;
        X6 = scrt4_c_2dint_2dref( X2, _TSCP( 0 ) );
        X8 = scrt4_c_2dint_2dref( X3, _TSCP( 0 ) );
        X7 = sc_cons( X8, EMPTYLIST );
        X5 = sc_cons( X6, X7 );
        POPSTACKTRACE( X5 );
}

DEFTSCP( xws7_xgetkeyboardmapping_v );
DEFSTRING( t3866, "XGETKEYBOARDMAPPING", 19 );
EXTERNPOINTERP( XGetKeyboardMapping );

TSCP  xws7_xgetkeyboardmapping( d3337, f3338, c3339 )
        TSCP  d3337, f3338, c3339;
{
        TSCP  X6, X5, X4, X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3866 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3337 );
        X2 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        X4 = POINTER_TSCP( XGetKeyboardMapping( TSCP_POINTER( X1 ), 
                                                TSCP_CHAR( f3338 ), 
                                                TSCP_INT( c3339 ), 
                                                TSCP_POINTER( X2 ) ) );
        X3 = sc_cons( c2722, X4 );
        X6 = scrt4_c_2dint_2dref( X2, _TSCP( 0 ) );
        X5 = sc_cons( X6, EMPTYLIST );
        X4 = sc_cons( X3, X5 );
        POPSTACKTRACE( X4 );
}

DEFTSCP( xws7_xchangekeyboardmapping_v );
DEFSTRING( t3872, "XCHANGEKEYBOARDMAPPING", 22 );
EXTERNTSCPP( xlibtypes_chk_2dunsignedap );
EXTERNTSCP( xlibtypes_chk_2dunsignedap_v );
EXTERNVOIDP( XChangeKeyboardMapping );

TSCP  xws7_xchangekeyboardmapping( d3361, 
                                   f3362, k3363, k3364, n3365 )
        TSCP  d3361, f3362, k3363, k3364, n3365;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3872 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3361 );
        X2 = xlibtypes_chk_2dunsignedap( k3364 );
        XChangeKeyboardMapping( TSCP_POINTER( X1 ), 
                                TSCP_INT( f3362 ), 
                                TSCP_INT( k3363 ), 
                                TSCP_POINTER( X2 ), 
                                TSCP_INT( n3365 ) );
        X3 = FALSEVALUE;
        POPSTACKTRACE( X3 );
}

DEFTSCP( xws7_xnewmodifiermap_v );
DEFSTRING( t3878, "XNEWMODIFIERMAP", 15 );
EXTERNPOINTERP( XNewModifiermap );

TSCP  xws7_xnewmodifiermap( k3384 )
        TSCP  k3384;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3878 ) ) );
        X2 = POINTER_TSCP( XNewModifiermap( TSCP_INT( k3384 ) ) );
        X1 = sc_cons( c3389, X2 );
        POPSTACKTRACE( X1 );
}

DEFTSCP( xws7_xinsertmodifiermapentry_v );
DEFSTRING( t3881, "XINSERTMODIFIERMAPENTRY", 23 );
EXTERNTSCPP( xlibtypes_ierkeymapp_ba00839f );
EXTERNTSCP( xlibtypes_ierkeymapp_ba00839f_v );
EXTERNPOINTERP( XInsertModifiermapEntry );

TSCP  xws7_xinsertmodifiermapentry( m3397, k3398, m3399 )
        TSCP  m3397, k3398, m3399;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3881 ) ) );
        X1 = xlibtypes_ierkeymapp_ba00839f( m3397 );
        X3 = POINTER_TSCP( XInsertModifiermapEntry( TSCP_POINTER( X1 ), 
                                                    TSCP_CHAR( k3398 ), 
                                                    TSCP_INT( m3399 ) ) );
        X2 = sc_cons( c3389, X3 );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xdeletemodifiermapentry_v );
DEFSTRING( t3885, "XDELETEMODIFIERMAPENTRY", 23 );
EXTERNPOINTERP( XDeleteModifiermapEntry );

TSCP  xws7_xdeletemodifiermapentry( m3415, k3416, m3417 )
        TSCP  m3415, k3416, m3417;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3885 ) ) );
        X1 = xlibtypes_ierkeymapp_ba00839f( m3415 );
        X3 = POINTER_TSCP( XDeleteModifiermapEntry( TSCP_POINTER( X1 ), 
                                                    TSCP_CHAR( k3416 ), 
                                                    TSCP_INT( m3417 ) ) );
        X2 = sc_cons( c3389, X3 );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xfreemodifiermap_v );
DEFSTRING( t3889, "XFREEMODIFIERMAP", 16 );
EXTERNVOIDP( XFreeModifiermap );

TSCP  xws7_xfreemodifiermap( m3431 )
        TSCP  m3431;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3889 ) ) );
        X1 = xlibtypes_ierkeymapp_ba00839f( m3431 );
        XFreeModifiermap( TSCP_POINTER( X1 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xsetmodifiermapping_v );
DEFSTRING( t3894, "XSETMODIFIERMAPPING", 19 );
EXTERNINTP( XSetModifierMapping );

TSCP  xws7_xsetmodifiermapping( d3443, m3444 )
        TSCP  d3443, m3444;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3894 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3443 );
        X2 = xlibtypes_ierkeymapp_ba00839f( m3444 );
        X3 = INT_TSCP( XSetModifierMapping( TSCP_POINTER( X1 ), 
                                            TSCP_POINTER( X2 ) ) );
        POPSTACKTRACE( X3 );
}

DEFTSCP( xws7_xgetmodifiermapping_v );
DEFSTRING( t3899, "XGETMODIFIERMAPPING", 19 );
EXTERNPOINTERP( XGetModifierMapping );

TSCP  xws7_xgetmodifiermapping( d3456 )
        TSCP  d3456;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3899 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3456 );
        X3 = POINTER_TSCP( XGetModifierMapping( TSCP_POINTER( X1 ) ) );
        X2 = sc_cons( c3389, X3 );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xsetscreensaver_v );
DEFSTRING( t3903, "XSETSCREENSAVER", 15 );
EXTERNVOIDP( XSetScreenSaver );

TSCP  xws7_xsetscreensaver( d3470, 
                            t3471, i3472, p3473, a3474 )
        TSCP  d3470, t3471, i3472, p3473, a3474;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3903 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3470 );
        XSetScreenSaver( TSCP_POINTER( X1 ), 
                         TSCP_INT( t3471 ), 
                         TSCP_INT( i3472 ), 
                         TSCP_INT( p3473 ), 
                         TSCP_INT( a3474 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xforcescreensaver_v );
DEFSTRING( t3908, "XFORCESCREENSAVER", 17 );
EXTERNVOIDP( XForceScreenSaver );

TSCP  xws7_xforcescreensaver( d3494, m3495 )
        TSCP  d3494, m3495;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3908 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3494 );
        XForceScreenSaver( TSCP_POINTER( X1 ), 
                           TSCP_INT( m3495 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xactivatescreensaver_v );
DEFSTRING( t3913, "XACTIVATESCREENSAVER", 20 );
EXTERNVOIDP( XActivateScreenSaver );

TSCP  xws7_xactivatescreensaver( d3508 )
        TSCP  d3508;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3913 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3508 );
        XActivateScreenSaver( TSCP_POINTER( X1 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xresetscreensaver_v );
DEFSTRING( t3918, "XRESETSCREENSAVER", 17 );
EXTERNVOIDP( XResetScreenSaver );

TSCP  xws7_xresetscreensaver( d3519 )
        TSCP  d3519;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3918 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3519 );
        XResetScreenSaver( TSCP_POINTER( X1 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xgetscreensaver_v );
DEFSTRING( t3923, "XGETSCREENSAVER", 15 );
EXTERNVOIDP( XGetScreenSaver );

TSCP  xws7_xgetscreensaver( d3534 )
        TSCP  d3534;
{
        TSCP  X14, 
              X13, 
              X12, 
              X11, 
              X10, 
              X9, 
              X8, X7, X6, X5, X4, X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3923 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3534 );
        X2 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        X3 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        X4 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        X5 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        XGetScreenSaver( TSCP_POINTER( X1 ), 
                         TSCP_POINTER( X2 ), 
                         TSCP_POINTER( X3 ), 
                         TSCP_POINTER( X4 ), 
                         TSCP_POINTER( X5 ) );
        X6 = FALSEVALUE;
        X8 = scrt4_c_2dint_2dref( X2, _TSCP( 0 ) );
        X10 = scrt4_c_2dint_2dref( X3, _TSCP( 0 ) );
        X12 = scrt4_c_2dint_2dref( X4, _TSCP( 0 ) );
        X14 = scrt4_c_2dint_2dref( X5, _TSCP( 0 ) );
        X13 = sc_cons( X14, EMPTYLIST );
        X11 = sc_cons( X12, X13 );
        X9 = sc_cons( X10, X11 );
        X7 = sc_cons( X8, X9 );
        POPSTACKTRACE( X7 );
}

DEFTSCP( xws7_xaddhost_v );
DEFSTRING( t3933, "XADDHOST", 8 );
EXTERNTSCPP( xlibtypes_chk_2dxhostaddressp );
EXTERNTSCP( xlibtypes_chk_2dxhostaddressp_v );
EXTERNVOIDP( XAddHost );

TSCP  xws7_xaddhost( d3556, h3557 )
        TSCP  d3556, h3557;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3933 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3556 );
        X2 = xlibtypes_chk_2dxhostaddressp( h3557 );
        XAddHost( TSCP_POINTER( X1 ), TSCP_POINTER( X2 ) );
        X3 = FALSEVALUE;
        POPSTACKTRACE( X3 );
}

DEFTSCP( xws7_xaddhosts_v );
DEFSTRING( t3939, "XADDHOSTS", 9 );
EXTERNTSCPP( xlibtypes_taddressap_c5fd3430 );
EXTERNTSCP( xlibtypes_taddressap_c5fd3430_v );
EXTERNVOIDP( XAddHosts );

TSCP  xws7_xaddhosts( d3572, h3573, n3574 )
        TSCP  d3572, h3573, n3574;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3939 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3572 );
        X2 = xlibtypes_taddressap_c5fd3430( h3573 );
        XAddHosts( TSCP_POINTER( X1 ), 
                   TSCP_POINTER( X2 ), TSCP_INT( n3574 ) );
        X3 = FALSEVALUE;
        POPSTACKTRACE( X3 );
}

DEFTSCP( xws7_xlisthosts_v );
DEFSTRING( t3945, "XLISTHOSTS", 10 );
EXTERNPOINTERP( XListHosts );

TSCP  xws7_xlisthosts( d3591 )
        TSCP  d3591;
{
        TSCP  X9, 
              X8, X7, X6, X5, X4, X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3945 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3591 );
        X2 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        X3 = sc_make_2dstring( _TSCP( 16 ), EMPTYLIST );
        X5 = POINTER_TSCP( XListHosts( TSCP_POINTER( X1 ), 
                                       TSCP_POINTER( X2 ), 
                                       TSCP_POINTER( X3 ) ) );
        X4 = sc_cons( c3602, X5 );
        X7 = scrt4_c_2dint_2dref( X2, _TSCP( 0 ) );
        X9 = scrt4_c_2dint_2dref( X3, _TSCP( 0 ) );
        X8 = sc_cons( X9, EMPTYLIST );
        X6 = sc_cons( X7, X8 );
        X5 = sc_cons( X4, X6 );
        POPSTACKTRACE( X5 );
}

DEFTSCP( xws7_xremovehost_v );
DEFSTRING( t3952, "XREMOVEHOST", 11 );
EXTERNVOIDP( XRemoveHost );

TSCP  xws7_xremovehost( d3609, h3610 )
        TSCP  d3609, h3610;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3952 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3609 );
        X2 = xlibtypes_chk_2dxhostaddressp( h3610 );
        XRemoveHost( TSCP_POINTER( X1 ), 
                     TSCP_POINTER( X2 ) );
        X3 = FALSEVALUE;
        POPSTACKTRACE( X3 );
}

DEFTSCP( xws7_xremovehosts_v );
DEFSTRING( t3958, "XREMOVEHOSTS", 12 );
EXTERNVOIDP( XRemoveHosts );

TSCP  xws7_xremovehosts( d3625, h3626, n3627 )
        TSCP  d3625, h3626, n3627;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3958 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3625 );
        X2 = xlibtypes_taddressap_c5fd3430( h3626 );
        XRemoveHosts( TSCP_POINTER( X1 ), 
                      TSCP_POINTER( X2 ), 
                      TSCP_INT( n3627 ) );
        X3 = FALSEVALUE;
        POPSTACKTRACE( X3 );
}

DEFTSCP( xws7_xsetaccesscontrol_v );
DEFSTRING( t3964, "XSETACCESSCONTROL", 17 );
EXTERNVOIDP( XSetAccessControl );

TSCP  xws7_xsetaccesscontrol( d3643, m3644 )
        TSCP  d3643, m3644;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3964 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3643 );
        XSetAccessControl( TSCP_POINTER( X1 ), 
                           TSCP_INT( m3644 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xenableaccesscontrol_v );
DEFSTRING( t3969, "XENABLEACCESSCONTROL", 20 );
EXTERNVOIDP( XEnableAccessControl );

TSCP  xws7_xenableaccesscontrol( d3657 )
        TSCP  d3657;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3969 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3657 );
        XEnableAccessControl( TSCP_POINTER( X1 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws7_xdisableaccesscontrol_v );
DEFSTRING( t3974, "XDISABLEACCESSCONTROL", 21 );
EXTERNVOIDP( XDisableAccessControl );

TSCP  xws7_xdisableaccesscontrol( d3668 )
        TSCP  d3668;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3974 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3668 );
        XDisableAccessControl( TSCP_POINTER( X1 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

static void  init_modules( compiler_version )
        char *compiler_version;
{
        scrt4__init();
        xlibtypes__init();
        MAXDISPLAY( 0 );
}

void  xws7__init()
{
        static int  init = 0;
        if  (init)  return;
        init = 1;
        INITHEAP( 0, 0, 0, 0 );
        init_constants();
        init_modules( "(xws7 SCHEME->C COMPILER 01nov91jfb)" );
        INITIALIZEVAR( U_TX( ADR( t3679 ) ), 
                       ADR( xws7_xreparentwindow_v ), 
                       MAKEPROCEDURE( 5, 
                                      0, 
                                      xws7_xreparentwindow, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3684 ) ), 
                       ADR( xws7_xchangesaveset_v ), 
                       MAKEPROCEDURE( 3, 
                                      0, 
                                      xws7_xchangesaveset, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3689 ) ), 
                       ADR( xws7_xaddtosaveset_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws7_xaddtosaveset, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3694 ) ), 
                       ADR( xws7_xremovefromsaveset_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws7_xremovefromsaveset, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3699 ) ), 
                       ADR( xws7_xinstallcolormap_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws7_xinstallcolormap, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3704 ) ), 
                       ADR( xws7_xuninstallcolormap_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws7_xuninstallcolormap, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3709 ) ), 
                       ADR( xws7_xlistinstalledcolormaps_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws7_xlistinstalledcolormaps, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3715 ) ), 
                       ADR( xws7_xgrabpointer_v ), 
                       MAKEPROCEDURE( 9, 
                                      0, 
                                      xws7_xgrabpointer, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3719 ) ), 
                       ADR( xws7_xungrabpointer_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws7_xungrabpointer, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3724 ) ), 
                       ADR( xws7_xchangeactivepointergrab_v ), 
                       MAKEPROCEDURE( 4, 
                                      0, 
                                      xws7_xchangeactivepointergrab, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3729 ) ), 
                       ADR( xws7_xgrabbutton_v ), 
                       MAKEPROCEDURE( 10, 
                                      0, 
                                      xws7_xgrabbutton, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3734 ) ), 
                       ADR( xws7_xungrabbutton_v ), 
                       MAKEPROCEDURE( 4, 
                                      0, 
                                      xws7_xungrabbutton, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3739 ) ), 
                       ADR( xws7_xgrabkeyboard_v ), 
                       MAKEPROCEDURE( 6, 
                                      0, 
                                      xws7_xgrabkeyboard, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3743 ) ), 
                       ADR( xws7_xungrabkeyboard_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws7_xungrabkeyboard, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3748 ) ), 
                       ADR( xws7_xgrabkey_v ), 
                       MAKEPROCEDURE( 7, 
                                      0, xws7_xgrabkey, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3753 ) ), 
                       ADR( xws7_xungrabkey_v ), 
                       MAKEPROCEDURE( 4, 
                                      0, 
                                      xws7_xungrabkey, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3758 ) ), 
                       ADR( xws7_xallowevents_v ), 
                       MAKEPROCEDURE( 3, 
                                      0, 
                                      xws7_xallowevents, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3763 ) ), 
                       ADR( xws7_xgrabserver_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xgrabserver, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3768 ) ), 
                       ADR( xws7_xungrabserver_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xungrabserver, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3773 ) ), 
                       ADR( xws7_xwarppointer_v ), 
                       MAKEPROCEDURE( 9, 
                                      0, 
                                      xws7_xwarppointer, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3778 ) ), 
                       ADR( xws7_xsetinputfocus_v ), 
                       MAKEPROCEDURE( 4, 
                                      0, 
                                      xws7_xsetinputfocus, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3783 ) ), 
                       ADR( xws7_xgetinputfocus_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xgetinputfocus, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3791 ) ), 
                       ADR( xws7_xsetclosedownmode_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws7_xsetclosedownmode, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3796 ) ), 
                       ADR( xws7_xkillclient_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws7_xkillclient, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3801 ) ), 
                       ADR( xws7_xchangekeyboardcontrol_v ), 
                       MAKEPROCEDURE( 3, 
                                      0, 
                                      xws7_xchangekeyboardcontrol, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3807 ) ), 
                       ADR( xws7_xgetkeyboardcontrol_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xgetkeyboardcontrol, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3813 ) ), 
                       ADR( xws7_xautorepeaton_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xautorepeaton, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3818 ) ), 
                       ADR( xws7_xautorepeatoff_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xautorepeatoff, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3823 ) ), 
                       ADR( xws7_xbell_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, xws7_xbell, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3828 ) ), 
                       ADR( xws7_xquerykeymap_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xquerykeymap, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3834 ) ), 
                       ADR( xws7_xsetpointermapping_v ), 
                       MAKEPROCEDURE( 3, 
                                      0, 
                                      xws7_xsetpointermapping, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3839 ) ), 
                       ADR( xws7_xgetpointermapping_v ), 
                       MAKEPROCEDURE( 3, 
                                      0, 
                                      xws7_xgetpointermapping, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3844 ) ), 
                       ADR( xws7_xchangepointercontrol_v ), 
                       MAKEPROCEDURE( 6, 
                                      0, 
                                      xws7_xchangepointercontrol, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3849 ) ), 
                       ADR( xws7_xgetpointercontrol_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xgetpointercontrol, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3858 ) ), 
                       ADR( xws7_xdisplaykeycodes_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xdisplaykeycodes, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3866 ) ), 
                       ADR( xws7_xgetkeyboardmapping_v ), 
                       MAKEPROCEDURE( 3, 
                                      0, 
                                      xws7_xgetkeyboardmapping, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3872 ) ), 
                       ADR( xws7_xchangekeyboardmapping_v ), 
                       MAKEPROCEDURE( 5, 
                                      0, 
                                      xws7_xchangekeyboardmapping, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3878 ) ), 
                       ADR( xws7_xnewmodifiermap_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xnewmodifiermap, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3881 ) ), 
                       ADR( xws7_xinsertmodifiermapentry_v ), 
                       MAKEPROCEDURE( 3, 
                                      0, 
                                      xws7_xinsertmodifiermapentry, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3885 ) ), 
                       ADR( xws7_xdeletemodifiermapentry_v ), 
                       MAKEPROCEDURE( 3, 
                                      0, 
                                      xws7_xdeletemodifiermapentry, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3889 ) ), 
                       ADR( xws7_xfreemodifiermap_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xfreemodifiermap, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3894 ) ), 
                       ADR( xws7_xsetmodifiermapping_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws7_xsetmodifiermapping, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3899 ) ), 
                       ADR( xws7_xgetmodifiermapping_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xgetmodifiermapping, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3903 ) ), 
                       ADR( xws7_xsetscreensaver_v ), 
                       MAKEPROCEDURE( 5, 
                                      0, 
                                      xws7_xsetscreensaver, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3908 ) ), 
                       ADR( xws7_xforcescreensaver_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws7_xforcescreensaver, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3913 ) ), 
                       ADR( xws7_xactivatescreensaver_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xactivatescreensaver, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3918 ) ), 
                       ADR( xws7_xresetscreensaver_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xresetscreensaver, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3923 ) ), 
                       ADR( xws7_xgetscreensaver_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xgetscreensaver, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3933 ) ), 
                       ADR( xws7_xaddhost_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, xws7_xaddhost, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3939 ) ), 
                       ADR( xws7_xaddhosts_v ), 
                       MAKEPROCEDURE( 3, 
                                      0, xws7_xaddhosts, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3945 ) ), 
                       ADR( xws7_xlisthosts_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xlisthosts, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3952 ) ), 
                       ADR( xws7_xremovehost_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws7_xremovehost, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3958 ) ), 
                       ADR( xws7_xremovehosts_v ), 
                       MAKEPROCEDURE( 3, 
                                      0, 
                                      xws7_xremovehosts, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3964 ) ), 
                       ADR( xws7_xsetaccesscontrol_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws7_xsetaccesscontrol, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3969 ) ), 
                       ADR( xws7_xenableaccesscontrol_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xenableaccesscontrol, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3974 ) ), 
                       ADR( xws7_xdisableaccesscontrol_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws7_xdisableaccesscontrol, 
                                      EMPTYLIST ) );
        return;
}
