
/* SCHEME->C */

#include <objects.h>

DEFSTRING( t3209, "VISUALP", 7 );
DEFSTATICTSCP( c2757 );
DEFSTRING( t3210, "SCREENP", 7 );
DEFSTATICTSCP( c2718 );
DEFSTRING( t3211, "GC", 2 );
DEFSTATICTSCP( c2697 );
DEFSTRING( t3212, "Argument is incorrect type: ~s", 30 );
DEFSTATICTSCP2( c2610, t3212 );
DEFSTRING( t3213, "CHK-STRING", 10 );
DEFSTATICTSCP( c2609 );
DEFSTRING( t3214, "DISPLAYP", 8 );
DEFSTATICTSCP( c2606 );

static void  init_constants()
{
        c2757 = STRINGTOSYMBOL( U_TX( ADR( t3209 ) ) );
        CONSTANTEXP( ADR( c2757 ) );
        c2718 = STRINGTOSYMBOL( U_TX( ADR( t3210 ) ) );
        CONSTANTEXP( ADR( c2718 ) );
        c2697 = STRINGTOSYMBOL( U_TX( ADR( t3211 ) ) );
        CONSTANTEXP( ADR( c2697 ) );
        c2609 = STRINGTOSYMBOL( U_TX( ADR( t3213 ) ) );
        CONSTANTEXP( ADR( c2609 ) );
        c2606 = STRINGTOSYMBOL( U_TX( ADR( t3214 ) ) );
        CONSTANTEXP( ADR( c2606 ) );
}

DEFTSCP( xws2_xopendisplay_v );
DEFSTRING( t3215, "XOPENDISPLAY", 12 );
EXTERNTSCPP( scrt6_error );
EXTERNTSCP( scrt6_error_v );
EXTERNTSCPP( sc_cons );
EXTERNTSCP( sc_cons_v );
EXTERNPOINTERP( XOpenDisplay );

TSCP  xws2_xopendisplay( d2601 )
        TSCP  d2601;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3215 ) ) );
        if  ( NOT( AND( EQ( TSCPTAG( d2601 ), EXTENDEDTAG ), 
                        EQ( TSCP_EXTENDEDTAG( d2601 ), STRINGTAG ) ) )
            )  goto  L3217;
        X1 = d2601;
        goto L3218;
L3217:
        X1 = scrt6_error( c2609, 
                          c2610, CONS( d2601, EMPTYLIST ) );
L3218:
        X3 = POINTER_TSCP( XOpenDisplay( TSCP_POINTER( X1 ) ) );
        X2 = sc_cons( c2606, X3 );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xallplanes_v );
DEFSTRING( t3221, "XALLPLANES", 10 );
EXTERNINTP( XAllPlanes );

TSCP  xws2_xallplanes(  )
{
        TSCP  X1;

        PUSHSTACKTRACE( U_TX( ADR( t3221 ) ) );
        X1 = INT_TSCP( XAllPlanes(  ) );
        POPSTACKTRACE( X1 );
}

DEFTSCP( xws2_xblackpixel_v );
DEFSTRING( t3224, "XBLACKPIXEL", 11 );
EXTERNTSCPP( xlibtypes_chk_2ddisplayp );
EXTERNTSCP( xlibtypes_chk_2ddisplayp_v );
EXTERNINTP( XBlackPixel );

TSCP  xws2_xblackpixel( d2623, s2624 )
        TSCP  d2623, s2624;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3224 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2623 );
        X2 = INT_TSCP( XBlackPixel( TSCP_POINTER( X1 ), 
                                    TSCP_INT( s2624 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xwhitepixel_v );
DEFSTRING( t3228, "XWHITEPIXEL", 11 );
EXTERNINTP( XWhitePixel );

TSCP  xws2_xwhitepixel( d2637, s2638 )
        TSCP  d2637, s2638;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3228 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2637 );
        X2 = INT_TSCP( XWhitePixel( TSCP_POINTER( X1 ), 
                                    TSCP_INT( s2638 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xconnectionnumber_v );
DEFSTRING( t3232, "XCONNECTIONNUMBER", 17 );
EXTERNINTP( XConnectionNumber );

TSCP  xws2_xconnectionnumber( d2650 )
        TSCP  d2650;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3232 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2650 );
        X2 = INT_TSCP( XConnectionNumber( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdefaultcolormap_v );
DEFSTRING( t3236, "XDEFAULTCOLORMAP", 16 );
EXTERNUNSIGNEDP( XDefaultColormap );

TSCP  xws2_xdefaultcolormap( d2661, s2662 )
        TSCP  d2661, s2662;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3236 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2661 );
        X2 = UNSIGNED_TSCP( XDefaultColormap( TSCP_POINTER( X1 ), 
                                              TSCP_INT( s2662 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdefaultdepth_v );
DEFSTRING( t3240, "XDEFAULTDEPTH", 13 );
EXTERNINTP( XDefaultDepth );

TSCP  xws2_xdefaultdepth( d2675, s2676 )
        TSCP  d2675, s2676;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3240 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2675 );
        X2 = INT_TSCP( XDefaultDepth( TSCP_POINTER( X1 ), 
                                      TSCP_INT( s2676 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdefaultgc_v );
DEFSTRING( t3244, "XDEFAULTGC", 10 );
EXTERNPOINTERP( XDefaultGC );

TSCP  xws2_xdefaultgc( d2689, s2690 )
        TSCP  d2689, s2690;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3244 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2689 );
        X3 = POINTER_TSCP( XDefaultGC( TSCP_POINTER( X1 ), 
                                       TSCP_INT( s2690 ) ) );
        X2 = sc_cons( c2697, X3 );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdefaultrootwindow_v );
DEFSTRING( t3248, "XDEFAULTROOTWINDOW", 18 );
EXTERNUNSIGNEDP( XDefaultRootWindow );

TSCP  xws2_xdefaultrootwindow( d2703 )
        TSCP  d2703;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3248 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2703 );
        X2 = UNSIGNED_TSCP( XDefaultRootWindow( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdefaultscreenofdisplay_v );
DEFSTRING( t3252, "XDEFAULTSCREENOFDISPLAY", 23 );
EXTERNPOINTERP( XDefaultScreenOfDisplay );

TSCP  xws2_xdefaultscreenofdisplay( d2713 )
        TSCP  d2713;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3252 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2713 );
        X3 = POINTER_TSCP( XDefaultScreenOfDisplay( TSCP_POINTER( X1 ) ) );
        X2 = sc_cons( c2718, X3 );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xscreenofdisplay_v );
DEFSTRING( t3256, "XSCREENOFDISPLAY", 16 );
EXTERNPOINTERP( XScreenOfDisplay );

TSCP  xws2_xscreenofdisplay( d2725, s2726 )
        TSCP  d2725, s2726;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3256 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2725 );
        X3 = POINTER_TSCP( XScreenOfDisplay( TSCP_POINTER( X1 ), 
                                             TSCP_INT( s2726 ) ) );
        X2 = sc_cons( c2718, X3 );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdefaultscreen_v );
DEFSTRING( t3260, "XDEFAULTSCREEN", 14 );
EXTERNINTP( XDefaultScreen );

TSCP  xws2_xdefaultscreen( d2738 )
        TSCP  d2738;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3260 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2738 );
        X2 = INT_TSCP( XDefaultScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdefaultvisual_v );
DEFSTRING( t3264, "XDEFAULTVISUAL", 14 );
EXTERNPOINTERP( XDefaultVisual );

TSCP  xws2_xdefaultvisual( d2749, s2750 )
        TSCP  d2749, s2750;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3264 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2749 );
        X3 = POINTER_TSCP( XDefaultVisual( TSCP_POINTER( X1 ), 
                                           TSCP_INT( s2750 ) ) );
        X2 = sc_cons( c2757, X3 );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdisplaycells_v );
DEFSTRING( t3268, "XDISPLAYCELLS", 13 );
EXTERNINTP( XDisplayCells );

TSCP  xws2_xdisplaycells( d2764, s2765 )
        TSCP  d2764, s2765;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3268 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2764 );
        X2 = INT_TSCP( XDisplayCells( TSCP_POINTER( X1 ), 
                                      TSCP_INT( s2765 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdisplayplanes_v );
DEFSTRING( t3272, "XDISPLAYPLANES", 14 );
EXTERNINTP( XDisplayPlanes );

TSCP  xws2_xdisplayplanes( d2778, s2779 )
        TSCP  d2778, s2779;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3272 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2778 );
        X2 = INT_TSCP( XDisplayPlanes( TSCP_POINTER( X1 ), 
                                       TSCP_INT( s2779 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdisplaystring_v );
DEFSTRING( t3276, "XDISPLAYSTRING", 14 );
EXTERNTSCPP( scrt4_c_2dstring_2d_3estring );
EXTERNTSCP( scrt4_c_2dstring_2d_3estring_v );
EXTERNPOINTERP( XDisplayString );

TSCP  xws2_xdisplaystring( d2791 )
        TSCP  d2791;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3276 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2791 );
        X3 = POINTER_TSCP( XDisplayString( TSCP_POINTER( X1 ) ) );
        X2 = scrt4_c_2dstring_2d_3estring( X3 );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_tprocessed_c7616d50_v );
DEFSTRING( t3280, "XLASTKNOWNREQUESTPROCESSED", 26 );
EXTERNINTP( XLastKnownRequestProcessed );

TSCP  xws2_tprocessed_c7616d50( d2801 )
        TSCP  d2801;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3280 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2801 );
        X2 = INT_TSCP( XLastKnownRequestProcessed( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xnextrequest_v );
DEFSTRING( t3284, "XNEXTREQUEST", 12 );
EXTERNINTP( XNextRequest );

TSCP  xws2_xnextrequest( d2811 )
        TSCP  d2811;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3284 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2811 );
        X2 = INT_TSCP( XNextRequest( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xprotocolversion_v );
DEFSTRING( t3288, "XPROTOCOLVERSION", 16 );
EXTERNINTP( XProtocolVersion );

TSCP  xws2_xprotocolversion( d2821 )
        TSCP  d2821;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3288 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2821 );
        X2 = INT_TSCP( XProtocolVersion( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xprotocolrevision_v );
DEFSTRING( t3292, "XPROTOCOLREVISION", 17 );
EXTERNINTP( XProtocolRevision );

TSCP  xws2_xprotocolrevision( d2831 )
        TSCP  d2831;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3292 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2831 );
        X2 = INT_TSCP( XProtocolRevision( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xqlength_v );
DEFSTRING( t3296, "XQLENGTH", 8 );
EXTERNINTP( XQLength );

TSCP  xws2_xqlength( d2841 )
        TSCP  d2841;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3296 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2841 );
        X2 = INT_TSCP( XQLength( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xrootwindow_v );
DEFSTRING( t3300, "XROOTWINDOW", 11 );
EXTERNUNSIGNEDP( XRootWindow );

TSCP  xws2_xrootwindow( d2852, s2853 )
        TSCP  d2852, s2853;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3300 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2852 );
        X2 = UNSIGNED_TSCP( XRootWindow( TSCP_POINTER( X1 ), 
                                         TSCP_INT( s2853 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xscreencount_v );
DEFSTRING( t3304, "XSCREENCOUNT", 12 );
EXTERNINTP( XScreenCount );

TSCP  xws2_xscreencount( d2865 )
        TSCP  d2865;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3304 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2865 );
        X2 = INT_TSCP( XScreenCount( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xservervendor_v );
DEFSTRING( t3308, "XSERVERVENDOR", 13 );
EXTERNPOINTERP( XServerVendor );

TSCP  xws2_xservervendor( d2875 )
        TSCP  d2875;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3308 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2875 );
        X3 = POINTER_TSCP( XServerVendor( TSCP_POINTER( X1 ) ) );
        X2 = scrt4_c_2dstring_2d_3estring( X3 );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xvendorrelease_v );
DEFSTRING( t3312, "XVENDORRELEASE", 14 );
EXTERNINTP( XVendorRelease );

TSCP  xws2_xvendorrelease( d2885 )
        TSCP  d2885;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3312 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2885 );
        X2 = INT_TSCP( XVendorRelease( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_ximagebyteorder_v );
DEFSTRING( t3316, "XIMAGEBYTEORDER", 15 );
EXTERNINTP( XImageByteOrder );

TSCP  xws2_ximagebyteorder( d2895 )
        TSCP  d2895;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3316 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2895 );
        X2 = INT_TSCP( XImageByteOrder( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xbitmapunit_v );
DEFSTRING( t3320, "XBITMAPUNIT", 11 );
EXTERNINTP( XBitmapUnit );

TSCP  xws2_xbitmapunit( d2905 )
        TSCP  d2905;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3320 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2905 );
        X2 = INT_TSCP( XBitmapUnit( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xbitmapbitorder_v );
DEFSTRING( t3324, "XBITMAPBITORDER", 15 );
EXTERNINTP( XBitmapBitOrder );

TSCP  xws2_xbitmapbitorder( d2915 )
        TSCP  d2915;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3324 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2915 );
        X2 = INT_TSCP( XBitmapBitOrder( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xbitmappad_v );
DEFSTRING( t3328, "XBITMAPPAD", 10 );
EXTERNINTP( XBitmapPad );

TSCP  xws2_xbitmappad( d2925 )
        TSCP  d2925;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3328 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2925 );
        X2 = INT_TSCP( XBitmapPad( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdisplayheight_v );
DEFSTRING( t3332, "XDISPLAYHEIGHT", 14 );
EXTERNINTP( XDisplayHeight );

TSCP  xws2_xdisplayheight( d2936, s2937 )
        TSCP  d2936, s2937;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3332 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2936 );
        X2 = INT_TSCP( XDisplayHeight( TSCP_POINTER( X1 ), 
                                       TSCP_INT( s2937 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdisplayheightmm_v );
DEFSTRING( t3336, "XDISPLAYHEIGHTMM", 16 );
EXTERNINTP( XDisplayHeightMM );

TSCP  xws2_xdisplayheightmm( d2950, s2951 )
        TSCP  d2950, s2951;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3336 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2950 );
        X2 = INT_TSCP( XDisplayHeightMM( TSCP_POINTER( X1 ), 
                                         TSCP_INT( s2951 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdisplaywidth_v );
DEFSTRING( t3340, "XDISPLAYWIDTH", 13 );
EXTERNINTP( XDisplayWidth );

TSCP  xws2_xdisplaywidth( d2964, s2965 )
        TSCP  d2964, s2965;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3340 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2964 );
        X2 = INT_TSCP( XDisplayWidth( TSCP_POINTER( X1 ), 
                                      TSCP_INT( s2965 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdisplaywidthmm_v );
DEFSTRING( t3344, "XDISPLAYWIDTHMM", 15 );
EXTERNINTP( XDisplayWidthMM );

TSCP  xws2_xdisplaywidthmm( d2978, s2979 )
        TSCP  d2978, s2979;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3344 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d2978 );
        X2 = INT_TSCP( XDisplayWidthMM( TSCP_POINTER( X1 ), 
                                        TSCP_INT( s2979 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xblackpixelofscreen_v );
DEFSTRING( t3348, "XBLACKPIXELOFSCREEN", 19 );
EXTERNTSCPP( xlibtypes_chk_2dscreenp );
EXTERNTSCP( xlibtypes_chk_2dscreenp_v );
EXTERNINTP( XBlackPixelOfScreen );

TSCP  xws2_xblackpixelofscreen( s2991 )
        TSCP  s2991;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3348 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s2991 );
        X2 = INT_TSCP( XBlackPixelOfScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xwhitepixelofscreen_v );
DEFSTRING( t3352, "XWHITEPIXELOFSCREEN", 19 );
EXTERNINTP( XWhitePixelOfScreen );

TSCP  xws2_xwhitepixelofscreen( s3001 )
        TSCP  s3001;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3352 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3001 );
        X2 = INT_TSCP( XWhitePixelOfScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xcellsofscreen_v );
DEFSTRING( t3356, "XCELLSOFSCREEN", 14 );
EXTERNINTP( XCellsOfScreen );

TSCP  xws2_xcellsofscreen( s3011 )
        TSCP  s3011;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3356 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3011 );
        X2 = INT_TSCP( XCellsOfScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdefaultcolormapofscreen_v );
DEFSTRING( t3360, "XDEFAULTCOLORMAPOFSCREEN", 24 );
EXTERNUNSIGNEDP( XDefaultColormapOfScreen );

TSCP  xws2_xdefaultcolormapofscreen( s3021 )
        TSCP  s3021;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3360 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3021 );
        X2 = UNSIGNED_TSCP( XDefaultColormapOfScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdefaultdepthofscreen_v );
DEFSTRING( t3364, "XDEFAULTDEPTHOFSCREEN", 21 );
EXTERNINTP( XDefaultDepthOfScreen );

TSCP  xws2_xdefaultdepthofscreen( s3031 )
        TSCP  s3031;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3364 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3031 );
        X2 = INT_TSCP( XDefaultDepthOfScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdefaultgcofscreen_v );
DEFSTRING( t3368, "XDEFAULTGCOFSCREEN", 18 );
EXTERNPOINTERP( XDefaultGCOfScreen );

TSCP  xws2_xdefaultgcofscreen( s3041 )
        TSCP  s3041;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3368 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3041 );
        X3 = POINTER_TSCP( XDefaultGCOfScreen( TSCP_POINTER( X1 ) ) );
        X2 = sc_cons( c2697, X3 );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdefaultvisualofscreen_v );
DEFSTRING( t3372, "XDEFAULTVISUALOFSCREEN", 22 );
EXTERNPOINTERP( XDefaultVisualOfScreen );

TSCP  xws2_xdefaultvisualofscreen( s3051 )
        TSCP  s3051;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3372 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3051 );
        X3 = POINTER_TSCP( XDefaultVisualOfScreen( TSCP_POINTER( X1 ) ) );
        X2 = sc_cons( c2757, X3 );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdoesbackingstore_v );
DEFSTRING( t3376, "XDOESBACKINGSTORE", 17 );
EXTERNINTP( XDoesBackingStore );

TSCP  xws2_xdoesbackingstore( s3061 )
        TSCP  s3061;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3376 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3061 );
        X2 = INT_TSCP( XDoesBackingStore( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdoessaveunders_v );
DEFSTRING( t3380, "XDOESSAVEUNDERS", 15 );
EXTERNINTP( XDoesSaveUnders );

TSCP  xws2_xdoessaveunders( s3071 )
        TSCP  s3071;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3380 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3071 );
        X2 = INT_TSCP( XDoesSaveUnders( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xdisplayofscreen_v );
DEFSTRING( t3384, "XDISPLAYOFSCREEN", 16 );
EXTERNPOINTERP( XDisplayOfScreen );

TSCP  xws2_xdisplayofscreen( s3081 )
        TSCP  s3081;
{
        TSCP  X3, X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3384 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3081 );
        X3 = POINTER_TSCP( XDisplayOfScreen( TSCP_POINTER( X1 ) ) );
        X2 = sc_cons( c2606, X3 );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xeventmaskofscreen_v );
DEFSTRING( t3388, "XEVENTMASKOFSCREEN", 18 );
EXTERNINTP( XEventMaskOfScreen );

TSCP  xws2_xeventmaskofscreen( s3091 )
        TSCP  s3091;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3388 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3091 );
        X2 = INT_TSCP( XEventMaskOfScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xwidthofscreen_v );
DEFSTRING( t3392, "XWIDTHOFSCREEN", 14 );
EXTERNINTP( XWidthOfScreen );

TSCP  xws2_xwidthofscreen( s3101 )
        TSCP  s3101;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3392 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3101 );
        X2 = INT_TSCP( XWidthOfScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xheightofscreen_v );
DEFSTRING( t3396, "XHEIGHTOFSCREEN", 15 );
EXTERNINTP( XHeightOfScreen );

TSCP  xws2_xheightofscreen( s3111 )
        TSCP  s3111;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3396 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3111 );
        X2 = INT_TSCP( XHeightOfScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xwidthmmofscreen_v );
DEFSTRING( t3400, "XWIDTHMMOFSCREEN", 16 );
EXTERNINTP( XWidthMMOfScreen );

TSCP  xws2_xwidthmmofscreen( s3121 )
        TSCP  s3121;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3400 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3121 );
        X2 = INT_TSCP( XWidthMMOfScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xheightmmofscreen_v );
DEFSTRING( t3404, "XHEIGHTMMOFSCREEN", 17 );
EXTERNINTP( XHeightMMOfScreen );

TSCP  xws2_xheightmmofscreen( s3131 )
        TSCP  s3131;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3404 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3131 );
        X2 = INT_TSCP( XHeightMMOfScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xmaxcmapsofscreen_v );
DEFSTRING( t3408, "XMAXCMAPSOFSCREEN", 17 );
EXTERNINTP( XMaxCmapsOfScreen );

TSCP  xws2_xmaxcmapsofscreen( s3141 )
        TSCP  s3141;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3408 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3141 );
        X2 = INT_TSCP( XMaxCmapsOfScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xmincmapsofscreen_v );
DEFSTRING( t3412, "XMINCMAPSOFSCREEN", 17 );
EXTERNINTP( XMinCmapsOfScreen );

TSCP  xws2_xmincmapsofscreen( s3151 )
        TSCP  s3151;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3412 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3151 );
        X2 = INT_TSCP( XMinCmapsOfScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xplanesofscreen_v );
DEFSTRING( t3416, "XPLANESOFSCREEN", 15 );
EXTERNINTP( XPlanesOfScreen );

TSCP  xws2_xplanesofscreen( s3161 )
        TSCP  s3161;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3416 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3161 );
        X2 = INT_TSCP( XPlanesOfScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xrootwindowofscreen_v );
DEFSTRING( t3420, "XROOTWINDOWOFSCREEN", 19 );
EXTERNUNSIGNEDP( XRootWindowOfScreen );

TSCP  xws2_xrootwindowofscreen( s3171 )
        TSCP  s3171;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3420 ) ) );
        X1 = xlibtypes_chk_2dscreenp( s3171 );
        X2 = UNSIGNED_TSCP( XRootWindowOfScreen( TSCP_POINTER( X1 ) ) );
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xnoop_v );
DEFSTRING( t3424, "XNOOP", 5 );
EXTERNVOIDP( XNoOp );

TSCP  xws2_xnoop( d3181 )
        TSCP  d3181;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3424 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3181 );
        XNoOp( TSCP_POINTER( X1 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

DEFTSCP( xws2_xfree_v );
DEFSTRING( t3429, "XFREE", 5 );
EXTERNVOIDP( XFree );

TSCP  xws2_xfree( d3192 )
        TSCP  d3192;
{
        TSCP  X1;

        PUSHSTACKTRACE( U_TX( ADR( t3429 ) ) );
        XFree( TSCP_UNSIGNED( d3192 ) );
        X1 = FALSEVALUE;
        POPSTACKTRACE( X1 );
}

DEFTSCP( xws2_xclosedisplay_v );
DEFSTRING( t3433, "XCLOSEDISPLAY", 13 );
EXTERNVOIDP( XCloseDisplay );

TSCP  xws2_xclosedisplay( d3203 )
        TSCP  d3203;
{
        TSCP  X2, X1;

        PUSHSTACKTRACE( U_TX( ADR( t3433 ) ) );
        X1 = xlibtypes_chk_2ddisplayp( d3203 );
        XCloseDisplay( TSCP_POINTER( X1 ) );
        X2 = FALSEVALUE;
        POPSTACKTRACE( X2 );
}

static void  init_modules( compiler_version )
        char *compiler_version;
{
        scrt4__init();
        xlibtypes__init();
        scrt6__init();
        MAXDISPLAY( 0 );
}

void  xws2__init()
{
        static int  init = 0;
        if  (init)  return;
        init = 1;
        INITHEAP( 0, 0, 0, 0 );
        init_constants();
        init_modules( "(xws2 SCHEME->C COMPILER 01nov91jfb)" );
        INITIALIZEVAR( U_TX( ADR( t3215 ) ), 
                       ADR( xws2_xopendisplay_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xopendisplay, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3221 ) ), 
                       ADR( xws2_xallplanes_v ), 
                       MAKEPROCEDURE( 0, 
                                      0, 
                                      xws2_xallplanes, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3224 ) ), 
                       ADR( xws2_xblackpixel_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws2_xblackpixel, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3228 ) ), 
                       ADR( xws2_xwhitepixel_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws2_xwhitepixel, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3232 ) ), 
                       ADR( xws2_xconnectionnumber_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xconnectionnumber, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3236 ) ), 
                       ADR( xws2_xdefaultcolormap_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws2_xdefaultcolormap, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3240 ) ), 
                       ADR( xws2_xdefaultdepth_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws2_xdefaultdepth, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3244 ) ), 
                       ADR( xws2_xdefaultgc_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws2_xdefaultgc, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3248 ) ), 
                       ADR( xws2_xdefaultrootwindow_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xdefaultrootwindow, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3252 ) ), 
                       ADR( xws2_xdefaultscreenofdisplay_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xdefaultscreenofdisplay, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3256 ) ), 
                       ADR( xws2_xscreenofdisplay_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws2_xscreenofdisplay, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3260 ) ), 
                       ADR( xws2_xdefaultscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xdefaultscreen, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3264 ) ), 
                       ADR( xws2_xdefaultvisual_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws2_xdefaultvisual, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3268 ) ), 
                       ADR( xws2_xdisplaycells_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws2_xdisplaycells, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3272 ) ), 
                       ADR( xws2_xdisplayplanes_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws2_xdisplayplanes, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3276 ) ), 
                       ADR( xws2_xdisplaystring_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xdisplaystring, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3280 ) ), 
                       ADR( xws2_tprocessed_c7616d50_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_tprocessed_c7616d50, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3284 ) ), 
                       ADR( xws2_xnextrequest_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xnextrequest, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3288 ) ), 
                       ADR( xws2_xprotocolversion_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xprotocolversion, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3292 ) ), 
                       ADR( xws2_xprotocolrevision_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xprotocolrevision, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3296 ) ), 
                       ADR( xws2_xqlength_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, xws2_xqlength, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3300 ) ), 
                       ADR( xws2_xrootwindow_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws2_xrootwindow, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3304 ) ), 
                       ADR( xws2_xscreencount_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xscreencount, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3308 ) ), 
                       ADR( xws2_xservervendor_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xservervendor, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3312 ) ), 
                       ADR( xws2_xvendorrelease_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xvendorrelease, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3316 ) ), 
                       ADR( xws2_ximagebyteorder_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_ximagebyteorder, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3320 ) ), 
                       ADR( xws2_xbitmapunit_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xbitmapunit, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3324 ) ), 
                       ADR( xws2_xbitmapbitorder_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xbitmapbitorder, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3328 ) ), 
                       ADR( xws2_xbitmappad_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xbitmappad, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3332 ) ), 
                       ADR( xws2_xdisplayheight_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws2_xdisplayheight, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3336 ) ), 
                       ADR( xws2_xdisplayheightmm_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws2_xdisplayheightmm, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3340 ) ), 
                       ADR( xws2_xdisplaywidth_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws2_xdisplaywidth, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3344 ) ), 
                       ADR( xws2_xdisplaywidthmm_v ), 
                       MAKEPROCEDURE( 2, 
                                      0, 
                                      xws2_xdisplaywidthmm, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3348 ) ), 
                       ADR( xws2_xblackpixelofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xblackpixelofscreen, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3352 ) ), 
                       ADR( xws2_xwhitepixelofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xwhitepixelofscreen, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3356 ) ), 
                       ADR( xws2_xcellsofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xcellsofscreen, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3360 ) ), 
                       ADR( xws2_xdefaultcolormapofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xdefaultcolormapofscreen, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3364 ) ), 
                       ADR( xws2_xdefaultdepthofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xdefaultdepthofscreen, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3368 ) ), 
                       ADR( xws2_xdefaultgcofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xdefaultgcofscreen, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3372 ) ), 
                       ADR( xws2_xdefaultvisualofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xdefaultvisualofscreen, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3376 ) ), 
                       ADR( xws2_xdoesbackingstore_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xdoesbackingstore, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3380 ) ), 
                       ADR( xws2_xdoessaveunders_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xdoessaveunders, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3384 ) ), 
                       ADR( xws2_xdisplayofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xdisplayofscreen, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3388 ) ), 
                       ADR( xws2_xeventmaskofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xeventmaskofscreen, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3392 ) ), 
                       ADR( xws2_xwidthofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xwidthofscreen, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3396 ) ), 
                       ADR( xws2_xheightofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xheightofscreen, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3400 ) ), 
                       ADR( xws2_xwidthmmofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xwidthmmofscreen, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3404 ) ), 
                       ADR( xws2_xheightmmofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xheightmmofscreen, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3408 ) ), 
                       ADR( xws2_xmaxcmapsofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xmaxcmapsofscreen, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3412 ) ), 
                       ADR( xws2_xmincmapsofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xmincmapsofscreen, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3416 ) ), 
                       ADR( xws2_xplanesofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xplanesofscreen, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3420 ) ), 
                       ADR( xws2_xrootwindowofscreen_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xrootwindowofscreen, 
                                      EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3424 ) ), 
                       ADR( xws2_xnoop_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, xws2_xnoop, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3429 ) ), 
                       ADR( xws2_xfree_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, xws2_xfree, EMPTYLIST ) );
        INITIALIZEVAR( U_TX( ADR( t3433 ) ), 
                       ADR( xws2_xclosedisplay_v ), 
                       MAKEPROCEDURE( 1, 
                                      0, 
                                      xws2_xclosedisplay, EMPTYLIST ) );
        return;
}
