(module screen)
(include "xlibTYPES.sch")
(DEFINE (MAKE-SCREEN) (CONS 'SCREENP (MAKE-STRING 80 (INTEGER->CHAR 0))))
(DEFINE
  (SCREEN-EXT_DATA X)
  ((LAMBDA (X Y) (CONS 'XEXTDATAP (C-UNSIGNED-REF X Y)))
    (CHK-SCREENP X)
    0))
(DEFINE
  (SCREEN-EXT_DATA! X Y)
  ((LAMBDA (X Y Z) (C-UNSIGNED-SET! X Y (CHK-XEXTDATAP Z))) (CHK-SCREENP X) 0 Y))
(DEFINE
  (SCREEN-DISPLAY X)
  ((LAMBDA (X Y) (CONS 'DISPLAYP (C-UNSIGNED-REF X Y)))
    (CHK-SCREENP X)
    4))
(DEFINE
  (SCREEN-DISPLAY! X Y)
  ((LAMBDA (X Y Z) (C-UNSIGNED-SET! X Y (CHK-DISPLAYP Z))) (CHK-SCREENP X) 4 Y))
(DEFINE (SCREEN-ROOT X) (C-UNSIGNED-REF (CHK-SCREENP X) 8))
(DEFINE (SCREEN-ROOT! X Y) (C-UNSIGNED-SET! (CHK-SCREENP X) 8 Y))
(DEFINE (SCREEN-WIDTH X) (C-INT-REF (CHK-SCREENP X) 12))
(DEFINE (SCREEN-WIDTH! X Y) (C-INT-SET! (CHK-SCREENP X) 12 Y))
(DEFINE (SCREEN-HEIGHT X) (C-INT-REF (CHK-SCREENP X) 16))
(DEFINE (SCREEN-HEIGHT! X Y) (C-INT-SET! (CHK-SCREENP X) 16 Y))
(DEFINE (SCREEN-MWIDTH X) (C-INT-REF (CHK-SCREENP X) 20))
(DEFINE (SCREEN-MWIDTH! X Y) (C-INT-SET! (CHK-SCREENP X) 20 Y))
(DEFINE (SCREEN-MHEIGHT X) (C-INT-REF (CHK-SCREENP X) 24))
(DEFINE (SCREEN-MHEIGHT! X Y) (C-INT-SET! (CHK-SCREENP X) 24 Y))
(DEFINE (SCREEN-NDEPTHS X) (C-INT-REF (CHK-SCREENP X) 28))
(DEFINE (SCREEN-NDEPTHS! X Y) (C-INT-SET! (CHK-SCREENP X) 28 Y))
(DEFINE
  (SCREEN-DEPTHS X)
  ((LAMBDA (X Y) (CONS 'DEPTHP (C-UNSIGNED-REF X Y))) (CHK-SCREENP X) 32))
(DEFINE
  (SCREEN-DEPTHS! X Y)
  ((LAMBDA (X Y Z) (C-UNSIGNED-SET! X Y (CHK-DEPTHP Z))) (CHK-SCREENP X) 32 Y))
(DEFINE (SCREEN-ROOT_DEPTH X) (C-INT-REF (CHK-SCREENP X) 36))
(DEFINE (SCREEN-ROOT_DEPTH! X Y) (C-INT-SET! (CHK-SCREENP X) 36 Y))
(DEFINE
  (SCREEN-ROOT_VISUAL X)
  ((LAMBDA (X Y) (CONS 'VISUALP (C-UNSIGNED-REF X Y)))
    (CHK-SCREENP X)
    40))
(DEFINE
  (SCREEN-ROOT_VISUAL! X Y)
  ((LAMBDA (X Y Z) (C-UNSIGNED-SET! X Y (CHK-VISUALP Z))) (CHK-SCREENP X) 40 Y))
(DEFINE
  (SCREEN-DEFAULT_GC X)
  ((LAMBDA (X Y) (CONS 'GC (C-UNSIGNED-REF X Y))) (CHK-SCREENP X) 44))
(DEFINE
  (SCREEN-DEFAULT_GC! X Y)
  ((LAMBDA (X Y Z) (C-UNSIGNED-SET! X Y (CHK-GC Z))) (CHK-SCREENP X) 44 Y))
(DEFINE (SCREEN-CMAP X) (C-UNSIGNED-REF (CHK-SCREENP X) 48))
(DEFINE (SCREEN-CMAP! X Y) (C-UNSIGNED-SET! (CHK-SCREENP X) 48 Y))
(DEFINE (SCREEN-WHITE_PIXEL X) (C-UNSIGNED-REF (CHK-SCREENP X) 52))
(DEFINE (SCREEN-WHITE_PIXEL! X Y) (C-UNSIGNED-SET! (CHK-SCREENP X) 52 Y))
(DEFINE (SCREEN-BLACK_PIXEL X) (C-UNSIGNED-REF (CHK-SCREENP X) 56))
(DEFINE (SCREEN-BLACK_PIXEL! X Y) (C-UNSIGNED-SET! (CHK-SCREENP X) 56 Y))
(DEFINE (SCREEN-MAX_MAPS X) (C-INT-REF (CHK-SCREENP X) 60))
(DEFINE (SCREEN-MAX_MAPS! X Y) (C-INT-SET! (CHK-SCREENP X) 60 Y))
(DEFINE (SCREEN-MIN_MAPS X) (C-INT-REF (CHK-SCREENP X) 64))
(DEFINE (SCREEN-MIN_MAPS! X Y) (C-INT-SET! (CHK-SCREENP X) 64 Y))
(DEFINE (SCREEN-BACKING_STORE X) (C-INT-REF (CHK-SCREENP X) 68))
(DEFINE (SCREEN-BACKING_STORE! X Y) (C-INT-SET! (CHK-SCREENP X) 68 Y))
(DEFINE (SCREEN-SAVE_UNDERS X) (C-INT-REF (CHK-SCREENP X) 72))
(DEFINE (SCREEN-SAVE_UNDERS! X Y) (C-INT-SET! (CHK-SCREENP X) 72 Y))
(DEFINE (SCREEN-ROOT_INPUT_MASK X) (C-INT-REF (CHK-SCREENP X) 76))
(DEFINE (SCREEN-ROOT_INPUT_MASK! X Y) (C-INT-SET! (CHK-SCREENP X) 76 Y))
