;;; The module interfaces for scsh.
;;; Copyright (c) 1994 by Olin Shivers and David Albertz.
;;; Copyright (c) 1994 by Brian D. Carlstrom

(define-interface posix-fdflags-interface
  (export open/read
	  open/write
	  open/read+write
	  open/nonblocking
	  open/append
	  open/no-control-tty
	  open/create
	  open/truncate
	  open/exclusive
	  open/access-mask
	  fcntl/close-on-exec
	  fcntl/dupfd
	  fcntl/get-fd-flags
	  fcntl/set-fd-flags
	  fcntl/get-file-flags
	  fcntl/set-file-flags
	  fcntl/get-record-lock
	  fcntl/set-record-lock
	  fcntl/record-lock
	  lock/read
	  lock/write
	  lock/release))

(define-interface posix-errno-interface
  (export errno/2big
	  errno/acces
	  errno/again
	  errno/badf
	  errno/busy
	  errno/child
	  errno/deadlk
	  errno/dom
	  errno/exist
	  errno/fault
	  errno/fbig
	  errno/intr
	  errno/inval
	  errno/io
	  errno/isdir
	  errno/mfile
	  errno/mlink
	  errno/nametoolong
	  errno/nfile
	  errno/nodev
	  errno/noent
	  errno/noexec
	  errno/nolck
	  errno/nomem
	  errno/nospc
	  errno/nosys
	  errno/notdir
	  errno/notempty
	  errno/notty
	  errno/nxio
	  errno/perm
	  errno/pipe
	  errno/range
	  errno/rofs
	  errno/spipe
	  errno/srch
	  errno/xdev))


(define-interface posix-signals-interface
  (export signal/abrt
	  signal/alrm
	  signal/chld
	  signal/cont
	  signal/fpe
	  signal/hup
	  signal/ill
	  signal/int
	  signal/kill
	  signal/pipe
	  signal/quit
	  signal/segv
	  signal/stop
	  signal/term
	  signal/tstp
	  signal/ttin
	  signal/ttou
	  signal/usr1
	  signal/usr2))

(define-interface scsh-errors-interface
  (export errno-error
	  error
	  with-errno-handler*
	  (with-errno-handler :syntax)))


(define-interface scsh-io-interface
  (export close
	  close-after
	  error-output-port
	  dup
	  dup->inport
	  dup->outport
	  dup->fdes
	  seek/set
	  seek/delta
	  seek/end
	  file-seek
	  open-file
	  force-output
	  flush-all-ports
	  y-or-n?
	  *y-or-n-eof-count*
	  ;; R4RS I/O procedures that scsh provides.
	  write
	  char-ready?
	  read-char
	  write-char
	  display
	  newline
	  input-port?
	  output-port?
	  call-with-input-file
	  call-with-output-file
	  with-input-from-file
	  with-output-to-file
	  open-input-file
	  open-output-file
	  format

	  with-current-input-port*
	  (with-current-input-port :syntax)
	  with-current-output-port*
	  (with-current-output-port :syntax)
	  with-error-output-port*
	  (with-error-output-port :syntax)
	  call/fdes
	  release-port-handle
	  port-revealed
	  fdes->inport
	  fdes->outport
	  move->fdes
	  open-fdes
	  pipe
	  port->string
	  port->sexp-list
	  port->string-list
	  port->list
	  reduce-port
	  port->fdes
	  stdports->stdio
	  stdio->stdports
	  read-string
	  read-string!
	  read-string/partial
	  read-string!/partial
	  write-string
	  write-string/partial))


(define-interface scsh-file-interface
  (export create-directory
	  create-fifo
	  create-hard-link
	  create-symlink

	  delete-directory
	  delete-file
	  delete-filesys-object
	  rename-file
	  set-file-mode
	  set-file-owner
	  set-file-group
	  truncate-file

	  read-symlink			; Not POSIX.

	  file-attributes
	  file-info:type
	  file-info:device
	  file-info:inode
	  file-info:mode
	  file-info:nlinks
	  file-info:uid
	  file-info:gid
	  file-info:size
	  file-info:atime
	  file-info:mtime
	  file-info:ctime
	  file-type
	  file-group
	  file-inode
	  file-last-access
	  file-last-mod
	  file-last-status-change
	  file-mode
	  file-nlinks
	  file-owner
	  file-size
	  file-symlink?
	  file-directory?
	  file-fifo?
	  file-regular?
	  file-socket?
	  file-special?
	  file-not-readable?
	  file-not-writeable?
	  file-not-executable?
	  file-readable?
	  file-writeable?
	  file-executable?
	  file-not-exists?
	  file-exists?

	  sync-file
	  sync-file-system

	  directory-files
	  glob
	  glob-quote
	  file-match

	  create-temp-file
	  temp-file-iterate
	  temp-file-channel
	  *temp-file-template*))


(define-interface scsh-process-interface
  (export exec
	  exec-path
	  exec/env
	  exec-path/env
	  %exec
	  exec-path-search

	  exit
	  %exit

	  suspend

	  fork
	  %fork

	  wait
	  wait-all
	  wait-pid/no-reap
	  status:exit-val
	  status:stop-sig
	  status:term-sig
	  wait/poll
	  wait/stopped-children

	  call-terminally
	  halts?))


(define-interface scsh-process-state-interface
  (export umask
	  set-umask
	  with-umask*
	  (with-umask :syntax)

	  chdir
	  cwd
	  with-cwd*
	  (with-cwd :syntax)

	  pid
	  parent-pid
	  process-group
	  set-process-group

	  user-login-name
	  user-uid
	  user-effective-uid
	  user-gid
	  user-effective-gid
	  user-supplementary-gids
	  set-uid
	  set-gid

	  system-name
	  process-times))


(define-interface scsh-user/group-db-interface
  (export user-info
	  user-info:name
	  user-info:uid
	  user-info:gid
	  user-info:home-dir
	  user-info:shell

	  ->uid
	  ->username

	  group-info
	  group-info:name
	  group-info:gid
	  group-info:members

	  ->gid
	  ->groupname))


(define-interface scsh-command-line-interface
  (export command-line-arguments
	  command-line
	  arg
	  arg*
	  argv))


(define-interface scsh-signals-interface
  (export signal-process
	  signal-procgroup
	  pause-until-interrupt
	  sleep
	  itimer))


(define-interface scsh-environment-interface
  (export setenv
	  getenv
	  env->alist
	  alist->env
	  alist-delete
	  alist-update
	  alist-compress
	  with-env*
	  with-total-env*
	  (with-env :syntax)
	  (with-total-env :syntax)
	  add-before
	  add-after))


(define-interface scsh-home-interface
  (export home-directory
	  exec-path-list))


(define-interface scsh-regexp-interface
  (export string-match
	  regexp-match?
	  match:start
	  match:end
	  match:substring
	  make-regexp
	  regexp?
	  regexp-exec
	  regexp-quote))


(define-interface scsh-string-interface
  (compound-interface (export substitute-env-vars
			      index
			      rindex)
		      scsh-regexp-interface))


(define-interface scsh-file-names-interface
  (export file-name-as-directory
	  directory-as-file-name
	  file-name-absolute?
	  file-name-directory
	  file-name-nondirectory
	  split-file-name
	  path-list->file-name
	  file-name-extension
	  file-name-sans-extension
	  replace-extension
	  parse-file-name
	  expand-file-name
	  simplify-file-name
	  resolve-tilde-file-name
	  resolve-file-name
	  home-dir
	  home-file))


(define-interface scsh-time-interface
  (export make-date
	  date?

	  date:seconds
	  date:minute	
	  date:hour   	
	  date:month-day	
	  date:month   	
	  date:year    	
	  date:tz-name	
	  date:tz-secs	
	  date:summer?	
	  date:week-day	
	  date:year-day

	  set-date:seconds
	  set-date:minute	
	  set-date:hour   	
	  set-date:month-day	
	  set-date:month   	
	  set-date:year    	
	  set-date:tz-name	
	  set-date:tz-secs	
	  set-date:summer?	
	  set-date:week-day	
	  set-date:year-day

	  time+ticks
	  ticks/sec
	  time
	  date
	  date->string
	  format-date))
	  

(define-interface scsh-misc-interface
  (export (receive :syntax)

	  arithmetic-shift
	  bitwise-and
	  bitwise-ior
	  bitwise-not
	  bitwise-xor

	  repl))	; Don't know where else to put it.


(define-interface scsh-high-level-process-interface
  (export (run :syntax)
	  (exec-epf :syntax)
	  (& :syntax)
	  (||		  :syntax)
;	  (:or:           :syntax)	; Alternate R4RS syntax for ||.
	  (&&             :syntax)
	  (run/collecting :syntax)
	  (run/port+pid   :syntax)
	  (run/port       :syntax)
	  (run/strings    :syntax)
	  (run/file       :syntax)
	  (run/string     :syntax)
	  (run/sexp       :syntax)
	  (run/sexps      :syntax)
	  (run/pty        :syntax)

	  fork/pipe
	  %fork/pipe
	  fork/pipe+
	  %fork/pipe+
	  tail-pipe
	  tail-pipe+
	  run/collecting*
	  run/port+pid*
	  run/port*
	  run/pty*
	  run/file*
	  run/string*
	  run/sexp*
	  run/sexps*
	  run/strings*

	  char-filter
	  string-filter))


(define-interface scsh-starter-interface
  (export init-scsh
	  make-scsh-starter
	  dump-scsh-program
	  dump-scsh))


;;; This is probably bogus.
(define-interface string-ports-interface
  (export make-string-input-port
          call-with-string-output-port
	  make-string-output-port
	  string-output-port-output))


(define-interface scsh-utilities-interface
  (export del delete index rindex reduce filter first any first? nth
	  any? every? mapv mapv! optional-arg optional-arg* parse-optionals
	  check-arg conjoin disjoin negate compose reverse! call/cc
	  deposit-bit-field))

;;; semi-standard network magic numbers
;;; should be available on all platforms
;;; if not, tell us, and we'll move it
;;; to the os-dependent directory

;;; for now, all socket option magic numbers
;;; are considered machine dependent until
;;; there is a standard or a clear portable subset

(define-interface sockets-network-interface
  (export shutdown/receives
	  shutdown/sends
	  shutdown/sends+receives
	  herror/host-not-found
	  herror/try-again
	  herror/no-recovery
	  herror/no-data
	  herror/no-address
	  address-family/unspecified
	  address-family/unix
	  address-family/internet
	  socket-type/stream
	  socket-type/datagram
	  socket-type/raw
	  ;;socket-type/rdm
	  ;;socket-type/seqpacket
	  protocol-family/unspecified
	  protocol-family/unix
	  protocol-family/internet
	  internet-address/any
	  internet-address/loopback
	  internet-address/broadcast
	  message/out-of-band
	  message/peek
	  message/dont-route
	  level/socket
	  options/boolean
	  options/value
	  options/linger
	  options/timeout))

;;; actual functions interface
(define-interface scsh-sockets-interface
  (export socket-connect
	  bind-listen-accept-loop
	  socket?
	  socket:family
	  socket:inport
	  socket:outport
	  socket-address?   
	  socket-address:family
	  internet-address->socket-address
	  socket-address->internet-address
	  unix-address->socket-address
	  socket-address->unix-address
	  create-socket
	  close-socket
	  bind-socket
	  connect-socket
	  listen-socket
	  accept-connection
	  socket-remote-address
	  socket-local-address
	  shutdown-socket
	  create-socket-pair
	  receive-message
	  receive-message!
	  receive-message/partial
	  receive-message!/partial
	  send-message
	  send-message/partial
	  socket-option
	  set-socket-option

	  host-info
	  host-info?
	  host-info:name
	  host-info:aliases
	  host-info:addresses
	  network-info
	  network-info?
	  network-info:name
	  network-info:aliases
	  network-info:net
	  service-info
	  service-info?
	  service-info:name
	  service-info:aliases
	  service-info:port
	  service-info:protocol
	  protocol-info
	  protocol-info?
	  protocol-info:name
	  protocol-info:aliases
	  protocol-info:number
	  ))


(define-interface char-set-interface
  (export char:newline char:tab char:linefeed char:page char:return char:space
	  char-ascii?
	  char-set?

	  char-set
	  chars->char-set
	  string->char-set
	  ascii-range->char-set
	  predicate->char-set

	  char-set-members
	  char-set-member?

	  char-set-invert
	  char-set-union
	  char-set-intersection
	  char-set-difference

	  char-set:upper-case
	  char-set:lower-case
	  char-set:numeric
	  char-set:whitespace
	  char-set:not-whitespace
	  char-set:alphabetic
	  char-set:alphanumeric
	  char-set:graphic

	  char-upper-case?
	  char-lower-case?
	  char-numeric?
	  char-whitespace?
	  char-alphabetic?
	  char-alphanumeric?
	  char-graphic?))


(define-interface scsh-field-reader-interface
  (export join-strings
	  field-splitter infix-splitter suffix-splitter sloppy-suffix-splitter
	  read-delimited read-delimited!
	  record-reader
	  read-paragraph
	  field-reader
	  read-line
	  nth))		; Kinda handy.

(define-interface awk-interface
  (export (awk :syntax)))
