/* Scheme48 interface to Henry Spencer's regular expression package.
** Copyright (c) 1993, 1994 by Olin Shivers.
*/

#include <stdlib.h>
#include "regexp.h"
#include "cstuff.h"

#ifndef NULL
#define NULL 0
#endif

/* Not multi-threaded reentrant. */
static char *regexp_error;

/* Stash error msg in global. */
void regerror(char *msg) {regexp_error = msg;}

/* Return NULL normally, error string on error.
** Stash match info in start_vec and end_vec.
** Returns boolean match/no-match in hit.
*/

char *reg_match(char *re, char *string, int start,
		scheme_value start_vec, scheme_value end_vec,  int *hit)
{
    regexp *prog = regcomp(re);
    int status;

    *hit = 0;
    if( !prog ) return regexp_error;

    if( VECTOR_LENGTH(start_vec) != NSUBEXP ) {
	Free(prog);
	return "Illegal start vector";
	}
    
    if( VECTOR_LENGTH(end_vec) != NSUBEXP ) {
	Free(prog);
	return "Illegal end vector";
	}

    regexp_error = "";
    if( regexec(prog, string+start) ) {
	int i;
	for(i=0; i<NSUBEXP; i++) {
	    VECTOR_REF(start_vec,i) = ENTER_FIXNUM(prog->startp[i] - string);
	    VECTOR_REF(end_vec,i)   = ENTER_FIXNUM(prog->endp[i]   - string);
	    }
	*hit = 1;
	}
    
    Free(prog);
    return regexp_error;
    }


char *filter_stringvec(char *re, char **stringvec,  int *nummatch)
{
    regexp *prog = regcomp(re);
    char **p = stringvec;
    char **q = p;
    
    if( !prog ) return regexp_error;

    while(*p) {
	if( regexec(prog, *p) ) *q++ = *p;
	p++;
	}

    Free(prog);
    *nummatch = q-stringvec;
    return "";
    }
