;;; Flags for open(2) and fcntl(2).
;;; Copyright (c) 1993 by Olin Shivers.

(define-syntax define-open-flags
  (syntax-rules ()
    ((define-opens form ...)
     (begin (define-enum-constant "open" . form) ...))))

(define-open-flags
  ;; POSIX
  (read			0)
  (write		1)
  (read+write		2)
  (nonblocking		#o200000)
  (append		#o10)
  (no-control-tty	#o400000)
  (create		#o0400)
  (truncate		#o1000)
  (exclusive		#o2000)

  ;; NextStep
  (sync		#o100000))	; Synchronous writes

(define open/access-mask
  (bitwise-ior open/read
	       (bitwise-ior open/write open/read+write)))

;;; These are internal; they are not part of the supported scsh interface.

(define fcntl/close-on-exec 	1)

(define fcntl/dupfd		0)
(define fcntl/get-fd-flags	1)
(define fcntl/set-fd-flags	2)
(define fcntl/get-file-flags	3)
(define fcntl/set-file-flags	4)
(define fcntl/get-record-lock	5)	; F_GETLK
(define fcntl/set-record-lock	6)	; F_SETLK
(define fcntl/record-lock	7)	; F_SETLKW

(define lock/read	1)	; F_RDLCK
(define lock/write	2)	; F_WRLCK
(define lock/release	3)	' F_UNLCK
