;(eval-when (compile) (proclaim '(optimize (speed 3) (safety 0) (space 2))))

; Error handler for the virtual [Scheme] machine Version 1
(proclaim '(special *error* *error-data* *error-res*))

(defun scherror (x)
        (standardprint "[")
	(standardprint x)
	(cond
	    ((equal x "Bad vsm opcode")
	     (standardprint " ")
	     (standardprint *error*))
	    ((equal x "Process ran out") t)
	    ((equal x "Bad function")
	     (standardprint " ")
	     (standardprint *error-data*))
	    ((equal x "Wrong number of arguments to closure")
	     (new-line schpoport)
	     (standardprint "Formal parameters: ")
	     (standardprint (cadr (cadr *error-res*)))
	     (new-line schpoport) (standardprint "Actual parameters: ")
	     (standardprint *error-data*))
	    ((equal x "Wrong number of arguments to engine")
	     (new-line schpoport)
	     (standardprint "Formal parameters: ")
	     (standardprint '(ticks success-function failure-function))
	     (new-line schpoport)
	     (standardprint "Actual parameters: ")
	     (standardprint *error-data*))
	    ((equal x "Wrong number of arguments to state")
	     (new-line schpoport)
	     (standardprint "Formal parameters: ")
	     (standardprint '())
	     (new-line schpoport)
	     (standardprint "Actual parameters: ")
	     (standardprint *error-data*))
	    ((equal x "Wrong number of arguments to vector")
	     (new-line schpoport)
	     (standardprint "Arguments: ")
	     (standardprint *error-data*))
	    ((equal x "Wrong number of arguments to continuation")
	     (new-line schpoport)
	     (standardprint "Actual parameters: ")
	     (standardprint *error-data*))
	    ((equal x "Unassigned identifier:")
	     (standardprint " ")
	     (standardprint *error-data*))
	    ((equal x "Bad primitive class")
	     (standardprint "  ")
	     (standardprint *error*))
	    ((equal x "Bad primitive op") 
	     (standardprint "  ")
	     (standardprint *error*) t))
	(standardprint "]")
	(new-line schpoport)
;	(lisp-debug)
	(reset))
