/* basic object class */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#include "fools.h"
#include "codegen.h"
#include "cont.h"

#ifndef lint
static char SccsId[] = "@(#)Basic.c	1.7 1/16/90";
#endif

/* check if obj is of type class or a subclass of class */
Boolean objIsClass(obj, class)
     Obj obj;
     Class class;
{
    Class type;
    
    for (type = CLASS(obj); type != (Class)NULL; type = type->super)
	if (type == class) return TRUE;
    return FALSE;
}

/* dispatch functions for basic methods */

void objPrint(obj, file)
     Obj obj;
     FILE *file;
{
    F_VOID printer;

    if (printer = CLASS(obj)->print)
	(*printer)(obj, file);
    else {
	char *type = CLASS(obj)->type;
	(void)fprintf(file, "#<%s %#lx>", type, (long)obj);
    }
    if (ferror(file))
	errorPrint(BadWrite, "for file descriptor %d", fileno(file));
}

void objDestroy(obj)
     Obj obj;
{
    Class type;
    F_VOID destroy;

#ifdef DEBUG
    if (debugDestroy) objPrintf("destroying %O\n", obj);
#endif /* DEBUG */

    for (type = CLASS(obj); type != (Class)NULL; type = type->super)
	if ((destroy = type->destroy) != (F_VOID)NULL) (*destroy)(obj);
    gcFree(obj);
}

void _objLink(obj)
     Obj obj;
{
    LINK(obj);
}

void _objUnlink(obj)
     Obj obj;
{
    UNLINK(obj);
}

Obj typeSym(type)
     Class type;
{
    Obj sym;

    if (sym = type->typesym) return sym;
    return type->typesym = objIntern(type->type, STATIC);
}

Obj objType(obj)
     Obj obj;
{
    return typeSym(CLASS(obj));
}

/* basic class var */
basicClass_t protoBasic =
    DEFBASIC(NULL, basicInst_t, (F_VOID)NULL, (F_VOID)NULL, "basic");
