/* routines to manipulate a heap of fixed size blocks */

#ifndef lint
static char SccsId[] = "@(#)memory.c	1.4 3/2/90";
#endif

#include <stdio.h>
#include "memory.h"

extern char *malloc();

/* Add mem->heapsize blocks of size mem->blksize to mem */
void memExtend(mem)
     Mem mem;
{
    char *block;
    int i;
    unsigned int max, inc;
    blocklist_t *next;
    
    mem->total += mem->heapsize;

#ifdef DEBUG
    (void)fprintf(stderr, "adding %d blocks (total %d) of size %d\n",
		  mem->heapsize, mem->total, mem->blksize);
#endif

    block = malloc((max = mem->heapsize) * (inc = mem->blksize));
    if (block == (char *)NULL) {
	(void)fprintf(stderr, "malloc:  out of memory\n");
	exit(1);
    }
    for (i = 0; i < max - 1; i++) {
	*((size_t **)(block + i * inc)) = (size_t *)(block + (i + 1) * inc);
    }
    *((size_t **)(block + i * inc)) = (size_t *)mem->flist;
    mem->flist = (Ptr)block;
    
    next = NEW(blocklist_t);
    next->buf = (Ptr)block;
    next->next = mem->blocks;
    mem->blocks = next;
}

/* Create a new Mem struct with initsize blocks of size blocksize. */
Mem memNew(blocksize, initsize)
     int blocksize, initsize;
{
    Mem new;
    
    if ((new = (Mem)malloc(sizeof (Mem_t))) == (Mem)NULL) {
	perror("malloc");
	exit(1);
    }
    new->blksize = (size_t)blocksize;
    new->heapsize = (size_t)initsize;
    new->total = 0;
    new->flist = (Ptr)NULL;
    new->blocks = (blocklist_t *)NULL;

#ifdef DEBUG
    new->count = 0;
#endif /* DEBUG */
    
    memExtend(new);
    return new;
}

/* Return the address of a block from mem or NULL if no blocks are free. */
Ptr _memBlock(mem)
     Mem mem;
{
    Ptr ret;
    
    if (ret = mem->flist) {

#ifdef DEBUG
	++mem->count;
#endif /* DEBUG */

	mem->flist = *((Ptr *)ret);
    }
    return ret;
}

/* Return the address of a block from mem (extends mem in necessary). */
Ptr memBlock(mem)
     Mem mem;
{
    Ptr ret;

 find:
    if (ret = mem->flist) {

#ifdef DEBUG
	++mem->count;
#endif /* DEBUG */

	mem->flist = *((Ptr *)ret);
	return ret;
    }
    memExtend(mem);
    goto find;
}

/* Return the address of a block from mem or NULL if no blocks are free.
 * The block is initialized to contain 0s. */
Ptr _memCleanBlock(mem)
     Mem mem;
{
    char *ret;
    
    if (ret = (char *)mem->flist) {

#ifdef DEBUG
	++mem->count;
#endif /* DEBUG */

	mem->flist = *((Ptr *)ret);
	bzero(ret, mem->blksize);
    }
    return (Ptr)ret;
}

/* Return the address of a block from mem (extends mem in necessary).
 * The block is initialized to contain 0s. */
Ptr memCleanBlock(mem)
     Mem mem;
{
    char *ret;
    
 find:
    if (ret = (char *)mem->flist) {

#ifdef DEBUG
	++mem->count;
#endif /* DEBUG */

	mem->flist = *((Ptr *)ret);
	bzero(ret, mem->blksize);
	return (Ptr)ret;
    }

    memExtend(mem);
    goto find;
}

/* Put block into mem's free list. */
void memFreeBlock(block, mem)
     Ptr block;
     Mem mem;
{
    Ptr next;

#ifdef DEBUG
    --mem->count;
#endif /* DEBUG */
    
    next = mem->flist;
    mem->flist = block;
    *((size_t **)block) = (size_t *)next;
}

/* Apply f to each block in mem */
void memApplyAll(mem, f)
     Mem mem;
     F_VOID f;
{
    int i, max, inc;
    char *buf;
    blocklist_t *blocks;
    
    max = mem->heapsize;
    inc = mem->blksize;
    
    for (blocks = mem->blocks; blocks; blocks = blocks->next)
	for (buf = (char *)blocks->buf, i = 0; i < max; i += inc) {
	    (*f)((Ptr)(buf + i));
	}
}

/* Apply f to each block in mem's free list */
void memApplyUnused(mem, f)
     Mem mem;
     F_VOID f;
{
    char *ptr;
    
    for (ptr = (char *)mem->flist; ptr; ptr = *((char **)ptr))
	(*f)((Ptr)ptr);
}
