#include "../xt/xt.h"
#include <Xm/Xm.h>
#include <Xm/ScrollBar.h>

static Object Get_Scrollbar_CB (p) XmScrollBarCallbackStruct *p; {
    Object ret, s;
    GC_Node2;

    ret = s = Cons (Make_Integer (p->pixel), Null);
    GC_Link2 (ret, s);
    ret = Cons (Make_Integer (p->value), ret);
    s = Get_Any_CB ((XmAnyCallbackStruct *)p);
    ret = Cons (Cdr (s), ret);
    ret = Cons (Car (s), ret);
    GC_Unlink;
    return ret;
}

static Object S_Scroll_Bar_DecrementCallback (x) XtArgVal x; {
   return Get_Scrollbar_CB ((XmScrollBarCallbackStruct *)x);
}

static Object S_Scroll_Bar_IncrementCallback (x) XtArgVal x; {
   return Get_Scrollbar_CB ((XmScrollBarCallbackStruct *)x);
}

static Object S_Scroll_Bar_PageDecrementCallback (x) XtArgVal x; {
   return Get_Scrollbar_CB ((XmScrollBarCallbackStruct *)x);
}

static Object S_Scroll_Bar_PageIncrementCallback (x) XtArgVal x; {
   return Get_Scrollbar_CB ((XmScrollBarCallbackStruct *)x);
}

static Object S_Scroll_Bar_DragCallback (x) XtArgVal x; {
   return Get_Scrollbar_CB ((XmScrollBarCallbackStruct *)x);
}

static Object S_Scroll_Bar_ToTopCallback (x) XtArgVal x; {
   return Get_Scrollbar_CB ((XmScrollBarCallbackStruct *)x);
}

static Object S_Scroll_Bar_ToBottomCallback (x) XtArgVal x; {
   return Get_Scrollbar_CB ((XmScrollBarCallbackStruct *)x);
}

static Object S_Scroll_Bar_ValueChangedCallback (x) XtArgVal x; {
   return Get_Scrollbar_CB ((XmScrollBarCallbackStruct *)x);
}

init_scrollbar () {
    XtResourceList r = 0;
    Define_Class ("scroll-bar", xmScrollBarWidgetClass, r, 0);
    Define_Callback ("scroll-bar", "valueChangedCallback", 1);
    Define_Callback ("scroll-bar", "toBottomCallback", 1);
    Define_Callback ("scroll-bar", "toTopCallback", 1);
    Define_Callback ("scroll-bar", "dragCallback", 1);
    Define_Callback ("scroll-bar", "pageIncrementCallback", 1);
    Define_Callback ("scroll-bar", "pageDecrementCallback", 1);
    Define_Callback ("scroll-bar", "incrementCallback", 1);
    Define_Callback ("scroll-bar", "decrementCallback", 1);
    Define_Converter_To_Scheme ("scroll-bar-valueChangedCallback", S_Scroll_Bar_ValueChangedCallback);
    Define_Converter_To_Scheme ("scroll-bar-toBottomCallback", S_Scroll_Bar_ToBottomCallback);
    Define_Converter_To_Scheme ("scroll-bar-toTopCallback", S_Scroll_Bar_ToTopCallback);
    Define_Converter_To_Scheme ("scroll-bar-dragCallback", S_Scroll_Bar_DragCallback);
    Define_Converter_To_Scheme ("scroll-bar-pageIncrementCallback", S_Scroll_Bar_PageIncrementCallback);
    Define_Converter_To_Scheme ("scroll-bar-pageDecrementCallback", S_Scroll_Bar_PageDecrementCallback);
    Define_Converter_To_Scheme ("scroll-bar-incrementCallback", S_Scroll_Bar_IncrementCallback);
    Define_Converter_To_Scheme ("scroll-bar-decrementCallback", S_Scroll_Bar_DecrementCallback);
}
