#include "../xt/xt.h"
#include <X11/Xaw/Paned.h>

static Object P_Paned_Allow_Resize (w, enable) Object w, enable; {
   Check_Widget (w);
    Check_Type (enable, T_Boolean);
    XawPanedAllowResize (WIDGET(w)->widget, EQ (enable, True));
    return Void;
}

static Object P_Paned_Set_Min_Max (w, min, max) Object w, min, max; {
   Check_Widget (w);
    XawPanedSetMinMax (WIDGET(w)->widget, Get_Integer (min),
	Get_Integer (max));
    return Void;
}

static Object P_Paned_Get_Min_Max (w) Object w; {
   int min, max;
    Check_Widget (w);
    XawPanedGetMinMax (WIDGET(w)->widget, &min, &max);
    return Cons (Make_Fixnum (min), Make_Fixnum (max));
}

static Object P_Paned_Set_Refigure_Mode (w, enable) Object w, enable; {
   Check_Widget_Class (w, panedWidgetClass);
    Check_Type (enable, T_Boolean);
    XawPanedSetRefigureMode (WIDGET(w)->widget, EQ (enable, True));
    return Void;
}

static Object P_Paned_Get_Num_Sub (w) Object w; {
   Check_Widget_Class (w, panedWidgetClass);
    return Make_Fixnum (XawPanedGetNumSub (WIDGET(w)->widget));
}

init_paned () {
    XtResourceList r = 0;
    Define_Class ("paned", panedWidgetClass, r, 0);
    Define_Primitive (P_Paned_Get_Num_Sub, "paned-get-num-sub", 1, 1, EVAL);
    Define_Primitive (P_Paned_Set_Refigure_Mode, "paned-set-refigure-mode!", 2, 2, EVAL);
    Define_Primitive (P_Paned_Get_Min_Max, "paned-get-min-max", 1, 1, EVAL);
    Define_Primitive (P_Paned_Set_Min_Max, "paned-set-min-max!", 3, 3, EVAL);
    Define_Primitive (P_Paned_Allow_Resize, "paned-allow-resize", 2, 2, EVAL);
}
