#include <errno.h>

#include "scheme.h"

extern int errno;
extern char *getenv();

Object V_Home;

static Object P_Chdir (argc, argv) Object *argv; {
    Object dir;
    register char *s;
    Declare_C_Strings;

    dir = argc == 0 ? Var_Get (V_Home) : argv[0];
    Make_C_String (dir, s);
    if (chdir (s) < 0) {
	Saved_Errno = errno;
	Primitive_Error ("~s: ~E", dir);
    }
    Dispose_C_Strings;
    return Void;
}

init_lib_chdir () {
    register char *p = getenv ("HOME");

    if (p == 0)
	p = ".";
    Define_Variable (&V_Home, "home", Make_String (p, strlen (p)));
    Define_Primitive (P_Chdir, "chdir", 0, 1, VARARGS);
}
