;; remoteprocess.e zilla 17feb - manipulate remote processes
;; 4oct	sysv version

(require 'shell.e)
(provide 'remoteprocess.e)

;; kill processes on a remote machine, by name
(define (remotekill mach processname)
  (remoteproc mach processname "kill ~a"))


;; renice a process remote group
;; 'ps xl' shows the nice priority in NI column.
(define (renice mach processname niceval)
  (remoteproc mach processname
	      (format #f
		      "/etc/renice ~a -g ~~a" niceval))
)


;; helper: given mach, processname, and a commandstring with one ~a,
;; get pids on the remote mach wich match processname, 
;; substitute those pids into cmd, and execute.
(define (remoteproc mach processname cmd)
  (if (equal? (os-architecture) "mips")
      (remoteproc-sysv mach processname cmd)
      (remoteproc-bsd mach processname cmd)
))

(define (remoteproc-bsd mach processname cmd)
  (if (symbol? mach) (set! mach (symbol->string mach)))
  (rsh (format #f "~a ps gx | grep ~a > proctmp~~" mach processname))
  (call-with-input-file "proctmp~"
    (lambda (f)
      (let ((s (read-string f)))
	(while (not (eof-object? s))
	  (let* ((pid (substring s 0 6))
		 (cmdp (format #f cmd pid)))
	    (format #t " remoteproc found: ~a~%" s)
	    (format #t " remoteproc doing rsh ~a ~a~%" mach cmdp)
	    (rsh mach cmdp)
	  )
	  (set! s (read-string f))
	)
      );let
    );lambda
  );call-with-input-file
);remoteproc-bsd



(define (remoteproc-sysv mach processname cmd)
  (if (symbol? mach) (set! mach (symbol->string mach)))
  (rsh (format #f "~a ps -edalf | grep ~a > proctmp~~" mach processname))
  (call-with-input-file "proctmp~"
    (lambda (f)
      (let ((s (read-string f)))
	(while (not (eof-object? s))
	  (let* ((pid (substring s 14 20))
		 (cmdp (format #f cmd pid)))
	    (format #t " remoteproc found: ~a~%" s)
	    (format #t " remoteproc doing rsh ~a ~a~%" mach cmdp)
	    (rsh mach cmdp)
	  )
	  (set! s (read-string f))
	)
      );let
    );lambda
  );call-with-input-file
);remoteproc-sysv



