;;; -*-Scheme-*-

(define-widget-type 'textedit "TextEdit.h")

(prolog

"static SYMDESCR Sourcetype_Syms[] = {
    { \"string\",        XwstringSrc },
    { \"disk\",          XwdiskSrc },
    { \"prog-defined\",  XwprogDefinedSrc },
    { 0, 0 }
};
static SYMDESCR Edittype_Syms[] = {
    { \"text-read\",     XwtextRead },
    { \"text-append\",   XwtextAppend },
    { \"text-edit\",     XwtextEdit },
    { 0, 0 }
};")

(scheme->c 'text-edit-editType
"   return (XtArgVal)Symbols_To_Bits (x, 0, Edittype_Syms);")

(scheme->c 'text-edit-sourceType
"   return (XtArgVal)Symbols_To_Bits (x, 0, Sourcetype_Syms);")

(define-widget-class 'text-edit 'XwtexteditWidgetClass
  '(string String String)
  '(maximumSize Length Int)
  '(file String String)
  '(editType EditType EditMode)
  '(font Font FontStruct)
  '(foreground Foreground Pixel))

(define-primitive 'text-copy-buffer '(w)
"   char *b;
    Object ret;
    Check_Widget_Class (w, XwtexteditWidgetClass);
    b = (char *)XwTextCopyBuffer (WIDGET(w)->widget);
    ret = Make_String (b, strlen (b));
    XtFree (b);
    return ret;")

(define-primitive 'text-clear-buffer '(w)
"   Check_Widget_Class (w, XwtexteditWidgetClass);
    XwTextClearBuffer (WIDGET(w)->widget);
    return Void;")
