(##declare (standard-bindings) (not safe) (fixnum)) ; generate fast code
(##declare (multilisp) (futures lazy))              ; use `lazy' futures

(let () ; the program...

  (define (fib n)
    (if (< n 2)
      n
      (let* ((x (FUTURE (fib (- n 1))))
             (y (fib (- n 2))))
        (+ x y))))

  (##stats-start) ; start gathering statistics

  (let ((result (fib 25))) ; run code

    (##stats-stop) ; stop gathering statistics, output .stats and .elog files

    (write result) (newline))
)
