/* os_mac.c, included by os.c */

/* Macintosh specific stuff (for THINK C 4.0 compiler). */

#include <QuickDraw.h>
#include <MacTypes.h>
#include <FontMgr.h>
#include <WindowMgr.h>
#include <MenuMgr.h>
#include <TextEdit.h>
#include <DialogMgr.h>
#include <EventMgr.h>
#include <DeskMgr.h>
#include <FileMgr.h>
#include <ToolboxUtil.h>
#include <ControlMgr.h>
#include <VRetraceMgr.h>

static void (*intr_action)();
static void (*io_action)();
static void (*timer_action)();
static void (*fatal_action)();

/*---------------------------------------------------------------------------*/

#define FontNum 479
#define FontSize 9
#define FontH 12
#define FontW 6
#define Border 3
#define SBarWidth 15

#define about_dlogID  128
#define string_dlogID 129

#define ok_alertID        128
#define ok_cancel_alertID 129

#define appleID   128
#define fileID    129
#define editID    130
#define commandID 131

#define newCommand       1
#define openCommand      2
#define closeCommand     3
#define saveCommand      5
#define saveasCommand    6
#define revertCommand    7
#define quitCommand      9

#define undoCommand       1
#define cutCommand        3
#define copyCommand       4
#define pasteCommand      5
#define clearCommand      6
#define findCommand       8
#define againCommand      9
#define balanceCommand    11

#define interruptCommand  1
#define helpCommand       2
#define toplevelCommand   3
#define abortCommand      4
#define returnCommand     5
#define nextCommand       7
#define previousCommand   8
#define backtraceCommand  9
#define procedureCommand  10
#define expressionCommand 11
#define localsCommand     12

#define appleM   0
#define fileM    1
#define editM    2
#define commandM 3

#define gc_cursorID 128

#define graphic_char(c) (((c)>=33) && ((c)<=126))

#define MAX_NB_WINDOWS 6
#define OUT_BUF_LEN 128

MenuHandle menus[4];

int abnormal_exit = 1;
int can_do_bold;
int font_num;
int interaction_id = 0;
Str255 find_string;

static struct {
  int in_use;
  int bold_input;
  WindowPtr wptr;
  ControlHandle vscroll;
  TEHandle hTE;
  int height;
  int dirty;
  int pos, len;
  char *buf;
  int is_file;
  int vrefnum;
  char filename[128];
  char out_buf[OUT_BUF_LEN];
  int out_len;
  } wind_table[MAX_NB_WINDOWS];

static long intr_task_installed = 0;
static long intr_task_interval = 0;

static VBLTask task;

static void intr_task()
{ asm
  { move.l a5,-(sp)
    move.l 0x904,a5
  }
  if (intr_task_interval > 0)
  { timer_action( 0L, 0L, 1L );
    task.vblCount = intr_task_interval;
  }
  else
    task.vblCount = 1;
  asm
  { move.l (sp)+,a5
  }
}

static void start_intr_task()
{ task.qType    = vType;
  task.vblAddr  = (ProcPtr)intr_task;
  task.vblCount = 1;
  task.vblPhase = 0;
  intr_task_installed = (VInstall( &task ) == noErr);
}

static void stop_intr_task()
{ if (intr_task_installed)
  { VRemove( &task ); intr_task_installed = 0; }
}


Cursor watch_cursor;
Cursor gc_cursor;
Cursor ibeam_cursor;
Cursor *current_cursor;
int current_menus;

static void setup_cursors()
{ CursHandle hCurs;
  hCurs = GetCursor(watchCursor);
  watch_cursor = **hCurs;
  hCurs = GetCursor(gc_cursorID);
  gc_cursor = **hCurs;
  hCurs = GetCursor(iBeamCursor);
  ibeam_cursor = **hCurs;

  current_cursor = &watch_cursor;
}

static void c_to_p( c_str, p_str )
char *c_str, *p_str;
{ int i = 0;
  while (c_str[i] != '\0') { p_str[i+1] = c_str[i]; i++; }
  p_str[0] = i;
}

static void p_to_p( p1, p2 )
char *p1, *p2;
{ int len = *p1++;
  *p2++ = len;
  while (len>0) { *p2++ = *p1++; len--; }
}

static void p_to_c( p_str, c_str )
char *p_str, *c_str;
{ int len = *p_str++, i = 0;
  while (i<len) { *c_str++ = *p_str++; i++; }
  *c_str++ = '\0';
}

static void wind_begin()
{ int i;
  for (i=0; i<MAX_NB_WINDOWS; i++) wind_table[i].in_use = 0;
  InitGraf( &thePort );
  InitFonts();
  FlushEvents( everyEvent, 0 );
  InitWindows();
  InitMenus();
  TEInit();
  InitDialogs( 0L );
  InitCursor();

  can_do_bold = (GetResource( 'FONT', FontNum*128+FontSize )!=0);
  if (can_do_bold) font_num = FontNum; else font_num = 4;

  menus[appleM] = NewMenu( appleID, "\p\024" );
  AppendMenu( menus[appleM], "\pAbout Gambit v1.7.1;(-" );
  AddResMenu( menus[appleM], 'DRVR' );
  menus[fileM] = NewMenu( fileID, "\pFile" );
  AppendMenu( menus[fileM], "\pNew/N;Open/O;Close;(-;Save/S;Save As   ;(Revert;(-;Quit/Q" );
  menus[editM] = NewMenu( editID, "\pEdit" );
  AppendMenu( menus[editM], "\p(Undo;(-;Cut/X;Copy/C;Paste/V;Clear;(-;Find/F;Find Again/A;(-;Balance/[" );
  menus[commandM] = NewMenu( commandID, "\pCommand" );
  AppendMenu( menus[commandM], "\pInterrupt/.;Help/H;Toplevel/T;Abort This Level/D;Return Value/R;(-;Next Frame/+;Previous Frame/-;Backtrace/B;Procedure/P;Expression/E;List Variables/L" );
  for ( (i=appleM); (i<=commandM); i++ ) InsertMenu(menus[i], 0) ;
  DrawMenuBar();
  current_menus = 0;

  setup_cursors();

  find_string[0] = '\0';
}

static void wind_close( id )
int id;
{ if (wind_table[id].in_use)
  { wind_table[id].in_use = 0;
    HideWindow( wind_table[id].wptr );
    TEDispose( wind_table[id].hTE );
    DisposeControl( wind_table[id].vscroll );
    DisposeWindow( wind_table[id].wptr );
    if (wind_table[id].buf != NULL)
    { DisposPtr( wind_table[id].buf ); wind_table[id].buf = NULL; }
  }
}

static void wind_end()
{ int id;
  for (id=MAX_NB_WINDOWS-1; id>=0; id--) wind_close( id );
}

static int wind_open( name )
char *name;
{ Rect viewRect, vScrollRect, bounds;
  int width = 80 /*(screenBits.bounds.right-SBarWidth-2*Border-11)/FontW*/;
  int height = (screenBits.bounds.bottom-2*Border-48)/FontH;
  int id;
  Str255 wname;

  for (id=0; id<MAX_NB_WINDOWS; id++) if (!wind_table[id].in_use) break;
  if (id == MAX_NB_WINDOWS) return -1;

  bounds.left   = 3 + id*10;
  bounds.right  = bounds.left + width*FontW + SBarWidth + 2*Border;
  bounds.top    = 43 + id*10;
  bounds.bottom = bounds.top + height*FontH + 2*Border;

  c_to_p( name, wname );

  wind_table[id].wptr =
    NewWindow( NULL, &bounds, wname, TRUE,
               documentProc, -1L, TRUE, 0L );
  if (wind_table[id].wptr == NULL) return -1;

  SetPort( wind_table[id].wptr );
  TextFont( font_num );
  TextSize( FontSize );

  vScrollRect = (*wind_table[id].wptr).portRect;
  vScrollRect.left = vScrollRect.right-SBarWidth;
  vScrollRect.right += 1;
  vScrollRect.bottom -= SBarWidth-1;
  vScrollRect.top -= 1;

  wind_table[id].vscroll =
    NewControl( wind_table[id].wptr, &vScrollRect, "\p", 1, 0, 0, 0,
                scrollBarProc, 0L);

  if (wind_table[id].vscroll != NULL)
  { viewRect = (*wind_table[id].wptr).portRect;
    viewRect.right -= SBarWidth;
    InsetRect( &viewRect, Border, Border );

    wind_table[id].hTE =
      TENew( &viewRect, &viewRect );

    if (wind_table[id].hTE != NULL)
    { TESetJust( teJustLeft, wind_table[id].hTE );
      wind_table[id].height     = height;
      wind_table[id].bold_input = 0;
      wind_table[id].dirty      = 0;
      wind_table[id].pos        = 0;
      wind_table[id].len        = 0;
      wind_table[id].buf        = NULL;
      wind_table[id].out_len    = 0;
      wind_table[id].is_file    = 0;
      wind_table[id].filename[0]= 0;
      wind_table[id].in_use     = 1;
      return id;
    }

    DisposeControl( wind_table[id].vscroll );
  }

  DisposeWindow( wind_table[id].wptr );
  return -1;
}

static int discard_changes( id )
int id;
{ Str255 title;
  GetWTitle( wind_table[id].wptr, title );
  ParamText( "\pDiscard changes to \"", title, "\p\"?", "\p" );
  switch (CautionAlert( ok_cancel_alertID, 0L ))
  { case 3: return 1;
    default: return 0;
  }
}

static int mem_full = 0;

pascal long mem_full_err( size )
long size;
{ ParamText( "\pMemory full", "\p", "\p", "\p" );
  StopAlert( ok_alertID, 0L );
  mem_full = 1;
  return 0;
}

static void no_file_err()
{ ParamText( "\pThis buffer is not attached to a file!", "\p", "\p", "\p" );
  StopAlert( ok_alertID, 0L );
}

static void wind_err()
{ ParamText( "\pCan't open window", "\p", "\p", "\p" );
  StopAlert( ok_alertID, 0L );
}

static void io_err( io )
int io;
{ switch (io)
  { case wrPermErr    : ParamText( "\pCan't write file!", "\p", "\p", "\p" ); break;
    case dupFNErr     : ParamText( "\pDuplicate file name!", "\p", "\p", "\p" ); break;
    case fBsyErr      : ParamText( "\pFile is busy!", "\p", "\p", "\p" ); break;
    case vLckdErr     : ParamText( "\pVolume is locked!", "\p", "\p", "\p" ); break;
    case fLckdErr     : ParamText( "\pFile is locked!", "\p", "\p", "\p" ); break;
    case fnfErr       : ParamText( "\pFile not found!", "\p", "\p", "\p" ); break;
    case bdNamErr     : ParamText( "\pBad filename!", "\p", "\p", "\p" ); break;
    case ioErr        : ParamText( "\pIO transfer error!", "\p", "\p", "\p" ); break;
    case dskFulErr    : ParamText( "\pDisk full!", "\p", "\p", "\p" ); break;
    case dirFulErr    : ParamText( "\pDirectory full!", "\p", "\p", "\p" ); break;
    default           : ParamText( "\pIO Error!", "\p", "\p", "\p" ); break;
  }
  StopAlert( ok_alertID, 0L );
}

static void te_limit_err()
{ ParamText( "\pText truncated due to size limit on buffer (32000 characters)", "\p", "\p", "\p" );
  StopAlert( ok_alertID, 0L );
}

#define TE_LIMIT 32000L

static int check_TEInsert( ptr, len, hTE )
char *ptr;
long len;
TEHandle hTE;
{ long left = TE_LIMIT - (**hTE).teLength;
  if (left < 0)
    return 1;
  else if (len > left)
  { len = left+1;
    TEInsert( ptr, len, hTE );
    te_limit_err();
    mem_full = 0;
    return 1;
  }
  else
  { TEInsert( ptr, len, hTE ); if (mem_full) { mem_full = 0; return 1; } else return 0; }
}

static int check_TEPaste( hTE )
TEHandle hTE;
{ long left = TE_LIMIT - (**hTE).teLength - ((**hTE).selEnd - (**hTE).selStart);
  if (left > TEGetScrapLen())
  { TEPaste( hTE ); if (mem_full) { mem_full = 0; return 1; } else return 0; }
  else
  { te_limit_err(); return 1; }
}

static int check_TEKey( c, hTE )
char c;
TEHandle hTE;
{ long left = TE_LIMIT - (**hTE).teLength - ((**hTE).selEnd - (**hTE).selStart);
  if ((left > 0) || (c == '\b'))
  { TEKey( c, hTE ); if (mem_full) { mem_full = 0; return 1; } else return 0; }
  else
  { te_limit_err(); return 1; }
}

static int wptr_to_id( w )
WindowPtr w;
{ int id;
  for (id=0; id<MAX_NB_WINDOWS; id++)
    if ((wind_table[id].in_use) && (wind_table[id].wptr == w)) return id;
  return -1;
}

static void adjust_text( id )
int id;
{ TEHandle hTE = wind_table[id].hTE;
  int oldScroll, newScroll, delta;
  oldScroll = (**hTE).viewRect.top - (**hTE).destRect.top;
  newScroll = GetCtlValue(wind_table[id].vscroll) * (**hTE).lineHeight;
  delta = oldScroll - newScroll;
  if (delta != 0) TEScroll( 0, delta, hTE );
}

static void setup_vscroll( id )
int id;
{ TEHandle hTE = wind_table[id].hTE;
  int  n;
  n = (**hTE).nLines-wind_table[id].height;
  if ((**hTE).teLength > 0 && (*((**hTE).hText))[(**hTE).teLength-1]=='\r') n++;
  SetCtlMax(wind_table[id].vscroll, n > 0 ? n : 0);
}

static void show_select( id )
int id;
{ TEHandle hTE = wind_table[id].hTE;
  int topLine, bottomLine, theLine;
  
  setup_vscroll( id );
  adjust_text( id );
  
  topLine = GetCtlValue(wind_table[id].vscroll);
  bottomLine = topLine + wind_table[id].height;
  
  if ((**hTE).selStart < (**hTE).lineStarts[topLine] ||
      (**hTE).selStart >= (**hTE).lineStarts[bottomLine])
  { for (theLine = 0; (**hTE).selStart >= (**hTE).lineStarts[theLine]; theLine++) ;
    SetCtlValue(wind_table[id].vscroll, theLine - wind_table[id].height / 2);
    adjust_text( id );
  }
}

static void setup_view( id )
int id;
{ WindowPtr w = wind_table[id].wptr;
  TEHandle hTE = wind_table[id].hTE;
  (**hTE).viewRect = w->portRect;
  (**hTE).viewRect.right -= SBarWidth;
  InsetRect(&(**hTE).viewRect, Border, Border);
  wind_table[id].height = ((**hTE).viewRect.bottom-(**hTE).viewRect.top)/(**hTE).lineHeight;
  (**hTE).viewRect.bottom = (**hTE).viewRect.top + (**hTE).lineHeight*wind_table[id].height;
  (**hTE).destRect.right = (**hTE).viewRect.right;
  TECalText( hTE );
}

static int wid;

pascal void ScrollProc( theControl, theCode )
ControlHandle theControl;
int theCode;
{ TEHandle hTE = wind_table[wid].hTE;
  int pageSize = wind_table[wid].height;
  int scrollAmt;
  
  if (theCode == 0) return;
  
  switch (theCode)
  { case inUpButton: 
      scrollAmt = -1;
      break;
    case inDownButton: 
      scrollAmt = 1;
      break;
    case inPageUp: 
      scrollAmt = -pageSize;
      break;
    case inPageDown: 
      scrollAmt = pageSize;
      break;
    }
  SetCtlValue( theControl, GetCtlValue(theControl)+scrollAmt );
  adjust_text( wid );
}

static void content( id, event )
int id;
EventRecord *event;
{ WindowPtr w = wind_table[id].wptr;
  TEHandle hTE = wind_table[id].hTE;
  int cntlCode;
  ControlHandle theControl;
  int pageSize;
  GrafPtr save;
  
  GetPort(&save);
  SetPort(w);
  GlobalToLocal( &event->where );
  if ((cntlCode = FindControl(event->where, w, &theControl)) == 0)
  { if (PtInRect( event->where, &(**hTE).viewRect ))
      TEClick( event->where, (event->modifiers & shiftKey )!=0, hTE);
  }
  else if (cntlCode == inThumb)
  { TrackControl(theControl, event->where, 0L);
    adjust_text( id );
  }
  else
  { wid = id;
    TrackControl(theControl, event->where, &ScrollProc);
  }

  SetPort(save);
}

static void grow_window( id, p )
int id;
Point p;
{ WindowPtr w = wind_table[id].wptr;
  GrafPtr save;
  long result;
  int oScroll;
  Rect r, oView;
  
  GetPort( &save );
  SetPort( w );

  SetRect(&r, 80, 80, screenBits.bounds.right, screenBits.bounds.bottom);
  result = GrowWindow( w, p, &r );
  if (result == 0) return;
  SizeWindow( w, LoWord(result), HiWord(result), 1);

  InvalRect(&w->portRect);
  oView = (**wind_table[id].hTE).viewRect;
  oScroll = GetCtlValue(wind_table[id].vscroll);
  
  setup_view( id );
  HidePen();
  MoveControl(wind_table[id].vscroll, w->portRect.right - SBarWidth, w->portRect.top-1);
  SizeControl(wind_table[id].vscroll, SBarWidth+1, w->portRect.bottom - w->portRect.top-(SBarWidth-2));
  ShowPen();

  setup_vscroll( id );
  adjust_text( id );
  
  SetPort( save );
}

#define CH(c) ((c)&0x7f)

static int balance( id, bal, prefix )
int id;
int bal;
int prefix;
{ TEHandle hTE = wind_table[id].hTE;
  register char *text = *((**hTE).hText);
  register char *p = text+(**hTE).selStart;
  register int b = bal;

  while ((p>text) && !graphic_char(CH(p[-1]))) p--;

  while (p>text)
    if ((p>=text+3) && (CH(p[-2])=='\\') && (CH(p[-3])=='#'))
      p -= 3;
    else
    { register char c = CH(*--p);
      if (graphic_char(c))
        switch (c)
        { case '(':
            b--;
            if (b <= 0) goto scan_prefix;
            break;
          case ')':
            b++;
            break;
          case '"':
          { while (p>text)
            { register char *q = --p;
              while ((q>text) && (CH(q[-1])=='\\')) q--;
              if ((p-q)&1L)
                p = q;
              else if (CH(*p)=='"')
                if (b <= 0) goto scan_prefix; else goto brak;
            }
            return -1;
            brak:
            break;
          }
          default:
          { while ((p>=text) && graphic_char(c) &&
                   (c!='(') && (c!=')') && (c!='"'))
              c = CH(*--p);
            p++;
            if (b <= 0) goto scan_prefix;
            break;
          }
      }
  }
  return -1;

  scan_prefix:
  if (prefix)
    while (p>text)
    { register char c = CH(*--p);
      if ((c!='\'') && (c!='`') && (c!=',') && (c!='@') && (c!='#'))
      { p++; break; }
    }
  return p-text;
}

static int column( id, pos )
int id;
int pos;
{ TEHandle hTE = wind_table[id].hTE;
  register char *text = *((**hTE).hText);
  register char *p = text+pos;
  register int n = 0;

  if (pos < 0)
    return -1;
  else
  { while ((p>text) && (*--p != '\r')) n++;
    return n;
  }
}

static void put_input( id, ptr, len, cr, flush, freshline )
int id;
char *ptr;
int len;
int cr, flush, freshline;
{ if (wind_table[id].in_use)
  { long len1;
    register long len2 = (wind_table[id].len - wind_table[id].pos);
    register char *buf, *p1, *p2;
    if ((len2 < 0) || flush) len2 = 0;
    len1 = ((cr)?1:0) + len2 + (long)len;
    buf = NewPtr( len1 );
    if (buf == NULL) { SysBeep(10); return; }
    p1 = buf;
    p2 = wind_table[id].buf + wind_table[id].pos;
    while (len2 > 0) { *p1++ = *p2++; len2--; }
    p2 = ptr;
    while (len > 0) { *p1++ = *p2++; len--; }
    if (cr) *p1++ = '\r';
    if (wind_table[id].buf != NULL) DisposPtr( wind_table[id].buf );
    wind_table[id].buf = buf;
    wind_table[id].pos = 0;
    wind_table[id].len = len1;
    if (freshline)
    { if (column( id, (**wind_table[id].hTE).selStart ) > 0)
        check_TEInsert( "\r", 1L, wind_table[id].hTE );
      show_select( id );
    }
  }
}

static void interrupt()
{ intr_action( 0L, 0L, "SIGINT" );
  put_input( interaction_id, "", 0, 0, 1, 0 );
}

static int open_file( filename, vol, for_output, txt, io )
Str255 filename;
int vol;
int for_output;
int txt;
int *io;
{ ioParam pb;
  fileParam fp;
  int refnum;
  int len = (unsigned char)filename[0];

  pb.ioNamePtr = filename;
  pb.ioVRefNum = vol;
  pb.ioVersNum = 0;
  pb.ioPermssn = ((for_output) ? fsRdWrPerm : fsRdPerm);
  pb.ioMisc = 0;

  if (for_output)
  { asm
    { lea    pb,a0
      _PBCreate
    }
    if ((pb.ioResult != noErr) && (pb.ioResult != dupFNErr))
    { *io = pb.ioResult;  return -1; }
  }
  
  asm
  { lea    pb,a0
    _PBOpen
  }
  if (pb.ioResult != noErr)
  { if (for_output)
      asm
      { lea    pb,a0
        _PBDelete
      }
    *io = pb.ioResult;
    return -1;
  }
  refnum = pb.ioRefNum;
  
  if (!for_output) { *io = noErr; return refnum; }

  asm
  { lea    pb,a0
    _PBSetEOF
  }

  fp.ioNamePtr = filename;
  fp.ioVRefNum = vol;
  fp.ioFVersNum = 0;
  fp.ioFDirIndex = 0;
  asm
  { lea    fp,a0
    _PBGetFInfo
    bmi.s  @1
  }
  if (txt)
    fp.ioFlFndrInfo.fdType = 'TEXT';
  else
    fp.ioFlFndrInfo.fdType = 'gamO';
  fp.ioFlFndrInfo.fdCreator = 'gamI';
  asm
  { lea    fp,a0
    _PBSetFInfo
    @1
  }

  *io = noErr;
  return refnum;
}

static int close_file( refnum, vrefnum, io )
int refnum;
int vrefnum;
int *io;
{ *io = FSClose( refnum );
  if (*io != noErr)
    return 1;
  else
  { *io = FlushVol( NULL, vrefnum );
    return (*io != noErr);
  }
}

static char nl = '\r';

static void read_file( id )
int id;
{ TEHandle hTE = wind_table[id].hTE;
  int refnum;
  int io, io2;

  if (wind_table[id].dirty)
    if (!discard_changes( id )) return;

  refnum = open_file( wind_table[id].filename, wind_table[id].vrefnum, 0, 1, &io );
  if (refnum == -1)
  { io_err( io );
    return;
  }

  TESetSelect( 0L, (**hTE).teLength, hTE );
  TEDelete( hTE );

  do
  { char buffer[1024];
    long count = sizeof(buffer);
    register long i = 0;
    io = FSRead( refnum, &count, buffer );
    if ((io == eofErr) || (io == noErr))
    { while (i < count) { if (buffer[i] == nl) buffer[i] = '\r'; i++; }
      if (check_TEInsert( &buffer, count, hTE )) io = eofErr;
    }
  } while (io == noErr);

  TESetSelect( 0L, 0L, hTE );
  show_select( id );

  if (close_file( refnum, wind_table[id].vrefnum, &io2 ) || ((io != eofErr) && (io != noErr)))
  { if ((io != eofErr) && (io != noErr)) io_err( io ); else io_err( io2 );
    wind_table[id].dirty = 1;
    return;
  }

  wind_table[id].dirty = (io != eofErr);
}

static void write_file( id )
int id;
{ TEHandle hTE = wind_table[id].hTE;
  int refnum;
  int io, io2;

  refnum = open_file( wind_table[id].filename, wind_table[id].vrefnum, 1, 1, &io );
  if (refnum == -1)
  { io_err( io );
    return;
  }

  { char buffer[1024];
    register long i = 0;
    while ((i < (**hTE).teLength) && (io == noErr))
    { register char *p = *((**hTE).hText) + i;
      register long j = 0;
      long count = (**hTE).teLength - i;
      if (count > sizeof(buffer)) count = sizeof(buffer);
      while (j < count)
      { register char c = *p++; if (c == '\r') c = nl; buffer[j++] = c; }
      io = FSWrite( refnum, &count, buffer );
      i += count;
    }
  }

  if (close_file( refnum, wind_table[id].vrefnum, &io2 ) || (io != noErr))
  { if (io != noErr) io_err( io ); else io_err( io2 );
    return;
  }

  wind_table[id].dirty = 0;
}

static void wind_quit()
{ int id;
  for (id=MAX_NB_WINDOWS-1; id>=0; id--)
  { if (wind_table[id].in_use && wind_table[id].is_file && wind_table[id].dirty)
    { if (!discard_changes( id )) return;
      wind_close( id );
    }
  }
  abnormal_exit = 0;
  os_quit();
}

static void handle_close( id )
int id;
{ if (wind_table[id].is_file)
  { if ((wind_table[id].dirty) && (!discard_changes( id ))) return;
    wind_close( id );
  }
}

void find_next( id )
int id;
{ TEHandle hTE = wind_table[id].hTE;
  char *txt = *((**hTE).hText);
  register char *start = txt + (**hTE).selEnd - 1;
  register int len = (unsigned char)find_string[0];
  register char *end = txt + (**hTE).teLength - len;
  register int i;
  while (start < end)
  { for (i=len; i>0; i--)
      if (CH(start[i]) != find_string[i]) goto next_pos;
    TESetSelect( (int)(start-txt+1), (int)(start-txt+1+len), hTE );
    return;
    next_pos:
    start++;
  }
  SysBeep(10);
}

void balance_next( id )
int id;
{ TEHandle hTE = wind_table[id].hTE;
  int start = balance( id, 0, 1 );
  if (start < 0)
    SysBeep(10);
  else
    TESetSelect( start, (**hTE).selEnd, hTE );
}

static int handle_menu( result, id )
long result;
int id;
{ int theItem, temp;
  Str255 name;
  WindowPeek wPtr;
  GrafPtr save;
  int w;

  theItem = LoWord( result );
  switch (HiWord(result))
  { case appleID:
      if (theItem == 1)
      { DialogPtr dp;
        int i;
        ParamText( "\p", "\p", "\p", "\p" );
        dp = GetNewDialog( about_dlogID, 0L, -1L );
        if (dp != NULL)
        { ModalDialog( 0L, &i );
          CloseDialog( dp );
        }
      }
      else
      { GetPort(&save);
        GetItem(menus[appleM], theItem, &name);
        OpenDeskAcc( &name );
        SetPort( save );
      }
      break;
    case fileID: 
      switch (theItem)
      { case newCommand:
        { int w = wind_open( "Untitled" );
          if (w < 0)
            wind_err();
          else
          { wind_table[w].is_file = 1;
            wind_table[w].filename[0] = 0;
          }
          break;
        }
        case openCommand:
        { SFTypeList type;
          Point where = { 90, 82 };
          SFReply reply;
          type[0] = 'TEXT';
          SFGetFile( where, "\p", 0L, 1, type, 0L, &reply );
          if (reply.good)
          { int w;
            char name[256];
            p_to_c( reply.fName, name );
            w = wind_open( name );
            if (w < 0)
              wind_err();
            else
            { wind_table[w].is_file = 1;
              p_to_p( reply.fName, wind_table[w].filename );
              wind_table[w].vrefnum = reply.vRefNum;
              read_file( w );
            }
          }
          break;
        }
        case closeCommand:
          if (id >= 0)
            handle_close( id );
          break;
        case saveCommand:
          if (id >= 0)
            if (wind_table[id].is_file && (wind_table[id].filename[0] != 0))
            { write_file( id );
              break;
            }
        case saveasCommand:
          if (id >= 0)
          { Point where = { 106, 104 };
            SFReply reply;
            SFPutFile( where, "\pSave as:", wind_table[id].filename, 0L, &reply );
            if (reply.good)
            { if (wind_table[id].is_file)
                SetWTitle( wind_table[id].wptr, reply.fName );
              p_to_p( reply.fName, wind_table[id].filename );
              wind_table[id].vrefnum = reply.vRefNum;
              write_file( id );
            }
          }
          break;
        case revertCommand:
          if (id >= 0)
            read_file( id );
          break;
        case quitCommand:
          wind_quit();
          break;
      }
      break;
    case editID: 
      if (id < 0)
        SystemEdit(theItem-1);
      else
      { TEHandle hTE = wind_table[id].hTE;
        switch (theItem)
        { case cutCommand:
            TECut( hTE );
            wind_table[id].dirty = 1;
            break;
          case copyCommand:
            TECopy( hTE );
            break;
          case pasteCommand:
            check_TEPaste( hTE );
            wind_table[id].dirty = 1;
            break;
          case clearCommand:
            TEDelete( hTE );
            wind_table[id].dirty = 1;
            break;
          case findCommand:
          { DialogPtr dp; int i; Handle h;
            ParamText( "\pFind:", "\p" , "\p" , "\p" );
            dp = GetNewDialog( string_dlogID, 0L, -1L );
            if (dp == NULL) break;
            ModalDialog( 0L, &i );
            { Rect r;
              GetDItem( dp, 3, &i, &h, &r );
              GetIText( h, find_string );
            }
            CloseDialog( dp );
            find_next( id );
            break;
          }
          case againCommand:
            find_next( id );
            break;
          case balanceCommand:
            balance_next( id );
            break;
          default: ;
        }
        show_select( id );
      }
      break;
    case commandID: 
      switch (theItem)
      { case helpCommand:
          put_input( interaction_id, ",h", 2, 1, 1, 1 );
          break;
        case interruptCommand:
          interrupt();
          HiliteMenu(0);
          return 0;
        case returnCommand:
          put_input( interaction_id, ",r", 2, 1, 1, 1 );
          break;
        case abortCommand:
          put_input( interaction_id, "\004", 1, 0, 1, 0 );
          break;
        case toplevelCommand:
          put_input( interaction_id, ",t", 2, 1, 1, 1 );
          break;
        case nextCommand:
          put_input( interaction_id, ",+", 2, 1, 1, 1 );
          break;
        case previousCommand:
          put_input( interaction_id, ",-", 2, 1, 1, 1 );
          break;
        case backtraceCommand:
          put_input( interaction_id, ",b", 2, 1, 1, 1 );
          break;
        case procedureCommand:
          put_input( interaction_id, ",p", 2, 1, 1, 1 );
          break;
        case expressionCommand:
          put_input( interaction_id, ",e", 2, 1, 1, 1 );
          break;
        case localsCommand:
          put_input( interaction_id, ",l", 2, 1, 1, 1 );
          break;
        default:
          break;
          }
      break;
   }
  HiliteMenu(0);
  return 1;
}

static int handle_next_event() 
{ int w;
  EventRecord event;
  WindowPtr event_window;
  register int i;
  int men;

  SystemTask();

  for (i=0; i<MAX_NB_WINDOWS; i++)
    if ((wind_table[i].in_use) && (wind_table[i].out_len > 0))
    { check_TEInsert( wind_table[i].out_buf, (long)wind_table[i].out_len, wind_table[i].hTE );
      show_select( i );
      wind_table[i].out_len = 0;
    }

  w = wptr_to_id( FrontWindow() );
  if (w >= 0)
  { Point pt;
    GrafPtr save;
    Cursor *curs;
    GetPort( &save );
    SetPort( (GrafPtr)wind_table[w].wptr );
    GetMouse( &pt );
    if (PtInRect( pt, &(**wind_table[w].hTE).viewRect ))
      curs = &ibeam_cursor;
    else
      curs = &arrow;
    if (current_cursor != curs)
    { current_cursor = curs;
      SetCursor( current_cursor );
    }
    SetPort( save );
    TEIdle( wind_table[w].hTE );
    men = (wind_table[w].is_file && (wind_table[w].filename[0] != 0)) ? 1 : 0;
  }
  else
    men = 2;

  if (men != current_menus)
  { current_menus = men;
    switch (men)
    { case 0:
      case 1:
        EnableItem( menus[fileM], newCommand );
        EnableItem( menus[fileM], openCommand );
        EnableItem( menus[fileM], closeCommand );
        EnableItem( menus[fileM], saveCommand );
        EnableItem( menus[fileM], saveasCommand );
        if (men == 0)
          DisableItem( menus[fileM], revertCommand );
        else
          EnableItem( menus[fileM], revertCommand );
        EnableItem( menus[fileM], quitCommand );
        DisableItem( menus[editM], undoCommand );
        EnableItem( menus[editM], cutCommand );
        EnableItem( menus[editM], copyCommand );
        EnableItem( menus[editM], pasteCommand );
        EnableItem( menus[editM], clearCommand );
        EnableItem( menus[editM], findCommand );
        EnableItem( menus[editM], againCommand );
        EnableItem( menus[editM], balanceCommand );
        EnableItem( menus[commandM], interruptCommand );
        EnableItem( menus[commandM], helpCommand );
        EnableItem( menus[commandM], toplevelCommand );
        EnableItem( menus[commandM], abortCommand );
        EnableItem( menus[commandM], returnCommand );
        EnableItem( menus[commandM], nextCommand );
        EnableItem( menus[commandM], previousCommand );
        EnableItem( menus[commandM], backtraceCommand );
        EnableItem( menus[commandM], procedureCommand );
        EnableItem( menus[commandM], expressionCommand );
        EnableItem( menus[commandM], localsCommand );
        break;
      case 2:
        DisableItem( menus[fileM], newCommand );
        DisableItem( menus[fileM], openCommand );
        DisableItem( menus[fileM], closeCommand );
        DisableItem( menus[fileM], saveCommand );
        DisableItem( menus[fileM], saveasCommand );
        DisableItem( menus[fileM], revertCommand );
        DisableItem( menus[fileM], quitCommand );
        DisableItem( menus[editM], undoCommand );
        EnableItem( menus[editM], cutCommand );
        EnableItem( menus[editM], copyCommand );
        EnableItem( menus[editM], pasteCommand );
        EnableItem( menus[editM], clearCommand );
        DisableItem( menus[editM], findCommand );
        DisableItem( menus[editM], againCommand );
        DisableItem( menus[editM], balanceCommand );
        DisableItem( menus[commandM], interruptCommand );
        DisableItem( menus[commandM], helpCommand );
        DisableItem( menus[commandM], toplevelCommand );
        DisableItem( menus[commandM], abortCommand );
        DisableItem( menus[commandM], returnCommand );
        DisableItem( menus[commandM], nextCommand );
        DisableItem( menus[commandM], previousCommand );
        DisableItem( menus[commandM], backtraceCommand );
        DisableItem( menus[commandM], procedureCommand );
        DisableItem( menus[commandM], expressionCommand );
        DisableItem( menus[commandM], localsCommand );
        break;
    }
  }

  if (w>=0)
  { register EvQElPtr q;
    for (q = (EvQElPtr)EventQueue.qHead; q != NULL; q = (EvQElPtr)q->qLink)
      if ((q->evtQWhat == keyDown) && ((char)q->evtQMessage == '.') &&
          (q->evtQModifiers & cmdKey))
      { while (GetNextEvent(keyDownMask+keyUpMask+autoKeyMask,&event) &&
               !((event.what == keyDown) && ((event.message & charCodeMask) == '.') &&
                 ((event.modifiers & cmdKey) != 0) )) ;
        interrupt();
        return 0;
      }
  }

  if (GetNextEvent(everyEvent,&event))
  { switch (event.what)
    { case mouseDown:
        switch (FindWindow(event.where,&event_window))
        { case inDesk: 
            SysBeep( 10 );
            break;
          case inGoAway:
            if ((w = wptr_to_id( event_window )) >= 0)
              if (TrackGoAway(event_window,event.where)) handle_close( w );
            break;
          case inMenuBar:
            return handle_menu( MenuSelect(event.where), w );
          case inSysWindow:
            SystemClick(&event,event_window);
            break;
          case inDrag:
            if ((w = wptr_to_id( event_window )) >= 0)
              DragWindow(event_window,event.where,&screenBits.bounds);
            break;
          case inGrow:
            if ((w = wptr_to_id( event_window )) >= 0)
              grow_window( w, event.where );
            break;
          case inContent:
            if (event_window != FrontWindow())
              SelectWindow(event_window);
            else 
              if ((w = wptr_to_id( event_window )) >= 0)
                content( w, &event );
            break;
          default: ;
        }
        break;
      case keyDown:
      case autoKey: 
        if (w >= 0)
        { char c = event.message & charCodeMask;
          if ((event.modifiers & cmdKey) != 0)
          { if (c == '=') c = '+';
            return handle_menu( MenuKey( c ), w );
          }
          else
          { TEHandle hTE = wind_table[w].hTE;
            if (c == 3) /*enter*/
            { int id = (wind_table[w].is_file) ? interaction_id : w;
              int sel_len = (**hTE).selEnd - (**hTE).selStart;
              if (sel_len > 0)
              { int start = (**hTE).selStart;
                TESetSelect( (long)(**hTE).selEnd, (long)(**hTE).selEnd, hTE );
                put_input( id, *((**hTE).hText) + start, sel_len, 1, 0, 1 );
              }
              else
              { int start = balance( w, 0, 1 );
                if (start < 0)
                  SysBeep(10);
                else
                  put_input( id,
                             *((**hTE).hText) + start,
                             (**hTE).selStart - start,
                             1, 0, 1 );
              }
            }
            else if (c == 9) /*tab*/
            { int open_paren = balance( w, 0, 1 );
              int col1 = column( w, open_paren );
              int col2 = column( w, (**hTE).selStart );
              if (col1 < 0) col1 = 0;
              if (col2 > col1)
              { if (check_TEInsert( "\r", 1L, hTE )) goto err;
                col2 = 0;
              }
              while (col2 < col1)
              { long len = (col1-col2 < 80) ? col1-col2 : 80;
                if (check_TEInsert( "                                                                                ",
                                    len, hTE )) goto err;
                col2 += len;
              }
              err:
              show_select( w );
            }
            else if ((c >= 28) && (c <= 31)) /* arrows */
            { TEKey( c, hTE );
              show_select( w );
            }
            else if ((c >= 0) && (c <= 127))
            { char ch = c;
              if (graphic_char(ch))
                ch = ((wind_table[w].bold_input && can_do_bold) ? ch+0x80 : ch);
              else if ((ch!=' ') && (ch!='\r' /*cr*/) && (ch!='\b' /*bs*/))
                ch = -1;
              if (ch != -1)
              { wind_table[w].dirty = 1;
                if ((!check_TEKey( ch, hTE )) && (c == ')'))
                { long open_paren = balance( w, 0, 0 );
                  if (open_paren >= 0)
                  { long selstart = (**hTE).selStart;
                    long now;
                    TESetSelect( open_paren, open_paren+1, hTE );
                    show_select( w );
                    now = TickCount();
                    while (!EventAvail(everyEvent,&event) && ((TickCount()-now)<30)) ;
                    TESetSelect( selstart, selstart, hTE );
                  }
                }
                show_select( w );
              }
            }
          }
        }
        break;
      case activateEvt:
        if ((w = wptr_to_id( (WindowPtr)event.message )) >= 0)
        { GrafPtr save, port = wind_table[w].wptr;
          Rect r = port->portRect;
          r.left = r.right - (SBarWidth+1);
          GetPort( &save );
          SetPort( port );
          InvalRect( &r );
          if ( event.modifiers & activeFlag )
          { TEActivate( wind_table[w].hTE );
            ShowControl( wind_table[w].vscroll );
            TEFromScrap();
          }
          else
          { TEDeactivate( wind_table[w].hTE );
            HideControl( wind_table[w].vscroll );
            ZeroScrap();
            TEToScrap();
          }
          SetPort( save );
        }
        break;
      case updateEvt: 
        if ((w = wptr_to_id( (WindowPtr)event.message )) >= 0)
        { GrafPtr save, port = wind_table[w].wptr;
          Rect r = port->portRect; r.right -= SBarWidth; r.top = r.bottom-SBarWidth;
          GetPort( &save );
          SetPort( port );
          BeginUpdate( port );
          EraseRect( &port->portRect );
          DrawControls( port );
          DrawGrowIcon( port );
          EraseRect( &r );
          TEUpdate( &port->portRect, wind_table[w].hTE );
          EndUpdate( port );
          SetPort( save );
        }
        break;
      default: ;
    }
  }
  return 1;
}

static long wind_read( id, ptr, n )
int id;
char *ptr;
long n;
{ if (n > 0)
  { register int len;
    if ((len = wind_table[id].len - wind_table[id].pos) > 0)
    { register char *p1 = ptr;
      register char *p2 = wind_table[id].buf + wind_table[id].pos;
      register int i = 0;
      if (p2[i] == '\004') { wind_table[id].pos++; return 0; }
      if (len > n) len = n;
      while ((i < len) && (p2[i] != '\004'))
      { register char c = p2[i++] & 0x7f;
        if (c == '\r') c = '\n';
        *p1++ = c;
      }
      wind_table[id].pos += i;
      return i;
    }
    else
      return -1;
  }
  else
    return 0;
}

static long wind_write( id, ptr, n )
int id;
char *ptr;
long n;
{ register char *p1 = ptr, *p2 = ptr+n;
  register int len = wind_table[id].out_len;
  register char *p3 = wind_table[id].out_buf;

  while (p1<p2)
  { register char c = *p1++;
    if (c == '\n') { p3[len++] = '\r'; goto output; }
    p3[len++] = c;
    if (len == OUT_BUF_LEN)
    { output:
      if (check_TEInsert( p3, (long)len, wind_table[id].hTE )) return n;
      show_select( id );
      wind_table[id].out_len = 0;
      len = 0;
    }
  }

  wind_table[id].out_len = len;

  return n;
}

/*---------------------------------------------------------------------------*/

#include "struct.h"

#define TICKS_PER_SEC 60

#define MAC_HEAP_LEN_IN_K 80 /* leave at least 80K free for Mac heap */
#define MAC_STACK_LEN_IN_K 8 /* leave this much stack space for Mac calls */

long link_stack_length_in_k = -1;
long link_heap_length_in_k = -1;
long link_const_length_in_k = -1;

short *link_ofiles[] =
{ (short *)"      ", (short *)"      ", (short *)"      ", (short *)"      ",
  (short *)"      ", (short *)"      ", (short *)"      ", (short *)"      ",
  (short *)"      ", (short *)"      ", (short *)"      ", (short *)"      ",
  (short *)"      ", (short *)"      ", (short *)"      ", (short *)"      ",
  (short *)"      ", (short *)"      ", (short *)"      ", (short *)"      ",
  (short *)"      ", (short *)"      ", (short *)"      ", (short *)"      ",
  (short *)"      ", (short *)"      ", (short *)"      ", (short *)"      ",
};

static long sizeof_ofiles[] =
{ 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
  0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L
};

long *link_sizeof_ofiles[] =
{ &sizeof_ofiles[0], &sizeof_ofiles[1], &sizeof_ofiles[2], &sizeof_ofiles[3],
  &sizeof_ofiles[4], &sizeof_ofiles[5], &sizeof_ofiles[6], &sizeof_ofiles[7],
  &sizeof_ofiles[8], &sizeof_ofiles[9], &sizeof_ofiles[10], &sizeof_ofiles[11],
  &sizeof_ofiles[12], &sizeof_ofiles[13], &sizeof_ofiles[14], &sizeof_ofiles[15],
  &sizeof_ofiles[16], &sizeof_ofiles[17], &sizeof_ofiles[18], &sizeof_ofiles[19],
  &sizeof_ofiles[20], &sizeof_ofiles[21], &sizeof_ofiles[22], &sizeof_ofiles[23],
  &sizeof_ofiles[24], &sizeof_ofiles[25], &sizeof_ofiles[26], &sizeof_ofiles[27],
};

long link_nb_ofiles;

long prog_len;


long start_real_time;


long os_nb_processors()
{ return 1;
}


long os_fork_on_processors( n )
long n;
{ return 0;
}


static char *malloc8( length ) /* alloc of blocks starting at an octuple adr */
long length;
{ char *ptr;
  long free = CompactMem( length );
  if (free < length) return NULL;
  ptr = (char *)NewPtr( length+7 );
  if (ptr != NULL) ptr = (char *) ceiling8(ptr); /* get octuple addr. */
  return ptr;
}


char *os_shared_malloc8( len, processor )
long len;
long processor;
{ return (char *)malloc8( len );
}


char *os_shared_copy_malloc8( len_share, len_copy, processor )
long len_share, len_copy;
long processor;
{ long aligned_len_share = ceiling8( len_share );
  long len = aligned_len_share + len_copy;
  char *ptr = malloc8( len );
  if (ptr != NULL) ptr = ptr + aligned_len_share - len_share;
  return ptr;
}


void os_block_copy( src, dst, len )
char *src, *dst;
long len;
{ register char *p1 = src, *p2 = dst;
  register long i = len;
  while (i > 0) { *(p2++) = *(p1++); i--; }
}


void os_flush_caches()
{
#define INSTR_CACHE_LENGTH_IN_K 64
#define DATA_CACHE_LENGTH_IN_K  8

  short *start = (short *)pstate->heap_old;
  short *p = start;
  long i;

  for (i=((long)INSTR_CACHE_LENGTH_IN_K)*K/2-1; i>0; i--) *p++ = NOP_OP;
  *p++ = RTS_OP;
  for (i=((long)DATA_CACHE_LENGTH_IN_K)*K/2; i>0; i--) *p++ = 0;

  ((void (*)())start)();
}


void os_flush_writes()
{
}


long os_clock()
{ return TickCount() - start_real_time;
}


long os_real_time_clock()
{ return TickCount() - start_real_time;
}


long os_clock_to_msec( ticks )
long ticks;
{ return ticks * 1000 / TICKS_PER_SEC;
}


void os_cpu_times( buf )
long *buf;
{ buf[0] = (TickCount() - start_real_time) * 1000 / TICKS_PER_SEC;
  buf[1] = 0;
}


void os_profil( buff, bufsiz, offset, shift )
short *buff;
long bufsiz, offset;
long shift;
{
}


long os_ticks_to_msec( ticks )
long ticks;
{ return ticks * 1000 / TICKS_PER_SEC;
}


static void fatal_signal( pc, sp, kind )
long pc, sp;
char *kind;
{ os_warn( "Fatal signal %s, terminating...\n", (long)kind );
  os_quit();
}


void os_install_trap_handlers( intr_proc, timer_proc, io_proc, fatal_proc )
void (*intr_proc)();
void (*timer_proc)();
void (*io_proc)();
void (*fatal_proc)();
{ /* On the Mac, the stack cannot reside in the heap (otherwise the stack  */
  /* sniffer will think the stack has overflowed).  To circumvent this, we */
  /* overlap the C stack and the Scheme stack.                             */
  long dummy;
  long *new_stack_top = (long *)ceiling8(((long)&dummy)-((long)MAC_STACK_LEN_IN_K)*K);
  long offs = new_stack_top - pstate->stack_top;
  pstate->stack_bot += offs;
  pstate->stack_top += offs;

  intr_action = intr_proc;
  timer_action = timer_proc;
  io_action = io_proc;
  if (fatal_proc != (void (*)())0)
    fatal_action = fatal_proc;
  else
    fatal_action = fatal_signal;

  start_intr_task();
}


long os_poll_events( result )
long *result;
{ handle_next_event();
  return 0;
}


char *os_expand_filename( str )
char *str;
{ return str;
}


struct {
  int type; /* -1 = not in use, 0 = text file, 1 = bin file, 2 = resource, 3 = window */
  long pos;
  int refnum;
  } os_file[MAX_NB_OPEN_FILES];


int appl_res_file;
Handle appl_res_map;

static int read_resource( type, id, n, ptr )  /* Ugly, but works... */
ResType type;
int id;
long n;
char *ptr;
{ int i, j;
  long count;
  struct type_list_rec { short id, name_offs; long data_offs, reserved; };
  struct map_entry_rec { ResType type; short nb_minus_1; short offs; };
  struct map_rec
  { char pad[24]; short type_list_offs, name_list_offs, nb_minus_1;
    struct map_entry_rec entry[1];
  };
  struct map_rec *map = (struct map_rec *)*appl_res_map;

  i = map->nb_minus_1;
  while (i >= 0)
  { if (map->entry[i].type == type)
    { struct type_list_rec *item = (struct type_list_rec *)(((char *)map)+map->type_list_offs+map->entry[i].offs);
      j = map->entry[i].nb_minus_1;
      while (j >= 0)
	  { if (item[j].id == id)
	    { if (SetFPos( appl_res_file, 1, item[j].data_offs + 260L ) != noErr) return 0;
	      count = n;
	      if (FSRead( appl_res_file, &count, ptr ) != noErr) return 0;
	      return 1;
	    }
	    j--;
	  }
	}
    i--;
  }
  return 0;
}


static long file_open( name, for_output )
char *name;
long for_output;
{ long i;
  for (i=0; i<(long)MAX_NB_OPEN_FILES; i++) if (os_file[i].type < 0) break;
  if (i == (long)MAX_NB_OPEN_FILES) return -1;

  if (name[0] == 1) /* opening 'gamO' resource */
  { Handle h;
    int j = 1, n = 0;
    if (for_output) return -1;
    while ((name[j]>='0') && (name[j]<='9')) n = n*10 + (name[j++] - '0');
    SetResLoad( FALSE );
    h = GetResource( 'gamO', n );
    SetResLoad( TRUE );
    if (h == NULL) return -1;
    ReleaseResource( h );
    os_file[i].type   = 2;
    os_file[i].refnum = n;
    os_file[i].pos    = 0;
  }
  else if (name[0] == 2) /* opening window */
  { os_file[i].refnum = wind_open( name+1 );
    if (os_file[i].refnum < 0) return -1;
    os_file[i].type = 3;
  }
  else
  { int io;
    int bin, len;
    char pname[256];
    c_to_p( name, pname );
    len = pname[0];
    bin = ((len >= 2) && (pname[len-1] == '.') && (pname[len] == 'O'));
    os_file[i].refnum = open_file( pname, 0, (int)for_output, !bin, &io );
    if (os_file[i].refnum == -1) return -1;
    os_file[i].type = bin;
  }

  return i;
}

long lazy_create_wind( f )
OS_FILE f;
{ if ((f == 0) && (os_file[f].refnum == -1))
  { os_file[0].refnum = wind_open( "Interaction" );
    if (os_file[0].refnum < 0) return 0;
    interaction_id = os_file[0].refnum;
    wind_table[os_file[0].refnum].bold_input = 1;
  }
  return 1;
}
  
OS_FILE os_file_open_input( name )
char *name;
{ return (OS_FILE)file_open( name, 0L );
}


OS_FILE os_file_open_output( name )
char *name;
{ return (OS_FILE)file_open( name, 1L );
}


OS_FILE os_file_open_input_output( name )
char *name;
{ return (OS_FILE)file_open( name, 1L );
}


long os_file_length( f )
OS_FILE f;
{ long len;
  switch (os_file[f].type)
  { case 0:
    case 1:
    { if (GetEOF( os_file[f].refnum, &len ) != noErr) return -1;
      break;
    }
    case 2:
    { Handle h;
      SetResLoad( FALSE );
      h = GetResource( 'gamO', os_file[f].refnum );
      SetResLoad( TRUE );
      if (h == NULL) return -1;
      len = SizeResource( h );
      ReleaseResource( h );
      break;
    }
    case 3:
      return -1;
    default:
      return -1;
  }
  return len;
}


long os_file_read_ready( f )
OS_FILE f;
{ return 1;
}


long os_file_read( f, ptr, n )
OS_FILE f;
char *ptr;
long n;
{ switch (os_file[f].type)
  { case 0:
    case 1:
    { long count = n;
      FSRead( os_file[f].refnum, &count, ptr );
      if (os_file[f].type == 0)
      { register char *p = ptr;
        register long len = count;
        while (len-- > 0) { if (*p == '\r') *p = '\n'; p++; }
      }
      return count;
    }
    case 2:
      if (read_resource( 'gamO', os_file[f].refnum, n, ptr ))
        return n;
      else
        return -1;
    case 3:
      if (lazy_create_wind( f ) && os_file_read_ready( f ))
        return wind_read( os_file[f].refnum, ptr, n );
      else
        return -1;
    default:
      return -1;
  }
}


long os_file_write( f, ptr, n )
OS_FILE f;
char *ptr;
long n;
{ switch (os_file[f].type)
  { case 0:
    { char buffer[1024+8];
      register char *p1 = ptr, *p2 = ptr+n;
      register int len = 0;

      while (p1<p2)
      { register char c = *p1++;
        if (c == '\n') buffer[len++] = '\r'; else buffer[len++] = c;
        if (len == 1024)
        { long count = len;
          FSWrite( os_file[f].refnum, &count, buffer );
          if (count != len) return (p1-ptr)-len+count;
          len = 0;
        }
      }
      if (len > 0)
      { long count = len;
        FSWrite( os_file[f].refnum, &count, buffer );
        if (count != len) return (p1-ptr)-len+count;
      }
      return (p1-ptr);
    }
    case 1:
    { long count = n;
      FSWrite( os_file[f].refnum, &count, ptr );
      return count;
    }
    case 2:
      return -1;
    case 3:
      if (lazy_create_wind( f ))
        return wind_write( os_file[f].refnum, ptr, n );
      else
        return -1;
    default:
      return -1;
  }
}


long os_file_close( f )
OS_FILE f;
{ switch (os_file[f].type)
  { case 0:
    case 1:
    { int io;
      os_file[f].type = -1;
      if (close_file( os_file[f].refnum, 0, &io )) return -1;
      return 0;
    }
    case 2:
    { os_file[f].type = -1;
      return 0;
    }
    case 3:
    { if (os_file[f].refnum == interaction_id) return -1;
      if (os_file[f].refnum < 0) return -1;
      os_file[f].type = -1;
      wind_close( os_file[f].refnum );
      return 0;
    }
    default:
      return -1;
  }
}


void os_file_block_read( f )
OS_FILE f;
{ handle_next_event();
}


extern void os_set_timer_interval( interval )
long interval;
{ intr_task_interval = (interval * TICKS_PER_SEC + 999) / 1000;
}


void os_quit()
{ int i;
  long ticks;
  stop_intr_task();
  for (i=MAX_NB_OPEN_FILES-1; i>=0; i--) os_file_close( (OS_FILE)i );
  if (abnormal_exit) Delay( 120, &ticks );
  wind_end();
  ExitToShell();
}


static void os_notify_gc_begin_internal()
{ SetCursor( &gc_cursor );
}


static void os_notify_gc_end_internal()
{ SetCursor( current_cursor );
}


extern void main_gambit();


#define MAX_ARGS 25

static int main_internal( argc, argv, envp )
int argc;
char *argv[], *envp[];
{ char new_args[256];
  int new_argc;
  char *new_argv[MAX_ARGS+1];
  char *new_envp[1] = { NULL };
  SysEnvRec sysenv;
  Handle h;
  int i;
  long const_len;
  DialogPtr dp;
  KeyMap km;
  THz heap = ApplicZone();

  long stack_len = ((long)DEFAULT_STACK_LENGTH_IN_K)*K;

  long appl_limit = (((long)new_args) - stack_len - ((long)MAC_STACK_LEN_IN_K)*K) & -4L;

  appl_res_file = CurResFile();
  appl_res_map = TopMapHndl;

  SetApplLimit( appl_limit );
  MaxApplZone();
  MoreMasters();
  MoreMasters();
  CouldAlert( ok_alertID );
  SetGrowZone( mem_full_err );

  wind_begin();

  p_to_c( CurApName, new_args );
  new_argc = 0;
  new_argv[new_argc++] = new_args;
  GetKeys( &km );
  if ((km.Key[0]|km.Key[1]|km.Key[2]|km.Key[3]) ||
      (CurApName[CurApName[0]] == ' '))
  { char *p = new_args;
    while (*p++ != '\0') ;
    ParamText( "\pParameters to \"", CurApName, "\p\":", "\p" );
    dp = GetNewDialog( string_dlogID, 0L, -1L );
    if (dp == NULL) return 0;
    ModalDialog( 0L, &i );
    { Str255 s;
      Rect r;
      GetDItem( dp, 3, &i, &h, &r );
      GetIText( h, s );
      p_to_c( s, p );
      while ((*p != '\0') && (new_argc<=MAX_ARGS))
        if (*p == ' ')
          *p++ = '\0';
        else
        { new_argv[new_argc++] = p;
          while ((*p != ' ') && (*p != '\0')) p++;
        }
    }
    CloseDialog( dp );
  }
  new_argv[new_argc] = NULL;

  for (i=0; i<MAX_NB_OPEN_FILES; i++) os_file[i].type = -1;
  os_file[0].type   = 3;
  os_file[0].refnum = -1;

  i = 128;
  const_len = 0;
  link_nb_ofiles = 0;
  again:
  SetResLoad( FALSE ); h = GetResource( 'gamO', i ); SetResLoad( TRUE );
  if (h != NULL)
  { int j = 0, d = 10000, n = i;
    ((char *)link_ofiles[link_nb_ofiles])[j++] = 1;
    while (d>0)
    { ((char *)link_ofiles[link_nb_ofiles])[j++] = n/d + '0'; n = n%d; d = d/10; }
    ((char *)link_ofiles[link_nb_ofiles])[j++] = '\0';
    const_len += SizeResource(h);
    ReleaseResource( h );
    link_nb_ofiles++;
    i++;
    goto again;
  }

  { int msg, count;
    CountAppFiles( &msg, &count );
    if (msg == appOpen)
    { for (i=1; i<=count; i++)
      { int w;
        char name[256];
        AppFile file_info;
        GetAppFiles( i, &file_info );
        if (file_info.fType == 'TEXT')
        { p_to_c( file_info.fName, name );
          w = wind_open( name );
          if (w < 0)
          { wind_err(); break; }
          else
          { wind_table[w].is_file = 1;
            p_to_p( file_info.fName, wind_table[w].filename );
            wind_table[w].vrefnum = file_info.vRefNum;
            read_file( w );
            ClrAppFiles( i );
          }
        }
        else if (file_info.fType == 'gamO')
        { char *ofile;
          long count;
          int refnum;
          int io;
          io = FSOpen( file_info.fName, file_info.vRefNum, &refnum );
          if (io != noErr) { io_err( io ); return 0; }
          io = GetEOF( refnum, &prog_len );
          if (io != noErr) { FSClose( refnum ); io_err( io ); return 0; }
          ofile = NewPtr( prog_len );
          if (ofile == NULL) return 0;
          count = prog_len;
          io = FSRead( refnum, &count, ofile );
          if ((io != noErr) || (count != prog_len)) { FSClose( refnum ); io_err( io ); return 0; }
          FSClose( refnum );
          link_ofiles[link_nb_ofiles-1] = (short *)ofile;
          link_sizeof_ofiles[link_nb_ofiles-1] = &prog_len;
          const_len += prog_len;
          ClrAppFiles( i );
          break;
        }
      }
    }
  }

 const_len += ((long)ADDITIONAL_CONST_LENGTH_IN_K)*K;

{ long max_block = CompactMem( 1L<<24 );

  long system_mem_len =
    ceiling8( sizeof(struct sstate_rec) ) +
    ((long)MAX_NB_GLOBALS)*sizeof(struct global_rec) +
    ((long)MAX_NB_GLOBALS)*sizeof(short) +
    ((long)NB_TRAPS)*sizeof(struct trap_rec) +
    ceiling8( const_len );

  long processor_mem_len =
    ((long)LOCAL_HEAP_LENGTH_IN_K)*K +
    ceiling8( ((long)MAX_NB_EVENTS)*sizeof(long) ) +
    stack_len +
    ceiling8( ((long)MAX_NB_STATS)*sizeof(long) ) +
    ceiling8( ((long)MAX_EMUL_CODE_LENGTH_IN_K)*K ) +
    ceiling8( sizeof(struct pstate_rec) );

  long min_required_len = system_mem_len + processor_mem_len + ((long)MIN_HEAP_LENGTH_IN_K)*K;

  long free_mem_len = max_block - ((long)MAC_HEAP_LEN_IN_K)*K - min_required_len;

  long heap_mem_len = ((long)MIN_HEAP_LENGTH_IN_K)*K + free_mem_len*14/16;

  long const_mem_len = const_len + free_mem_len*1/16;

  if (link_stack_length_in_k < 0)
    link_stack_length_in_k = stack_len/K;
  if (link_heap_length_in_k < 0)
    link_heap_length_in_k = heap_mem_len/K;
  if (link_const_length_in_k < 0)
    link_const_length_in_k = const_mem_len/K;
}

  SysEnvirons( curSysEnvVers, &sysenv );
  os_M68020 = (sysenv.processor >= env68020);
  os_M68881 = sysenv.hasFPU;
  os_stdin  = 0;
  os_stdout = 0;
  os_stderr = 0;

  start_real_time = TickCount();

  SetCursor( current_cursor );

  main_gambit( new_argc, new_argv, new_envp );

  return 0;
}


/*--------------------------------------------------------------------------*/
