#ifdef butterfly
#define read_and_clear(adr,var)     { var = (long)atomand32((long *)(adr),0); }
#define read_and_set(adr,var)       { var = (long)atomior32((long *)(adr),-1); }
#define read_and_lock(adr,var)      { long temp; while ((temp=(long)atomior32((long *)(adr),-1))==-1); var = temp; }
#define unlock(adr,val)             { *((long *)(adr)) = (long)(val); }
#define store_and_unlock(adr,val)   { *((long *)(adr)) = (long)(val); }
#define spin_lock_set(adr)          { while (atomior32((long *)(adr),-1)<0); }
#define spin_lock_reset(adr)        { *((long *)(adr)) = 0; }
#else
#define read_and_clear(adr,var)     { var = *((long *)(adr)); *((long *)(adr)) = 0; }
#define read_and_set(adr,var)       { var = *((long *)(adr)); *((long *)(adr)) = -1; }
#define read_and_lock(adr,var)      { var = *((long *)(adr)); }
#define unlock(adr,val)             { }
#define store_and_unlock(adr,val)   { *((long *)(adr)) = (long)(val); }
#define spin_lock_set(adr)          { *((long *)(adr)) = -1; }
#define spin_lock_reset(adr)        { *((long *)(adr)) = 0; }
#endif

typedef long OS_FILE;

extern OS_FILE os_stdin, os_stdout, os_stderr;
extern long os_M68020, os_M68881;
extern char *os_err;

extern void os_file_printf( /* f, str, val */ );
extern void os_warn( /* msg, val */ );
extern void os_notify_gc_begin( /* id, report */ );
extern void os_notify_gc_end( /* id, heap_mid, heap_bot, free_bot, free_top, report */ );

extern void os_quit();
extern long os_nb_processors();
extern long os_fork_on_processors( /* n */ );

extern char *os_shared_malloc8( /* len, processor */ );
extern char *os_shared_copy_malloc8( /* len_share, len_copy, processor */ );
extern void os_block_copy( /* src, dst, len */ );
extern void os_flush_caches();
extern void os_flush_writes();

extern long os_clock();
extern long os_real_time_clock();
extern long os_clock_to_msec( /* ticks */ );
extern void os_cpu_times( /* buf */);
extern void os_profil( /* buff, bufsiz, offset, scale */ );
extern long os_ticks_to_msec( /* ticks */ );

extern void os_install_trap_handlers( /* intr_proc, timer_proc, io_proc, fatal_proc */ );
extern void os_set_timer_interval( /* interval */ );
extern long os_poll_events( /* result */ );

extern char *os_expand_filename( /* name */ );
extern OS_FILE os_file_open_input( /* name */ );
extern OS_FILE os_file_open_output( /* name */ );
extern OS_FILE os_file_open_input_output( /* name */ );
extern long os_file_length( /* f */ );
extern long os_file_read_ready( /* f */ );
extern long os_file_read( /* f, ptr, n */ );
extern long os_file_write( /* f, ptr, n */ );
extern long os_file_close( /* f */ );
extern void os_file_block_read( /* f */ );

extern void ext_init();
