#!/bin/sh
# Configuration script for MIT Scheme
# $Header: /scheme/src/microcode/RCS/config.sh,v 1.14 1991/10/17 08:21:11 cph Exp $
# Modelled on the configuration script for GNU CC
#   Copyright (C) 1988 Free Software Foundation, Inc.

#This file is part of GNU CC.

#GNU CC is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 1, or (at your option)
#any later version.

#GNU CC is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with GNU CC; see the file COPYING.  If not, write to
#the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

#
# Shell script to create proper links to machine-dependent files in
# preparation for compiling gcc.
#
# Usage: config.sh machine
#
# If config.sh succeeds, it leaves its status in config.status.
# If config.sh fails after disturbing the status quo, 
# 	config.status is removed.
#

progname=$0

remove=rm
hard_link=ln
symbolic_link='ln -s'

#for Test
#remove="echo rm"
#hard_link="echo ln"
#symbolic_link="echo ln -s"

cmpint_file=nothing_special
cmp_file=nothing_special

case $# in
1)
	machine=$1

	case $machine in
	vax-bsd42)			# vaxen running 4.2BSD
		system_file=bsd4-2
		machine_file=vax
		cmpint_file=cmpint-vax.h
		;;
	vax-bsd43)			# vaxen running 4.3BSD
		system_file=bsd4-3
		machine_file=vax
		cmpint_file=cmpint-vax.h
		;;
	vax-ultrix)			# vaxen running ultrix
		system_file=ultrix
		machine_file=vax
		cmpint_file=cmpint-vax.h
		;;
	mips-ultrix | dec-3100 | dec-5100 | pmax)
		system_file=ultrix
		machine_file=mips
		cmpint_file=cmpint-mips.h
		;;
	nws3250)			# sony news laptop
		system_file=sysv4
		machine_file=mips
		cmpint_file=cmpint-mips.h
		;;
	hp9k300)			# HP9000 series 300
		system_file=hpux
		machine_file=hp9k300
		cmpint_file=cmpint-mc68k.h
		;;
	hp9k400)			# HP9000 series 400
		system_file=hpux
		machine_file=hp9k400
		cmpint_file=cmpint-mc68k.h
		;;
	hp9k800 | hp9k700)		# HP9000 series 800
		system_file=hpux
		machine_file=hp9k800
		cmpint_file=cmpint-hppa.h
		;;
	i386-sysv)
		system_file=sysv3
		machine_file=i386
		;;
	sun3)
		system_file=sunos4
		machine_file=sun3
		cmpint_file=cmpint-mc68k.h
		cmp_file=cmpaux/sun3.s
		cmp_link=cmpaux-mc68k.s
		;;
	sun3-os3)			# sun3, pre-4.0 sunos
		system_file=sunos3
		machine_file=sun3
		cmpint_file=cmpint-mc68k.h
		cmp_file=cmpaux/sun3.s
		cmp_link=cmpaux-mc68k.s
		;;
	sun3-nfp)			# sun3, No Floating Point
		system_file=sunos4
		machine_file=sun3
		cmpint_file=cmpint-mc68k.h
		cmp_file=cmpaux/sun3-nfp.s
		cmp_link=cmpaux-mc68k.s
		;;
	sun3-os3-nfp)			# sun3, pre-4.0 sunos, No Floating Point
		system_file=sunos3
		machine_file=sun3
		cmpint_file=cmpint-mc68k.h
		cmp_file=cmpaux/sun3-nfp.s
		cmp_link=cmpaux-mc68k.s
		;;
	sun4) 
		system_file=sunos4
		machine_file=sun4 
		;;
	next)
		system_file=next-mach
		machine_file=next
		cmpint_file=cmpint-mc68k.h
		cmp_file=cmpaux/sun3-gcc.s
		cmp_link=cmpaux-mc68k.s
		;;
	umax)				# Encore Multimax
	    	system_file=umax
		machine_file=umax
		;;
	*)
		echo "$progname: unknown machine name: $machine"
		exit 1
	esac

	files="s/${system_file}.h m/${machine_file}.h"
	links="s.h m.h"

	while [ -n "$files" ]
	do
		# set file to car of files, files to cdr of files
		set $files; file=$1; shift; files=$*
		set $links; link=$1; shift; links=$*

		if [ ! -r $file ]
		then
			echo "$progname: cannot create a link \`$link',"
			echo "since the file \`$file' does not exist."
			exit 1
		fi

		$remove -f $link
		rm -f config.status
		# Make a symlink if possible, otherwise try a hard link
		$symbolic_link $file $link 2>/dev/null || $hard_link $file $link

		if [ ! -r $link ]
		then
			echo "$progname: unable to link \`$link' to \`$file'."
			exit 1
		fi
		echo "Linked \`$link' to \`$file'."
	done

	case $cmpint_file in
	nothing_special)
		;;
	*)
		$symbolic_link $cmpint_file cmpint2.h 2>/dev/null || $hard_link $cmpint_file cmpint2.h
		if [ ! -r cmpint2.h ]
		then
			echo "$progname: unable to link \`cmpint2.h' to \`$cmpint_file'."
			exit 1
		fi
		echo "Linked \`cmpint2.h' to \`$cmpint_file'."
		;;
	esac

	case $cmp_file in
	nothing_special)
		;;
	*)
		$symbolic_link $cmp_file $cmp_link 2>/dev/null || $hard_link $cmp_file $cmp_link
		if [ ! -r $cmp_link ]
		then
			echo "$progname: unable to link \`$cmp_link' to \`$cmp_file'."
			exit 1
		fi
		echo "Linked \`$cmp_link' to \`$cmp_file'."
		;;
	esac

	echo "Links are now set up for use with a $machine." \
		| tee config.status
	exit 0

	;;
*)
	echo "Usage: $progname machine"
	echo "Where \`machine' is one of:"
	echo "vax-bsd42 vax-bsd43 vax-ultrix mips-ultrix"
	echo "nws3250 hp9k300 hp9k400 hp9k700 hp9k800 i386-sysv"
	echo "sun3 sun3-os3 sun3-nfp sun3-os3-nfp sun4 umax next"
	if [ -r config.status ]
	then
		cat config.status
	fi
	exit 1
	;;
esac
