/* File: sather/sys/C/rt_sux_.c
   Author: Heinz W. Schmidt
   Created: Wed May 22 14:12:40 1991
   Copyright (C) International Computer Science Institute, 1991

   COPYRIGHT NOTICE: This code is provided "AS IS" WITHOUT ANY WARRANTY
   and is subject to the terms of the SATHER LIBRARY GENERAL PUBLIC
   LICENSE contained in the file: "sather/doc/license.txt" of the Sather
   distribution. The license is also available from ICSI, 1947 Center
   St., Suite 600, Berkeley CA 94704, USA.
 ** RCS: $Id: rt_sux_.c,v 0.24 1992/06/29 13:24:38 hws Exp $
 ** HISTORY:
 ** Last edited: Jun 29 23:24 1992 (hws)
 **  Jun 29 23:21 1992 (hws): use mapped (c_name) sux22_create SUX::create
*/ 
/* We cannot compile the complete runtime system on some suns due to asm */
/* memory problems. */

#include "all_.h"
#include <memory.h>
#include <string.h>
#include <stdio.h>

#include "macros_.h"

#include <signal.h>

/* Sys V have variation in codes and names. We always initialize at runtime. */
/* EH_N_SIGNALS number of signals */
/* EH_SUX_ATOMIC whether SUX instances have no pointers in them */

#define EH_N_SIGNALS 32
#define EH_SUX_ATOMIC 1
#define EH_UNDEF (-1)
#define EH_SIG_ERR (int (*)())-1

char *eh_signal_type_[EH_N_SIGNALS];
char *eh_signal_doc_[EH_N_SIGNALS];

char *eh_signal_type_str_(b)
     int b;
{ return(eh_signal_type_[b]); };

char *eh_signal_doc_str_(b)
{ return(eh_signal_doc_[b]); }

eh_signal_setup_(code,type,doc)
     int code;
     char *type,*doc;
{ eh_signal_type_[code] = type;
  eh_signal_doc_[code] = doc;
}

void eh_restore_sigquit()
{  signal(SIGQUIT, EH_SIG_ERR); 
   kill(getpid (), SIGQUIT);
 }

#include <signal.h>
/* * Last edited: Mar 29 21:20 1992 (hws) */

extern ptr sux22_create();

void eh_signal_sux_(b)  /* called by system when terminating signal detected */
     int b;
{
  EH_THROW(sux22_create(S_ptr_VOID_,b));
  /* Normally we should not end up here, just in case */
  fprintf(stderr,"Runtime system error, unable to pass on signal %d\n",b);
  exit(-1);
}

void eh_expect_signal_(b)
     int b;
{
  if ( b<1||b>(EH_N_SIGNALS-1) ) 
    { fprintf(stderr,"(C::eh_signal_sux_) signal code out of range %d.\n",b);
      exit(-1);
    }
  if (eh_signal_type_[b]==(char *)0) 
    { fprintf(stderr,"(C::eh_signal_sux_) non-existent signal %d.\n",b); 
      exit(-1);
    }
  signal (b,eh_signal_sux_);  
}

int SIGHUP_ = EH_UNDEF;
int SIGINT_ = EH_UNDEF;
int SIGQUIT_ = EH_UNDEF;
int SIGILL_ = EH_UNDEF;
int SIGTRAP_ = EH_UNDEF;
int SIGIOT_ = EH_UNDEF;
int SIGABRT_ = EH_UNDEF;
int SIGEMT_ = EH_UNDEF;
int SIGFPE_ = EH_UNDEF;
int SIGKILL_ = EH_UNDEF;
int SIGBUS_ = EH_UNDEF;
int SIGSEGV_ = EH_UNDEF;
int SIGSYS_ = EH_UNDEF;
int SIGPIPE_ = EH_UNDEF;
int SIGALRM_ = EH_UNDEF;
int SIGTERM_ = EH_UNDEF;
int SIGURG_ = EH_UNDEF;
int SIGSTOP_ = EH_UNDEF;
int SIGTSTP_ = EH_UNDEF;
int SIGCONT_ = EH_UNDEF;
int SIGCHLD_ = EH_UNDEF;
int SIGCLD_ = EH_UNDEF;
int SIGTTIN_ = EH_UNDEF;
int SIGTTOU_ = EH_UNDEF;
int SIGIO_ = EH_UNDEF;
int SIGPOLL_ = EH_UNDEF;

eh_signals_init_()
{
  int i;
  for (i = 0; i < EH_N_SIGNALS; i++)
    eh_signal_type_[i] = (char *)0;
#ifdef SIGHUP
  eh_signal_setup_(SIGHUP,"SIGHUP","hangup");
#endif
#ifdef SIGINT
  eh_signal_setup_(SIGINT,"SIGINT","interrupt"); 
  SIGINT_ = SIGINT;
#endif
#ifdef SIGQUIT
  eh_signal_setup_(SIGQUIT,"SIGQUIT","quit"); 
  SIGQUIT_ = SIGQUIT;
#endif
#ifdef SIGILL
  eh_signal_setup_(SIGILL,"SIGILL","illegal instruction (not reset when caught)");
  SIGILL_ = SIGILL;
#endif
#ifdef SIGTRAP
  eh_signal_setup_(SIGTRAP,"SIGTRAP","trace trap (not reset when caught)");
  SIGTRAP_ = SIGTRAP;
#endif
#ifdef SIGIOT
  eh_signal_setup_(SIGIOT,"SIGIOT","IOT instruction");
  SIGIOT_ = SIGIOT;
#endif
#ifdef SIGABRT
  eh_signal_setup_(SIGABRT,"SIGABRT","used by abort, replace SIGIOT in the future");
  SIGABRT_ = SIGABRT;
#endif
#ifdef SIGEMT
  eh_signal_setup_(SIGEMT,"SIGEMT","EMT instruction");
  SIGEMT_ = SIGEMT;
#endif
#ifdef SIGFPE
  eh_signal_setup_(SIGFPE,"SIGFPE","floating point exception");
  SIGFPE_ = SIGFPE;
#endif
#ifdef SIGKILL
  eh_signal_setup_(SIGKILL,"SIGKILL","kill (cannot be caught or ignored)");
  SIGKILL_ = SIGKILL;
#endif
#ifdef SIGBUS
  eh_signal_setup_(SIGBUS,"SIGBUS","bus error");
  SIGBUS_ = SIGBUS;
#endif
#ifdef SIGSEGV
  eh_signal_setup_(SIGSEGV,"SIGSEGV","segmentation violation");
  SIGSEGV_ = SIGSEGV;
#endif
#ifdef SIGSYS
  eh_signal_setup_(SIGSYS,"SIGSYS","bad argument to system call");
  SIGSYS_ = SIGSYS;
#endif
#ifdef SIGPIPE
  eh_signal_setup_(SIGPIPE,"SIGPIPE","write on a pipe with no one to read it");
  SIGPIPE_ = SIGPIPE;
#endif
#ifdef SIGALRM
  eh_signal_setup_(SIGALRM,"SIGALRM","alarm clock");
  SIGALRM_ = SIGALRM;
#endif
#ifdef SIGTERM
  eh_signal_setup_(SIGTERM,"SIGTERM","software termination signal from kill");
  SIGTERM_ = SIGTERM;
#endif
#ifdef SIGURG
  eh_signal_setup_(SIGURG,"SIGURG","urgent condition on IO channel");
  SIGURG_ = SIGURG;
#endif
#ifdef SIGSTOP
  eh_signal_setup_(SIGSTOP,"SIGSTOP","sendable stop signal not from tty");
  SIGSTOP_ = SIGSTOP;
#endif
#ifdef SIGTSTP
  eh_signal_setup_(SIGTSTP,"SIGTSTP","stop signal from tty");
  SIGTSTP_ = SIGTSTP;
#endif
#ifdef SIGCONT
  eh_signal_setup_(SIGCONT,"SIGCONT","continue a stopped process");
  SIGCONT_ = SIGCONT;
#endif
#ifdef SIGCHLD
  eh_signal_setup_(SIGCHLD,"SIGCHLD","to parent on child stop or exit");
  SIGCHLD_ = SIGCHLD;
#endif
#ifdef SIGCLD
  eh_signal_setup_(SIGCLD,"SIGCLD","System V name for SIGCHLD");
  SIGCLD_ = SIGCLD;
#endif
#ifdef SIGTTIN
  eh_signal_setup_(SIGTTIN,"SIGTTIN","to readers pgrp upon background tty read");
  SIGTTIN_ = SIGTTIN;
#endif
#ifdef SIGTTOU
  eh_signal_setup_(SIGTTOU,"SIGTTOU","like TTIN for output if (tp->t_local&LTOSTOP)");
  SIGTTOU_ = SIGTTOU;
#endif
#ifdef SIGIO
  eh_signal_setup_(SIGIO,"SIGIO","input/output possible signal");
  SIGIO_ = SIGIO;
#endif
#ifdef SIGPOLL
  eh_signal_setup_(SIGPOLL,"SIGPOLL","System V name for SIGIO");
  SIGPOLL_ = SIGPOLL;
#endif
}

/* EOF rt_sux */
