/* * Last edited: Mar 12 13:20 1992 (hws) */
/* File: sather/sys/C/macros_.c
   Author: Stephen M. Omohundro
   Created: Thu Sep 20 15:45:25 1990
   Copyright (C) International Computer Science Institute, 1990

   COPYRIGHT NOTICE: This code is provided "AS IS" WITHOUT ANY WARRANTY
   and is subject to the terms of the SATHER LIBRARY GENERAL PUBLIC
   LICENSE contained in the file: "sather/doc/license.txt" of the Sather
   distribution. The license is also available from ICSI, 1947 Center
   St., Suite 600, Berkeley CA 94704, USA.

   Macros to directly define certain primitive  C function calls which 
   are generated by the Sather compiler.
*/

#define CHA14_to_i_(x) ((int)(x))

#define INT15_u_mod_(x,y) (((unsigned int)(x))%(y))
#define INT15_to_r_(x) ((float)(x))
#define INT15_to_d_(x) ((double)(x))
#define INT15_to_c_(x) ((char)(x))
#define INT15_bit_and_(x,y) ((x)&(y))
#define INT15_bit_or_(x,y) ((x)|(y))
#define INT15_bit_xor_(x,y) ((x)^(y))
#define INT15_bit_not_(x) (~(x))
#define INT15_lshift_(x,i) ((x)<<(i))
#define INT15_rshift_(x,i) (((unsigned int)(x))>>(i))
#define INT15_arith_rshift_(x,i) ((x)>>(i))

#define REA17_to_d_(r) ((double)(r))
#define REA17_to_i_(r) ((int)(r))

#define DOU18_to_r_(d) ((float)(d))
#define DOU18_to_i_(d) ((int)(d))

#define ob_id(p) ((int)(p))
#define id_ob(p) ((ptr)(p))
