/* * Last edited: May 29 23:26 1991 (bilmes) */
/* File: sather/lib/base/C/file_.c
   Author: Chu-Cheow Lim and Stephen M. Omohundro
   Created: Thu Sep 20 14:41:17 1990
   Copyright (C) International Computer Science Institute, 1990

   COPYRIGHT NOTICE: This code is provided "AS IS" WITHOUT ANY WARRANTY
   and is subject to the terms of the SATHER LIBRARY GENERAL PUBLIC
   LICENSE contained in the file: "sather/doc/license.txt" of the Sather
   distribution. The license is also available from ICSI, 1947 Center
   St., Suite 600, Berkeley CA 94704, USA.

   C functions to support file.sa.
*/

#include "all_.h"
#include <stdio.h>

ptr stdin_() {return ((ptr)stdin);}
ptr stdout_() {return ((ptr)stdout);}
ptr stderr_() {return ((ptr)stderr);}

static int scanf_val=1;		/* What the last scanf returned. */
/* Return and clear scanf_val. */
int scanf_val_() {int sv=scanf_val; scanf_val=1; return(sv);}

/* A function version of the macro getc. */
int get_ci_(fp) FILE *fp;{return(getc(fp));}

/* Check if eof has been read. */
bool check_eof_(fp) FILE *fp;
{if (feof(fp)) {return((bool)1);} return((bool)0);}

/* Read an int from the file fp. */
int fscanfi_(fp) FILE *fp;
{int i; fscanf(fp, "%d", &i); return (i);}
/* Since the resetting of "scanf_val" appears not to be working, 
we ignore it for now.*/
/*{int i; scanf_val=fscanf(fp, "%d", &i); return (i);} */

/* Read a double from the file fp. */
double fscanfd_(fp) FILE *fp;
{double d; fscanf(fp, "%lf", &d); return (d);}
/* Since the resetting of "scanf_val" appears not to be working, 
we ignore it for now.*/
/*{double d; scanf_val=fscanf(fp, "%lf", &d); return (d);} */

/* Print a char, int, string, or double onto file. */
fprintfi_(fp,in) FILE *fp; int in; {fprintf(fp,"%d",in);}
fprintfs_(fp,st) FILE *fp; char *st; {fprintf(fp,"%s",st);}
fprintfd_(fp,dou) FILE *fp; double dou; {fprintf(fp,"%lf",dou);}

/* Open a file for reading, writing, or appending. */
ptr fopenr_(s) char *s; {return((ptr)fopen(s,"r"));} 
ptr fopenw_(s) char *s; {return((ptr)fopen(s,"w"));} 
ptr fopena_(s) char *s; {return((ptr)fopen(s,"a"));} 

/* Open pipes for reading and writing. */
ptr popenr_(c) char *c; {return((ptr)popen(c,"r"));}
ptr popenw_(c) char *c; {return((ptr)popen(c,"w"));}

