/*
**
** sdb support header file.
** 
*/


/*
 * some things taken from all_.h but modified to refer to inferior process
 *
 */

#define inf_CATT_(ob,off)  \
  lookup_ctype((CORE_ADDR)((ob)+(off)),CTYPE_CHAR_).c
#define inf_IATT_(ob,off)  \
  lookup_ctype((CORE_ADDR)((ob)+(off)),CTYPE_INT_).i
#define inf_FATT_(ob,off)  \
  lookup_ctype((CORE_ADDR)((ob)+(off)),CTYPE_FLOAT_).f
#define inf_DATT_(ob,off)  \
  lookup_ctype((CORE_ADDR)((ob)+(off)),CTYPE_DOUBLE_).d
#define inf_PATT_(ob,off)  \
  lookup_ctype((CORE_ADDR)((ob)+(off)),CTYPE_PTR_).p


/* definitions for C to lookup in inferior processes attr table */
#define inf_ob_base_size_(type) lookup_attr_table((type),0)
#define inf_ob_arr_dim_(type) lookup_attr_table((type),1)
#define inf_cl_arr_satype_(i) lookup_feat_table((i),2)
#define inf_cl_feat_num_(i) lookup_feat_table((i),0)
#define inf_cl_feat_name_(i,j) lookup_feat_table((i),4 + (j))
#define inf_cl_feat_cat_(i,j) \
  lookup_feat_table((i),4 + inf_cl_feat_num_((i)) + (j))
#define inf_cl_feat_satype_(i,j) \
  lookup_feat_table((i),4 + (2 * inf_cl_feat_num_((i))) + j)



#define inf_TYPE_(ob) inf_IATT_((ob),0)


/* definitions for array access from C:
** to use (for example, to get to element i,j,k,l of a double array p
** do: (note, last index in ARR macros is for uniformity).
**        inf_DATT_(p,inf_ARR4_(p,i,j,k,l)+SD*l);
*/
#define inf_ARR1_(ob_,indx1_) \
	 (inf_ob_base_size_(inf_TYPE_(ob_)) + 1*SI_)

#define inf_ARR2_(ob_,indx1_,indx2_) \
	 inf_IATT_((ob_), \
	       inf_ob_base_size_(inf_TYPE_(ob_)) + 2*SI_ + (SI_ * (indx1_)))

#define inf_ARR3_(ob_,indx1_,indx2_,indx3_) \
	 inf_IATT_((ob_), \
	       inf_IATT_((ob_), \
		     inf_ob_base_size_(inf_TYPE_(ob_)) + 3*SI_ + (SI_ * (indx1_))) \
	       + (SI_ * (indx2_)))

#define inf_ARR4_(ob_,indx1_,indx2_,indx3_,indx4_) \
	 inf_IATT_((ob_), \
	       inf_IATT_((ob_), \
		     inf_IATT_((ob_), \
			   inf_ob_base_size_(inf_TYPE_(ob_)) + 4*SI_ + (SI_ * (indx1_))) \
		     + (SI_ * (indx2_))) \
	       + (SI_ * (indx3_)))

/* array dimension sizes from C */
#define inf_ARRD1_(ob_) \
    lookup_ctype((ptr)(ob_)+inf_ob_base_size_(inf_TYPE_(ob_)),CTYPE_INT_).i
#define inf_ARRD2_(ob_) \
    lookup_ctype((ptr)(ob_)+SI_+inf_ob_base_size_(inf_TYPE_(ob_)),CTYPE_INT_).i
#define inf_ARRD3_(ob_) \
    lookup_ctype((ptr)(ob_)+2*SI_+inf_ob_base_size_(inf_TYPE_(ob_)),CTYPE_INT_).i
#define inf_ARRD4_(ob_) \
    lookup_ctype((ptr)(ob_)+3*SI_+inf_ob_base_size_(inf_TYPE_(ob_)),CTYPE_INT_).i

#if 0
#define inf_ARRD1_(ob_) \
    (*((int *)((ptr)(ob_)+inf_ob_base_size_(inf_TYPE_(ob_)))))
#define inf_ARRD2_(ob_) \
    (*((int *)((ptr)(ob_)+SI_+inf_ob_base_size_(inf_TYPE_(ob_)))))
#define inf_ARRD3_(ob_) \
    (*((int *)((ptr)(ob_)+2*SI_+inf_ob_base_size_(inf_TYPE_(ob_)))))
#define inf_ARRD4_(ob_) \
    (*((int *)((ptr)(ob_)+3*SI_+inf_ob_base_size_(inf_TYPE_(ob_)))))
#endif







